/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.common.JsonUtils;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.services.custom.InputTypeTranslator;
import org.elasticsearch.xpack.inference.services.custom.request.RequestParameters;

public class EmbeddingParameters
extends RequestParameters {
    private static final String INPUT_TYPE = "input_type";
    private final InputType inputType;
    private final InputTypeTranslator translator;

    public static EmbeddingParameters of(EmbeddingsInput embeddingsInput, InputTypeTranslator inputTypeTranslator) {
        return new EmbeddingParameters(Objects.requireNonNull(embeddingsInput), Objects.requireNonNull(inputTypeTranslator));
    }

    private EmbeddingParameters(EmbeddingsInput embeddingsInput, InputTypeTranslator translator) {
        super(embeddingsInput.getStringInputs());
        this.inputType = embeddingsInput.getInputType();
        this.translator = translator;
    }

    @Override
    protected Map<String, String> taskTypeParameters() {
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        if (this.inputType != null && this.translator.getTranslation().containsKey(this.inputType)) {
            String inputTypeTranslation = this.translator.getTranslation().get(this.inputType);
            additionalParameters.put(INPUT_TYPE, JsonUtils.toJson(inputTypeTranslation, INPUT_TYPE));
        } else {
            additionalParameters.put(INPUT_TYPE, JsonUtils.toJson(this.translator.getDefaultValue(), INPUT_TYPE));
        }
        return additionalParameters;
    }
}

