/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class CustomTaskSettings
implements TaskSettings {
    public static final String NAME = "custom_task_settings";
    public static final String PARAMETERS = "parameters";
    static final CustomTaskSettings EMPTY_SETTINGS = new CustomTaskSettings(new HashMap<String, Object>());
    private final Map<String, Object> parameters;

    public static CustomTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Map<String, Object> parameters = ServiceUtils.extractOptionalMap(map, PARAMETERS, "task_settings", validationException);
        ServiceUtils.removeNullValues(parameters);
        ServiceUtils.validateMapValues(parameters, List.of(String.class, Integer.class, Double.class, Float.class, Boolean.class), PARAMETERS, validationException, false);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CustomTaskSettings(Objects.requireNonNullElse(parameters, new HashMap()));
    }

    public static CustomTaskSettings of(CustomTaskSettings originalSettings, CustomTaskSettings requestTaskSettings) {
        HashMap<String, Object> copy = new HashMap<String, Object>(originalSettings.parameters);
        requestTaskSettings.parameters.forEach((key, value) -> copy.merge((String)key, value, (originalValue, requestValue) -> requestValue));
        return new CustomTaskSettings(copy);
    }

    public CustomTaskSettings(StreamInput in) throws IOException {
        this.parameters = in.readGenericMap();
    }

    public CustomTaskSettings(Map<String, Object> parameters) {
        this.parameters = Objects.requireNonNull(parameters);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.parameters.isEmpty()) {
            builder.field(PARAMETERS, this.parameters);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return TransportVersions.INFERENCE_CUSTOM_SERVICE_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.INFERENCE_CUSTOM_SERVICE_ADDED) || version.isPatchFrom(TransportVersions.INFERENCE_CUSTOM_SERVICE_ADDED_8_19);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomTaskSettings that = (CustomTaskSettings)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        CustomTaskSettings updatedSettings = CustomTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return CustomTaskSettings.of(this, updatedSettings);
    }
}

