/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.BaseRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.services.custom.CustomModel;
import org.elasticsearch.xpack.inference.services.custom.CustomResponseHandler;
import org.elasticsearch.xpack.inference.services.custom.request.CompletionParameters;
import org.elasticsearch.xpack.inference.services.custom.request.CustomRequest;
import org.elasticsearch.xpack.inference.services.custom.request.EmbeddingParameters;
import org.elasticsearch.xpack.inference.services.custom.request.RequestParameters;
import org.elasticsearch.xpack.inference.services.custom.request.RerankParameters;
import org.elasticsearch.xpack.inference.services.custom.response.CustomResponseEntity;

public class CustomRequestManager
extends BaseRequestManager {
    private static final Logger logger = LogManager.getLogger(CustomRequestManager.class);
    private final CustomModel model;
    private final ResponseHandler handler;

    private static ResponseHandler createCustomHandler() {
        return new CustomResponseHandler("custom model", CustomResponseEntity::fromResponse);
    }

    public static CustomRequestManager of(CustomModel model, ThreadPool threadPool) {
        return new CustomRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(threadPool));
    }

    private CustomRequestManager(CustomModel model, ThreadPool threadPool) {
        super(threadPool, model.getInferenceEntityId(), RateLimitGrouping.of(model), model.rateLimitServiceSettings().rateLimitSettings());
        this.model = model;
        this.handler = CustomRequestManager.createCustomHandler();
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        RequestParameters requestParameters;
        if (inferenceInputs instanceof QueryAndDocsInputs) {
            requestParameters = RerankParameters.of(QueryAndDocsInputs.of(inferenceInputs));
        } else if (inferenceInputs instanceof ChatCompletionInput) {
            ChatCompletionInput chatInputs = (ChatCompletionInput)inferenceInputs;
            requestParameters = CompletionParameters.of(chatInputs);
        } else if (inferenceInputs instanceof EmbeddingsInput) {
            requestParameters = EmbeddingParameters.of(EmbeddingsInput.of(inferenceInputs), this.model.getServiceSettings().getInputTypeTranslator());
        } else {
            listener.onFailure((Exception)new ElasticsearchStatusException(Strings.format((String)"Invalid input received from custom service %s", (Object[])new Object[]{inferenceInputs.getClass().getSimpleName()}), RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        try {
            CustomRequest request = new CustomRequest(requestParameters, this.model);
            this.execute(new ExecutableInferenceRequest(requestSender, logger, request, this.handler, hasRequestCompletedFunction, listener));
        }
        catch (Exception e) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Failed to construct the custom service request", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
        }
    }

    record RateLimitGrouping(int apiKeyHash) {
        public static RateLimitGrouping of(CustomModel model) {
            Objects.requireNonNull(model);
            return new RateLimitGrouping(model.rateLimitServiceSettings().hashCode());
        }
    }
}

