/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class CohereCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
CohereRateLimitServiceSettings {
    public static final String NAME = "cohere_completion_service_settings";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(10000L);
    private final URI uri;
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;
    private final CohereServiceSettings.CohereApiVersion apiVersion;

    public static CohereCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "cohere", context);
        String modelId = ServiceUtils.extractOptionalString(map, "model_id", "service_settings", validationException);
        CohereServiceSettings.CohereApiVersion apiVersion = CohereServiceSettings.apiVersionFromMap(map, context, validationException);
        if (apiVersion == CohereServiceSettings.CohereApiVersion.V2 && modelId == null) {
            validationException.addValidationError("The [service_settings.model_id] field is required for the Cohere V2 API.");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereCompletionServiceSettings(uri, modelId, rateLimitSettings, apiVersion);
    }

    public CohereCompletionServiceSettings(@Nullable URI uri, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings, CohereServiceSettings.CohereApiVersion apiVersion) {
        this.uri = uri;
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
        this.apiVersion = apiVersion;
    }

    public CohereCompletionServiceSettings(@Nullable String url, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings, CohereServiceSettings.CohereApiVersion apiVersion) {
        this(ServiceUtils.createOptionalUri(url), modelId, rateLimitSettings, apiVersion);
    }

    public CohereCompletionServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.modelId = in.readOptionalString();
        this.rateLimitSettings = new RateLimitSettings(in);
        this.apiVersion = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_COHERE_API_VERSION) || in.getTransportVersion().isPatchFrom(TransportVersions.ML_INFERENCE_COHERE_API_VERSION_8_19) ? (CohereServiceSettings.CohereApiVersion)in.readEnum(CohereServiceSettings.CohereApiVersion.class) : CohereServiceSettings.CohereApiVersion.V1;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public CohereServiceSettings.CohereApiVersion apiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    public String modelId() {
        return this.modelId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.field("api_version", (Enum)this.apiVersion);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        String uriToWrite = this.uri != null ? this.uri.toString() : null;
        out.writeOptionalString(uriToWrite);
        out.writeOptionalString(this.modelId);
        this.rateLimitSettings.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_COHERE_API_VERSION) || out.getTransportVersion().isPatchFrom(TransportVersions.ML_INFERENCE_COHERE_API_VERSION_8_19)) {
            out.writeEnum((Enum)this.apiVersion);
        }
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.modelId != null) {
            builder.field("model_id", this.modelId);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CohereCompletionServiceSettings that = (CohereCompletionServiceSettings)object;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && this.apiVersion == that.apiVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.modelId, this.rateLimitSettings, this.apiVersion});
    }
}

