/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RemoteConnectionInfo
implements ToXContentFragment,
Writeable {
    final ModeInfo modeInfo;
    final TimeValue initialConnectionTimeout;
    final String clusterAlias;
    final boolean skipUnavailable;
    final boolean hasClusterCredentials;

    public RemoteConnectionInfo(String clusterAlias, ModeInfo modeInfo, TimeValue initialConnectionTimeout, boolean skipUnavailable, boolean hasClusterCredentials) {
        this.clusterAlias = clusterAlias;
        this.modeInfo = modeInfo;
        this.initialConnectionTimeout = initialConnectionTimeout;
        this.skipUnavailable = skipUnavailable;
        this.hasClusterCredentials = hasClusterCredentials;
    }

    public RemoteConnectionInfo(StreamInput input) throws IOException {
        RemoteConnectionStrategy.ConnectionStrategy mode = input.readEnum(RemoteConnectionStrategy.ConnectionStrategy.class);
        this.modeInfo = mode.getReader().read(input);
        this.initialConnectionTimeout = input.readTimeValue();
        this.clusterAlias = input.readString();
        this.skipUnavailable = input.readBoolean();
        this.hasClusterCredentials = input.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? input.readBoolean() : false;
    }

    public boolean isConnected() {
        return this.modeInfo.isConnected();
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ModeInfo getModeInfo() {
        return this.modeInfo;
    }

    public boolean hasClusterCredentials() {
        return this.hasClusterCredentials;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.modeInfo.modeType());
        this.modeInfo.writeTo(out);
        out.writeTimeValue(this.initialConnectionTimeout);
        out.writeString(this.clusterAlias);
        out.writeBoolean(this.skipUnavailable);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeBoolean(this.hasClusterCredentials);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.clusterAlias);
        builder.field("connected", this.modeInfo.isConnected());
        builder.field("mode", this.modeInfo.modeName());
        this.modeInfo.toXContent(builder, params);
        builder.field("initial_connect_timeout", (Object)this.initialConnectionTimeout);
        builder.field("skip_unavailable", this.skipUnavailable);
        if (this.hasClusterCredentials) {
            builder.field("cluster_credentials", "::es_redacted::");
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.skipUnavailable == that.skipUnavailable && Objects.equals(this.modeInfo, that.modeInfo) && Objects.equals(this.initialConnectionTimeout, that.initialConnectionTimeout) && Objects.equals(this.clusterAlias, that.clusterAlias) && this.hasClusterCredentials == that.hasClusterCredentials;
    }

    public int hashCode() {
        return Objects.hash(this.modeInfo, this.initialConnectionTimeout, this.clusterAlias, this.skipUnavailable, this.hasClusterCredentials);
    }

    public static interface ModeInfo
    extends ToXContentFragment,
    Writeable {
        public boolean isConnected();

        public String modeName();

        public RemoteConnectionStrategy.ConnectionStrategy modeType();
    }
}

