/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;

public final class ScheduledExecutorServiceScheduler
implements Scheduler {
    private final ScheduledExecutorService executor;

    public ScheduledExecutorServiceScheduler(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Scheduler.ScheduledCancellable schedule(Runnable command, TimeValue delay, Executor unused) {
        assert (unused == EsExecutors.DIRECT_EXECUTOR_SERVICE) : "ScheduledExecutorServiceScheduler never forks, don't even try";
        return Scheduler.wrapAsScheduledCancellable(this.executor.schedule(command, delay.millis(), TimeUnit.MILLISECONDS));
    }
}

