/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.countedterms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.countedterms.CountedTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.countedterms.CountedTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.countedterms.CountedTermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

class CountedTermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final BucketOrder order = BucketOrder.count(false);
    private final CountedTermsAggregatorSupplier supplier;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(CountedTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD), CountedTermsAggregatorFactory.bytesSupplier(), true);
    }

    static CountedTermsAggregatorSupplier bytesSupplier() {
        return (name, factories, valuesSourceConfig, order, bucketCountThresholds, context, parent, cardinality, metadata) -> {
            assert (valuesSourceConfig.getValuesSource() instanceof ValuesSource.Bytes.WithOrdinals);
            ValuesSource.Bytes.WithOrdinals ordinalsValuesSource = (ValuesSource.Bytes.WithOrdinals)valuesSourceConfig.getValuesSource();
            return new CountedTermsAggregator(name, factories, ordinalsValuesSource, order, valuesSourceConfig.format(), bucketCountThresholds, context, parent, cardinality, metadata);
        };
    }

    CountedTermsAggregatorFactory(String name, ValuesSourceConfig config, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, CountedTermsAggregatorSupplier supplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.bucketCountThresholds = bucketCountThresholds;
        this.supplier = supplier;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        return new NonCollectingAggregator(this, this.name, this.context, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        this.bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(this.bucketCountThresholds.getRequiredSize()));
        if (this.getSamplingContext().map(SamplingContext::isSampled).orElse(false).booleanValue() && (this.bucketCountThresholds.getMinDocCount() > 1L || this.bucketCountThresholds.getShardMinDocCount() > 1L)) {
            throw new ElasticsearchStatusException("aggregation [{}] is within a sampling context; min_doc_count, provided [{}], and min_shard_doc_count, provided [{}], cannot be greater than 1", RestStatus.BAD_REQUEST, this.name(), this.bucketCountThresholds.getMinDocCount(), this.bucketCountThresholds.getShardMinDocCount());
        }
        this.bucketCountThresholds.ensureValidity();
        return this.supplier.build(this.name, this.factories, this.config, this.order, this.bucketCountThresholds, this.context, parent, cardinality, metadata);
    }
}

