/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.desirednodes.TransportDeleteDesiredNodesAction;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestDeleteDesiredNodesAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "delete_desired_nodes";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "_internal/desired_nodes"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        AcknowledgedRequest.Plain deleteDesiredNodesRequest = new AcknowledgedRequest.Plain(RestUtils.getMasterNodeTimeout(request), RestUtils.getAckTimeout(request));
        return restChannel -> client.execute(TransportDeleteDesiredNodesAction.TYPE, deleteDesiredNodesRequest, new RestToXContentListener((RestChannel)restChannel));
    }
}

