/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.Version;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenizer
extends PreConfiguredAnalysisComponent<TokenizerFactory> {
    private final Function<IndexVersion, Tokenizer> create;

    public static PreConfiguredTokenizer singleton(String name, Supplier<Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.ONE, version -> (Tokenizer)create.get());
    }

    public static PreConfiguredTokenizer luceneVersion(String name, Function<Version, Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.LUCENE, create.compose(IndexVersion::luceneVersion));
    }

    public static PreConfiguredTokenizer indexVersion(String name, Function<IndexVersion, Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.INDEX, create);
    }

    private PreConfiguredTokenizer(String name, PreBuiltCacheFactory.CachingStrategy cache, Function<IndexVersion, Tokenizer> create) {
        super(name, cache);
        this.create = create;
    }

    @Override
    protected TokenizerFactory create(IndexVersion version) {
        return TokenizerFactory.newFactory(this.name, () -> this.create.apply(version));
    }
}

