/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.elasticsearch.common.regex.Regex;

public class URIPattern {
    private final URI uriPattern;

    public URIPattern(String pattern) {
        try {
            this.uriPattern = new URI(pattern);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("cannot parse URI pattern [" + pattern + "]");
        }
    }

    public boolean match(URI uri) {
        return this.matchNormalized(uri.normalize());
    }

    public static boolean match(URIPattern[] patterns, URI uri) {
        URI normalized = uri.normalize();
        for (URIPattern pattern : patterns) {
            if (!pattern.matchNormalized(normalized)) continue;
            return true;
        }
        return false;
    }

    private boolean matchNormalized(URI uri) {
        if (this.uriPattern.isOpaque()) {
            return uri.isOpaque() && URIPattern.match(this.uriPattern.getScheme(), uri.getScheme()) && URIPattern.match(this.uriPattern.getSchemeSpecificPart(), uri.getSchemeSpecificPart()) && URIPattern.match(this.uriPattern.getFragment(), uri.getFragment());
        }
        return URIPattern.match(this.uriPattern.getScheme(), uri.getScheme()) && URIPattern.match(this.uriPattern.getAuthority(), uri.getAuthority()) && URIPattern.match(this.uriPattern.getQuery(), uri.getQuery()) && URIPattern.match(this.uriPattern.getPath(), uri.getPath()) && URIPattern.match(this.uriPattern.getFragment(), uri.getFragment());
    }

    private static boolean match(String pattern, String value) {
        if (value == null && (pattern == null || Regex.isMatchAllPattern(pattern))) {
            return true;
        }
        return Regex.simpleMatch(pattern, value);
    }

    public String toString() {
        return this.uriPattern.toString();
    }
}

