/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.elasticsearch.ElasticsearchAuthenticationProcessingError;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchRoleRestrictionException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceAlreadyUploadedException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.PrimaryMissingActionException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.client.internal.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.NodeHealthCheckFailureException;
import org.elasticsearch.cluster.desirednodes.VersionConflictException;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.RoutingException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.health.node.action.HealthNodeNotDiscoveredException;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpException;
import org.elasticsearch.http.HttpHeadersValidationException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.index.snapshots.IndexShardRestoreException;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.AutoscalingMissedIndicesUpdateException;
import org.elasticsearch.indices.FailureIndexNotSupportedException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndexPrimaryShardNotAllocatedException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.PeerRecoveryNotFound;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryCommitTooNewException;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.ingest.GraphStructureException;
import org.elasticsearch.ingest.IngestPipelineException;
import org.elasticsearch.ingest.IngestProcessorException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.persistent.NotPersistentTaskNodeException;
import org.elasticsearch.persistent.PersistentTaskNodeNotAssignedException;
import org.elasticsearch.repositories.RepositoryConflictException;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.rest.ApiNotAvailableException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.TooManyScrollContextsException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.UnsupportedAggregationOnDownsampledIndex;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.SearchTimeoutException;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotNameAlreadyInUseException;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ActionTransportException;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NoSeedNodeLeftException;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class ElasticsearchException
extends RuntimeException
implements ToXContentFragment,
Writeable {
    private static final TransportVersion UNKNOWN_VERSION_ADDED = TransportVersions.ZERO;
    public static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    private static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String INDEX_METADATA_KEY = "es.index";
    private static final String INDEX_METADATA_KEY_UUID = "es.index_uuid";
    private static final String SHARD_METADATA_KEY = "es.shard";
    private static final String RESOURCE_METADATA_TYPE_KEY = "es.resource.type";
    private static final String RESOURCE_METADATA_ID_KEY = "es.resource.id";
    private static final String TYPE = "type";
    private static final String REASON = "reason";
    private static final String TIMED_OUT = "timed_out";
    private static final String CAUSED_BY = "caused_by";
    private static final ParseField SUPPRESSED = new ParseField("suppressed", new String[0]);
    public static final String STACK_TRACE = "stack_trace";
    private static final String HEADER = "header";
    private static final String ERROR = "error";
    private static final String ROOT_CAUSE = "root_cause";
    static final String TIMED_OUT_HEADER = "X-Timed-Out";
    private static final Map<Integer, CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException>> ID_TO_SUPPLIER = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.id, e -> e.constructor)));
    private static final Map<Class<? extends ElasticsearchException>, ElasticsearchExceptionHandle> CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.exceptionClass, e -> e)));
    private final Map<String, List<String>> metadata = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private static final int MAX_NESTED_EXCEPTION_LEVEL = 100;

    public ElasticsearchException(Throwable cause) {
        super(cause);
        this.maybePutTimeoutHeader();
    }

    public ElasticsearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
        this.maybePutTimeoutHeader();
    }

    public ElasticsearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
        this.maybePutTimeoutHeader();
    }

    public ElasticsearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readException());
        ElasticsearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString));
        this.metadata.putAll(in.readMapOfLists(StreamInput::readString));
    }

    private void maybePutTimeoutHeader() {
        if (this.isTimeout()) {
            this.headers.put(TIMED_OUT_HEADER, List.of("?1"));
        }
    }

    public void addMetadata(String key, String ... values) {
        this.addMetadata(key, Arrays.asList(values));
    }

    public void addMetadata(String key, List<String> values) {
        if (!key.startsWith("es.")) {
            throw new IllegalArgumentException("exception metadata must start with [es.], found [" + key + "] instead");
        }
        this.metadata.put(key, values);
    }

    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    public List<String> getMetadata(String key) {
        return this.metadata.get(key);
    }

    protected Map<String, List<String>> getMetadata() {
        return this.metadata;
    }

    public void addHeader(String key, List<String> value) {
        if (key.startsWith("es.")) {
            throw new IllegalArgumentException("exception headers must not start with [es.], found [" + key + "] instead");
        }
        this.headers.put(key, value);
    }

    public void addHeader(String key, String ... value) {
        this.addHeader(key, Arrays.asList(value));
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    protected Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return ExceptionsHelper.status(cause);
    }

    public boolean isTimeout() {
        return false;
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        this.writeTo(out, ElasticsearchException.createNestingFunction(0, () -> {}));
    }

    private static Writeable.Writer<Throwable> createNestingFunction(int thisLevel, Runnable nestedExceptionLimitCallback) {
        int nextLevel = thisLevel + 1;
        return (o, t) -> {
            ElasticsearchException.writeException(t.getCause(), o, nextLevel, nestedExceptionLimitCallback);
            ElasticsearchException.writeStackTraces(t, o, (no, nt) -> ElasticsearchException.writeException(nt, no, nextLevel, nestedExceptionLimitCallback));
        };
    }

    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        out.writeOptionalString(this.getMessage());
        nestedExceptionsWriter.write(out, this);
        out.writeMap(this.headers, StreamOutput::writeStringCollection);
        out.writeMap(this.metadata, StreamOutput::writeStringCollection);
    }

    public static ElasticsearchException readException(StreamInput input, int id) throws IOException {
        CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException> elasticsearchException = ID_TO_SUPPLIER.get(id);
        if (elasticsearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return (ElasticsearchException)elasticsearchException.apply((Object)input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRegistered(Class<? extends Throwable> exception, TransportVersion version) {
        ElasticsearchExceptionHandle elasticsearchExceptionHandle = CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception);
        if (elasticsearchExceptionHandle == null) return false;
        if (version.onOrAfter(elasticsearchExceptionHandle.versionAdded)) return true;
        if (!Arrays.stream(elasticsearchExceptionHandle.patchVersions).anyMatch(version::isPatchFrom)) return false;
        return true;
    }

    static Set<Class<? extends ElasticsearchException>> getRegisteredKeys() {
        return CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.keySet();
    }

    public static int getId(Class<? extends ElasticsearchException> exception) {
        return ElasticsearchException.CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception).id;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, 0);
    }

    protected XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, int nestedLevel) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            ElasticsearchException.generateThrowableXContent(builder, params, this, nestedLevel);
        } else {
            ElasticsearchException.innerToXContent(builder, params, this, this.getExceptionName(), this.getMessage(), this.headers, this.metadata, this.getCause(), nestedLevel);
        }
        return builder;
    }

    protected static void innerToXContent(XContentBuilder builder, ToXContent.Params params, Throwable throwable, String type, String message, Map<String, List<String>> headers, Map<String, List<String>> metadata, Throwable cause, int nestedLevel) throws IOException {
        Throwable[] allSuppressed;
        Iterator<Map.Entry<String, List<String>>> exception;
        if (nestedLevel > 100) {
            IllegalStateException terminalException = new IllegalStateException("too many nested exceptions");
            builder.field(TYPE, ElasticsearchException.getExceptionName(terminalException));
            builder.field(REASON, terminalException.getMessage());
            return;
        }
        builder.field(TYPE, type);
        builder.field(REASON, message);
        boolean timedOut = false;
        if (throwable instanceof ElasticsearchException) {
            exception = (ElasticsearchException)throwable;
            timedOut = ((ElasticsearchException)((Object)exception)).isTimeout();
        }
        if (timedOut) {
            builder.field(TIMED_OUT, timedOut);
        }
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            ElasticsearchException.headerToXContent(builder, ((String)entry.getKey()).substring("es.".length()), (List)entry.getValue());
        }
        if (throwable instanceof ElasticsearchException) {
            exception = (ElasticsearchException)throwable;
            ((ElasticsearchException)((Object)exception)).metadataToXContent(builder, params);
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false) && cause != null) {
            builder.field(CAUSED_BY);
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, cause, nestedLevel + 1);
            builder.endObject();
        }
        if (!headers.isEmpty()) {
            builder.startObject(HEADER);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                ElasticsearchException.headerToXContent(builder, entry.getKey(), entry.getValue());
            }
            builder.endObject();
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
            builder.field(STACK_TRACE, ExceptionsHelper.stackTrace(throwable));
        }
        if ((allSuppressed = throwable.getSuppressed()).length > 0) {
            builder.startArray(SUPPRESSED.getPreferredName());
            for (Throwable suppressed : allSuppressed) {
                builder.startObject();
                ElasticsearchException.generateThrowableXContent(builder, params, suppressed, nestedLevel + 1);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    private static void headerToXContent(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static ElasticsearchException fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        return ElasticsearchException.innerFromXContent(parser, false);
    }

    public static ElasticsearchException innerFromXContent(XContentParser parser, boolean parseRootCauses) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String type = null;
        String reason = null;
        String stack = null;
        ElasticsearchException cause = null;
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        ArrayList<ElasticsearchException> rootCauses = new ArrayList<ElasticsearchException>();
        ArrayList<ElasticsearchException> suppressed = new ArrayList<ElasticsearchException>();
        while (token == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (TYPE.equals(currentFieldName)) {
                    type = parser.text();
                } else if (REASON.equals(currentFieldName)) {
                    reason = parser.text();
                } else if (STACK_TRACE.equals(currentFieldName)) {
                    stack = parser.text();
                } else if (token == XContentParser.Token.VALUE_STRING) {
                    metadata.put(currentFieldName, Collections.singletonList(parser.text()));
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (CAUSED_BY.equals(currentFieldName)) {
                    cause = ElasticsearchException.fromXContent(parser);
                } else if (HEADER.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        values = headers.getOrDefault(currentFieldName, new ArrayList());
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                        } else if (token == XContentParser.Token.START_ARRAY) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                if (token == XContentParser.Token.VALUE_STRING) {
                                    values.add(parser.text());
                                    continue;
                                }
                                parser.skipChildren();
                            }
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.skipChildren();
                        }
                        headers.put(currentFieldName, values);
                    }
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                if (parseRootCauses && ROOT_CAUSE.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        rootCauses.add(ElasticsearchException.fromXContent(parser));
                    }
                } else if (SUPPRESSED.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        suppressed.add(ElasticsearchException.fromXContent(parser));
                    }
                } else {
                    values = new ArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                            continue;
                        }
                        parser.skipChildren();
                    }
                    if (values.size() > 0) {
                        if (metadata.containsKey(currentFieldName)) {
                            values.addAll((Collection)metadata.get(currentFieldName));
                        }
                        metadata.put(currentFieldName, values);
                    }
                }
            }
            token = parser.nextToken();
        }
        ElasticsearchException e = new ElasticsearchException(ElasticsearchException.buildMessage(type, reason, stack), cause, new Object[0]);
        for (Map.Entry entry : metadata.entrySet()) {
            e.addMetadata("es." + (String)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry header : headers.entrySet()) {
            e.addHeader((String)header.getKey(), (List)header.getValue());
        }
        for (ElasticsearchException rootCause : rootCauses) {
            e.addSuppressed(rootCause);
        }
        for (ElasticsearchException s : suppressed) {
            e.addSuppressed(s);
        }
        return e;
    }

    public static void generateThrowableXContent(XContentBuilder builder, ToXContent.Params params, Throwable t) throws IOException {
        ElasticsearchException.generateThrowableXContent(builder, params, t, 0);
    }

    protected static void generateThrowableXContent(XContentBuilder builder, ToXContent.Params params, Throwable t, int nestedLevel) throws IOException {
        if ((t = ExceptionsHelper.unwrapCause(t)) instanceof ElasticsearchException) {
            ((ElasticsearchException)t).toXContent(builder, params, nestedLevel);
        } else {
            ElasticsearchException.innerToXContent(builder, params, t, ElasticsearchException.getExceptionName(t), t.getMessage(), Collections.emptyMap(), Collections.emptyMap(), t.getCause(), nestedLevel);
        }
    }

    public static XContentBuilder generateFailureXContent(XContentBuilder builder, ToXContent.Params params, @Nullable Exception e, boolean detailed) throws IOException {
        if (builder.getRestApiVersion() == RestApiVersion.V_8) {
            if (e == null) {
                return builder.field(ERROR, "unknown");
            }
            if (!detailed) {
                return ElasticsearchException.generateNonDetailedFailureXContentV8(builder, e);
            }
        }
        if (e == null) {
            builder.startObject(ERROR);
            builder.field(TYPE, "unknown");
            builder.field(REASON, "unknown");
            return builder.endObject();
        }
        if (!detailed) {
            Throwable t = ExceptionsHelper.unwrapCause(e);
            builder.startObject(ERROR);
            builder.field(TYPE, ElasticsearchException.getExceptionName(t));
            builder.field(REASON, t.getMessage());
            return builder.endObject();
        }
        ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(e);
        builder.startObject(ERROR);
        builder.startArray(ROOT_CAUSE);
        for (ElasticsearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, (ToXContent.Params)new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        ElasticsearchException.generateThrowableXContent(builder, params, e);
        return builder.endObject();
    }

    private static XContentBuilder generateNonDetailedFailureXContentV8(XContentBuilder builder, @Nullable Exception e) throws IOException {
        Object message = "No ElasticsearchException found";
        Throwable t = e;
        for (int counter = 0; counter < 10 && t != null; t = t.getCause(), ++counter) {
            if (!(t instanceof ElasticsearchException)) continue;
            message = t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
            break;
        }
        return builder.field(ERROR, (String)message);
    }

    public static ElasticsearchException failureFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureFieldName(parser, token, ERROR);
        token = parser.nextToken();
        if (token.isValue()) {
            return new ElasticsearchException(ElasticsearchException.buildMessage("exception", parser.text(), null), new Object[0]);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        token = parser.nextToken();
        return ElasticsearchException.innerFromXContent(parser, true);
    }

    public ElasticsearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).guessRootCauses();
        }
        return new ElasticsearchException[]{this};
    }

    public static ElasticsearchException[] guessRootCauses(Throwable t) {
        Throwable cause;
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof ElasticsearchException) {
            return ((ElasticsearchException)ex).guessRootCauses();
        }
        if (ex instanceof XContentParseException && (cause = ex.getCause()) != null && (cause instanceof XContentParseException || cause instanceof ElasticsearchException)) {
            return ElasticsearchException.guessRootCauses(ex.getCause());
        }
        return new ElasticsearchException[]{new ElasticsearchException(ex.getMessage(), ex, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 1.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return ElasticsearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("Elasticsearch")) {
            simpleName = simpleName.substring("Elasticsearch".length());
        }
        return ElasticsearchException.toUnderscoreCase(simpleName);
    }

    static String buildMessage(String type, String reason, String stack) {
        StringBuilder message = new StringBuilder("Elasticsearch exception [");
        message.append(TYPE).append('=').append(type);
        message.append(", ").append(REASON).append('=').append(reason);
        if (stack != null) {
            message.append(", ").append(STACK_TRACE).append('=').append(stack);
        }
        message.append(']');
        return message.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.metadata.containsKey(INDEX_METADATA_KEY)) {
            builder.append(this.getIndex());
            if (this.metadata.containsKey(SHARD_METADATA_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(super.toString().trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        throwable.setStackTrace(in.readArray(i -> {
            String declaringClasss = i.readString();
            String fileName = i.readOptionalString();
            String methodName = i.readString();
            int lineNumber = i.readVInt();
            return new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }, StackTraceElement[]::new));
        int numSuppressed = in.readVInt();
        for (int i2 = 0; i2 < numSuppressed; ++i2) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static void writeStackTraces(Throwable throwable, StreamOutput out, Writeable.Writer<Throwable> exceptionWriter) throws IOException {
        out.writeArray((o, v) -> {
            o.writeString(v.getClassName());
            o.writeOptionalString(v.getFileName());
            o.writeString(v.getMethodName());
            o.writeVInt(v.getLineNumber());
        }, throwable.getStackTrace());
        out.writeArray(exceptionWriter, throwable.getSuppressed());
    }

    public static void writeException(Throwable throwable, StreamOutput output) throws IOException {
        ElasticsearchException.writeException(throwable, output, () -> {});
    }

    static void writeException(Throwable throwable, StreamOutput output, Runnable nestedExceptionLimitCallback) throws IOException {
        ElasticsearchException.writeException(throwable, output, 0, nestedExceptionLimitCallback);
    }

    /*
     * Unable to fully structure code
     */
    private static void writeException(Throwable throwable, StreamOutput output, int nestedLevel, Runnable nestedExceptionLimitCallback) throws IOException {
        block23: {
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                block27: {
                                                                    block26: {
                                                                        block25: {
                                                                            block24: {
                                                                                block22: {
                                                                                    if (nestedLevel > 100) {
                                                                                        nestedExceptionLimitCallback.run();
                                                                                        ElasticsearchException.writeException(new IllegalStateException("too many nested exceptions"), output);
                                                                                        return;
                                                                                    }
                                                                                    if (throwable == null) {
                                                                                        output.writeBoolean(false);
                                                                                        return;
                                                                                    }
                                                                                    output.writeBoolean(true);
                                                                                    writeCause = true;
                                                                                    writeMessage = true;
                                                                                    if (!(throwable instanceof CorruptIndexException)) break block22;
                                                                                    cie = (CorruptIndexException)throwable;
                                                                                    output.writeVInt(1);
                                                                                    output.writeOptionalString(cie.getOriginalMessage());
                                                                                    output.writeOptionalString(cie.getResourceDescription());
                                                                                    writeMessage = false;
                                                                                    break block23;
                                                                                }
                                                                                if (!(throwable instanceof IndexFormatTooNewException)) break block24;
                                                                                iftne = (IndexFormatTooNewException)throwable;
                                                                                output.writeVInt(2);
                                                                                output.writeOptionalString(iftne.getResourceDescription());
                                                                                output.writeInt(iftne.getVersion());
                                                                                output.writeInt(iftne.getMinVersion());
                                                                                output.writeInt(iftne.getMaxVersion());
                                                                                writeMessage = false;
                                                                                writeCause = false;
                                                                                break block23;
                                                                            }
                                                                            if (!(throwable instanceof IndexFormatTooOldException)) break block25;
                                                                            t = (IndexFormatTooOldException)throwable;
                                                                            output.writeVInt(3);
                                                                            output.writeOptionalString(t.getResourceDescription());
                                                                            if (t.getVersion() == null) {
                                                                                output.writeBoolean(false);
                                                                                output.writeOptionalString(t.getReason());
                                                                            } else {
                                                                                output.writeBoolean(true);
                                                                                output.writeInt(t.getVersion());
                                                                                output.writeInt(t.getMinVersion());
                                                                                output.writeInt(t.getMaxVersion());
                                                                            }
                                                                            writeMessage = false;
                                                                            writeCause = false;
                                                                            break block23;
                                                                        }
                                                                        if (!(throwable instanceof NullPointerException)) break block26;
                                                                        output.writeVInt(4);
                                                                        writeCause = false;
                                                                        break block23;
                                                                    }
                                                                    if (!(throwable instanceof NumberFormatException)) break block27;
                                                                    output.writeVInt(5);
                                                                    writeCause = false;
                                                                    break block23;
                                                                }
                                                                if (!(throwable instanceof IllegalArgumentException)) break block28;
                                                                output.writeVInt(6);
                                                                break block23;
                                                            }
                                                            if (!(throwable instanceof AlreadyClosedException)) break block29;
                                                            output.writeVInt(7);
                                                            break block23;
                                                        }
                                                        if (!(throwable instanceof EOFException)) break block30;
                                                        output.writeVInt(8);
                                                        writeCause = false;
                                                        break block23;
                                                    }
                                                    if (!(throwable instanceof SecurityException)) break block31;
                                                    output.writeVInt(9);
                                                    break block23;
                                                }
                                                if (!(throwable instanceof StringIndexOutOfBoundsException)) break block32;
                                                output.writeVInt(10);
                                                writeCause = false;
                                                break block23;
                                            }
                                            if (!(throwable instanceof ArrayIndexOutOfBoundsException)) break block33;
                                            output.writeVInt(11);
                                            writeCause = false;
                                            break block23;
                                        }
                                        if (!(throwable instanceof FileNotFoundException)) break block34;
                                        output.writeVInt(12);
                                        writeCause = false;
                                        break block23;
                                    }
                                    if (!(throwable instanceof FileSystemException)) break block35;
                                    fse = (FileSystemException)throwable;
                                    output.writeVInt(13);
                                    if (throwable instanceof NoSuchFileException) {
                                        output.writeVInt(0);
                                    } else if (throwable instanceof NotDirectoryException) {
                                        output.writeVInt(1);
                                    } else if (throwable instanceof DirectoryNotEmptyException) {
                                        output.writeVInt(2);
                                    } else if (throwable instanceof AtomicMoveNotSupportedException) {
                                        output.writeVInt(3);
                                    } else if (throwable instanceof FileAlreadyExistsException) {
                                        output.writeVInt(4);
                                    } else if (throwable instanceof AccessDeniedException) {
                                        output.writeVInt(5);
                                    } else if (throwable instanceof FileSystemLoopException) {
                                        output.writeVInt(6);
                                    } else {
                                        output.writeVInt(7);
                                    }
                                    output.writeOptionalString(fse.getFile());
                                    output.writeOptionalString(fse.getOtherFile());
                                    output.writeOptionalString(fse.getReason());
                                    writeCause = false;
                                    break block23;
                                }
                                if (!(throwable instanceof IllegalStateException)) break block36;
                                output.writeVInt(14);
                                break block23;
                            }
                            if (!(throwable instanceof LockObtainFailedException)) break block37;
                            output.writeVInt(15);
                            break block23;
                        }
                        if (!(throwable instanceof InterruptedException)) break block38;
                        output.writeVInt(16);
                        writeCause = false;
                        break block23;
                    }
                    if (!(throwable instanceof IOException)) break block39;
                    output.writeVInt(17);
                    break block23;
                }
                if (!(throwable instanceof EsRejectedExecutionException)) break block40;
                eree = (EsRejectedExecutionException)throwable;
                output.writeVInt(18);
                output.writeBoolean(eree.isExecutorShutdown());
                writeCause = false;
                break block23;
            }
            if (!(throwable instanceof ElasticsearchException)) ** GOTO lbl-1000
            ee = (ElasticsearchException)throwable;
            if (ElasticsearchException.isRegistered(throwable.getClass(), output.getTransportVersion())) {
                ex = ee;
            } else lbl-1000:
            // 2 sources

            {
                ex = new NotSerializableExceptionWrapper(throwable);
            }
            output.writeVInt(0);
            output.writeVInt(ElasticsearchException.getId(ex.getClass()));
            ex.writeTo(output, ElasticsearchException.createNestingFunction(nestedLevel, nestedExceptionLimitCallback));
            return;
        }
        if (writeMessage) {
            output.writeOptionalString(throwable.getMessage());
        }
        if (writeCause) {
            ElasticsearchException.writeException(throwable.getCause(), output, nestedLevel + 1, nestedExceptionLimitCallback);
        }
        ElasticsearchException.writeStackTraces(throwable, output, (Writeable.Writer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Lorg/elasticsearch/common/io/stream/StreamOutput;Ljava/lang/Object;)V, lambda$writeException$7(int java.lang.Runnable org.elasticsearch.common.io.stream.StreamOutput java.lang.Throwable ), (Lorg/elasticsearch/common/io/stream/StreamOutput;Ljava/lang/Throwable;)V)((int)nestedLevel, (Runnable)nestedExceptionLimitCallback));
    }

    @Nullable
    public static <T extends Throwable> T readException(StreamInput input) throws IOException {
        if (input.readBoolean()) {
            int key = input.readVInt();
            switch (key) {
                case 0: {
                    int ord = input.readVInt();
                    return (T)ElasticsearchException.readException(input, ord);
                }
                case 1: {
                    String msg1 = input.readOptionalString();
                    String resource1 = input.readOptionalString();
                    return (T)((Object)ElasticsearchException.readStackTrace(new CorruptIndexException(msg1, resource1, ElasticsearchException.readException(input)), input));
                }
                case 2: {
                    String resource2 = input.readOptionalString();
                    int version2 = input.readInt();
                    int minVersion2 = input.readInt();
                    int maxVersion2 = input.readInt();
                    return (T)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooNewException(resource2, version2, minVersion2, maxVersion2), input));
                }
                case 3: {
                    String resource3 = input.readOptionalString();
                    if (input.readBoolean()) {
                        int version3 = input.readInt();
                        int minVersion3 = input.readInt();
                        int maxVersion3 = input.readInt();
                        return (T)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3, minVersion3, maxVersion3), input));
                    }
                    String version3 = input.readOptionalString();
                    return (T)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3), input));
                }
                case 4: {
                    return (T)ElasticsearchException.readStackTrace(new NullPointerException(input.readOptionalString()), input);
                }
                case 5: {
                    return (T)ElasticsearchException.readStackTrace(new NumberFormatException(input.readOptionalString()), input);
                }
                case 6: {
                    return (T)ElasticsearchException.readStackTrace(new IllegalArgumentException(input.readOptionalString(), (Throwable)ElasticsearchException.readException(input)), input);
                }
                case 7: {
                    return (T)ElasticsearchException.readStackTrace(new AlreadyClosedException(input.readOptionalString(), ElasticsearchException.readException(input)), input);
                }
                case 8: {
                    return (T)ElasticsearchException.readStackTrace(new EOFException(input.readOptionalString()), input);
                }
                case 9: {
                    return (T)ElasticsearchException.readStackTrace(new SecurityException(input.readOptionalString(), (Throwable)ElasticsearchException.readException(input)), input);
                }
                case 10: {
                    return (T)ElasticsearchException.readStackTrace(new StringIndexOutOfBoundsException(input.readOptionalString()), input);
                }
                case 11: {
                    return (T)ElasticsearchException.readStackTrace(new ArrayIndexOutOfBoundsException(input.readOptionalString()), input);
                }
                case 12: {
                    return (T)ElasticsearchException.readStackTrace(new FileNotFoundException(input.readOptionalString()), input);
                }
                case 13: {
                    int subclass = input.readVInt();
                    String file = input.readOptionalString();
                    String other = input.readOptionalString();
                    String reason = input.readOptionalString();
                    input.readOptionalString();
                    FileSystemException exception = switch (subclass) {
                        case 0 -> new NoSuchFileException(file, other, reason);
                        case 1 -> new NotDirectoryException(file);
                        case 2 -> new DirectoryNotEmptyException(file);
                        case 3 -> new AtomicMoveNotSupportedException(file, other, reason);
                        case 4 -> new FileAlreadyExistsException(file, other, reason);
                        case 5 -> new AccessDeniedException(file, other, reason);
                        case 6 -> new FileSystemLoopException(file);
                        case 7 -> new FileSystemException(file, other, reason);
                        default -> throw new IllegalStateException("unknown FileSystemException with index " + subclass);
                    };
                    return (T)ElasticsearchException.readStackTrace(exception, input);
                }
                case 14: {
                    return (T)ElasticsearchException.readStackTrace(new IllegalStateException(input.readOptionalString(), (Throwable)ElasticsearchException.readException(input)), input);
                }
                case 15: {
                    return (T)((Object)ElasticsearchException.readStackTrace(new LockObtainFailedException(input.readOptionalString(), ElasticsearchException.readException(input)), input));
                }
                case 16: {
                    return (T)ElasticsearchException.readStackTrace(new InterruptedException(input.readOptionalString()), input);
                }
                case 17: {
                    return (T)ElasticsearchException.readStackTrace(new IOException(input.readOptionalString(), (Throwable)ElasticsearchException.readException(input)), input);
                }
                case 18: {
                    boolean isExecutorShutdown = input.readBoolean();
                    return (T)ElasticsearchException.readStackTrace(new EsRejectedExecutionException(input.readOptionalString(), isExecutorShutdown), input);
                }
            }
            throw new IOException("no such exception for id: " + key);
        }
        return null;
    }

    static int[] ids() {
        return Arrays.stream(ElasticsearchExceptionHandle.values()).mapToInt(h -> h.id).toArray();
    }

    static Tuple<Integer, Class<? extends ElasticsearchException>>[] classes() {
        Tuple[] ts = (Tuple[])Arrays.stream(ElasticsearchExceptionHandle.values()).map(h -> Tuple.tuple((Object)h.id, h.exceptionClass)).toArray(Tuple[]::new);
        return ts;
    }

    public Index getIndex() {
        List<String> index = this.getMetadata(INDEX_METADATA_KEY);
        if (index != null && !index.isEmpty()) {
            List<String> index_uuid = this.getMetadata(INDEX_METADATA_KEY_UUID);
            return new Index(index.get(0), index_uuid.get(0));
        }
        return null;
    }

    public ShardId getShardId() {
        List<String> shard = this.getMetadata(SHARD_METADATA_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addMetadata(INDEX_METADATA_KEY, index.getName());
            this.addMetadata(INDEX_METADATA_KEY_UUID, index.getUUID());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(new Index(index, "_na_"));
        }
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.setIndex(shardId.getIndex());
            this.addMetadata(SHARD_METADATA_KEY, Integer.toString(shardId.id()));
        }
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addMetadata(RESOURCE_METADATA_ID_KEY, id);
        this.addMetadata(RESOURCE_METADATA_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getMetadata(RESOURCE_METADATA_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getMetadata(RESOURCE_METADATA_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    private static String toUnderscoreCase(String value) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!changed) {
                    for (int j = 0; j < i; ++j) {
                        sb.append(value.charAt(j));
                    }
                    changed = true;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(c));
                        continue;
                    }
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!changed) continue;
            sb.append(c);
        }
        if (!changed) {
            return value;
        }
        return sb.toString();
    }

    private static /* synthetic */ void lambda$writeException$7(int nestedLevel, Runnable nestedExceptionLimitCallback, StreamOutput o, Throwable t) throws IOException {
        ElasticsearchException.writeException(t, o, nestedLevel + 1, nestedExceptionLimitCallback);
    }

    private static enum ElasticsearchExceptionHandle {
        INDEX_SHARD_SNAPSHOT_FAILED_EXCEPTION(IndexShardSnapshotFailedException.class, IndexShardSnapshotFailedException::new, 0, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        DFS_PHASE_EXECUTION_EXCEPTION(DfsPhaseExecutionException.class, DfsPhaseExecutionException::new, 1, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        EXECUTION_CANCELLED_EXCEPTION(CancellableThreads.ExecutionCancelledException.class, CancellableThreads.ExecutionCancelledException::new, 2, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        MASTER_NOT_DISCOVERED_EXCEPTION(MasterNotDiscoveredException.class, MasterNotDiscoveredException::new, 3, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ELASTICSEARCH_SECURITY_EXCEPTION(ElasticsearchSecurityException.class, ElasticsearchSecurityException::new, 4, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_RESTORE_EXCEPTION(IndexShardRestoreException.class, IndexShardRestoreException::new, 5, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_CLOSED_EXCEPTION(IndexClosedException.class, IndexClosedException::new, 6, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        BIND_HTTP_EXCEPTION(BindHttpException.class, BindHttpException::new, 7, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        REDUCE_SEARCH_PHASE_EXCEPTION(ReduceSearchPhaseException.class, ReduceSearchPhaseException::new, 8, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NODE_CLOSED_EXCEPTION(NodeClosedException.class, NodeClosedException::new, 9, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SHARD_NOT_FOUND_EXCEPTION(ShardNotFoundException.class, ShardNotFoundException::new, 11, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        CONNECT_TRANSPORT_EXCEPTION(ConnectTransportException.class, ConnectTransportException::new, 12, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NOT_SERIALIZABLE_TRANSPORT_EXCEPTION(NotSerializableTransportException.class, NotSerializableTransportException::new, 13, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RESPONSE_HANDLER_FAILURE_TRANSPORT_EXCEPTION(ResponseHandlerFailureTransportException.class, ResponseHandlerFailureTransportException::new, 14, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_CREATION_EXCEPTION(IndexCreationException.class, IndexCreationException::new, 15, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_NOT_FOUND_EXCEPTION(IndexNotFoundException.class, IndexNotFoundException::new, 16, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ILLEGAL_SHARD_ROUTING_STATE_EXCEPTION(IllegalShardRoutingStateException.class, IllegalShardRoutingStateException::new, 17, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        BROADCAST_SHARD_OPERATION_FAILED_EXCEPTION(BroadcastShardOperationFailedException.class, BroadcastShardOperationFailedException::new, 18, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RESOURCE_NOT_FOUND_EXCEPTION(ResourceNotFoundException.class, ResourceNotFoundException::new, 19, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ACTION_TRANSPORT_EXCEPTION(ActionTransportException.class, ActionTransportException::new, 20, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ELASTICSEARCH_GENERATION_EXCEPTION(ElasticsearchGenerationException.class, ElasticsearchGenerationException::new, 21, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_STARTED_EXCEPTION(IndexShardStartedException.class, IndexShardStartedException::new, 23, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SEARCH_CONTEXT_MISSING_EXCEPTION(SearchContextMissingException.class, SearchContextMissingException::new, 24, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        GENERAL_SCRIPT_EXCEPTION(GeneralScriptException.class, GeneralScriptException::new, 25, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        DOCUMENT_MISSING_EXCEPTION(DocumentMissingException.class, DocumentMissingException::new, 29, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SNAPSHOT_EXCEPTION(SnapshotException.class, SnapshotException::new, 30, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INVALID_ALIAS_NAME_EXCEPTION(InvalidAliasNameException.class, InvalidAliasNameException::new, 31, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INVALID_INDEX_NAME_EXCEPTION(InvalidIndexNameException.class, InvalidIndexNameException::new, 32, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_PRIMARY_SHARD_NOT_ALLOCATED_EXCEPTION(IndexPrimaryShardNotAllocatedException.class, IndexPrimaryShardNotAllocatedException::new, 33, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TRANSPORT_EXCEPTION(TransportException.class, TransportException::new, 34, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ELASTICSEARCH_PARSE_EXCEPTION(ElasticsearchParseException.class, ElasticsearchParseException::new, 35, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SEARCH_EXCEPTION(SearchException.class, SearchException::new, 36, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        MAPPER_EXCEPTION(MapperException.class, MapperException::new, 37, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INVALID_TYPE_NAME_EXCEPTION(InvalidTypeNameException.class, InvalidTypeNameException::new, 38, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SNAPSHOT_RESTORE_EXCEPTION(SnapshotRestoreException.class, SnapshotRestoreException::new, 39, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        PARSING_EXCEPTION(ParsingException.class, ParsingException::new, 40, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_CLOSED_EXCEPTION(IndexShardClosedException.class, IndexShardClosedException::new, 41, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RECOVER_FILES_RECOVERY_EXCEPTION(RecoverFilesRecoveryException.class, RecoverFilesRecoveryException::new, 42, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TRUNCATED_TRANSLOG_EXCEPTION(TruncatedTranslogException.class, TruncatedTranslogException::new, 43, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RECOVERY_FAILED_EXCEPTION(RecoveryFailedException.class, RecoveryFailedException::new, 44, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_RELOCATED_EXCEPTION(IndexShardRelocatedException.class, IndexShardRelocatedException::new, 45, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TRANSLOG_CORRUPTED_EXCEPTION(TranslogCorruptedException.class, TranslogCorruptedException::new, 48, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        CLUSTER_BLOCK_EXCEPTION(ClusterBlockException.class, ClusterBlockException::new, 49, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        FETCH_PHASE_EXECUTION_EXCEPTION(FetchPhaseExecutionException.class, FetchPhaseExecutionException::new, 50, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        VERSION_CONFLICT_ENGINE_EXCEPTION(VersionConflictEngineException.class, VersionConflictEngineException::new, 52, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ENGINE_EXCEPTION(EngineException.class, EngineException::new, 53, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NO_SUCH_NODE_EXCEPTION(NoSuchNodeException.class, NoSuchNodeException::new, 55, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SETTINGS_EXCEPTION(SettingsException.class, SettingsException::new, 56, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_TEMPLATE_MISSING_EXCEPTION(IndexTemplateMissingException.class, IndexTemplateMissingException::new, 57, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SEND_REQUEST_TRANSPORT_EXCEPTION(SendRequestTransportException.class, SendRequestTransportException::new, 58, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NOT_SERIALIZABLE_EXCEPTION_WRAPPER(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ALIAS_FILTER_PARSING_EXCEPTION(AliasFilterParsingException.class, AliasFilterParsingException::new, 63, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_NOT_RECOVERING_EXCEPTION(IndexShardNotRecoveringException.class, IndexShardNotRecoveringException::new, 66, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        HTTP_EXCEPTION(HttpException.class, HttpException::new, 67, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ELASTICSEARCH_EXCEPTION(ElasticsearchException.class, ElasticsearchException::new, 68, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SNAPSHOT_MISSING_EXCEPTION(SnapshotMissingException.class, SnapshotMissingException::new, 69, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        PRIMARY_MISSING_ACTION_EXCEPTION(PrimaryMissingActionException.class, PrimaryMissingActionException::new, 70, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        FAILED_NODE_EXCEPTION(FailedNodeException.class, FailedNodeException::new, 71, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        CONCURRENT_SNAPSHOT_EXECUTION_EXCEPTION(ConcurrentSnapshotExecutionException.class, ConcurrentSnapshotExecutionException::new, 73, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        BLOB_STORE_EXCEPTION(BlobStoreException.class, BlobStoreException::new, 74, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INCOMPATIBLE_CLUSTER_STATE_VERSION_EXCEPTION(IncompatibleClusterStateVersionException.class, IncompatibleClusterStateVersionException::new, 75, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RECOVERY_ENGINE_EXCEPTION(RecoveryEngineException.class, RecoveryEngineException::new, 76, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        UNCATEGORIZED_EXECUTION_EXCEPTION(UncategorizedExecutionException.class, UncategorizedExecutionException::new, 77, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TIMESTAMP_PARSING_EXCEPTION(TimestampParsingException.class, TimestampParsingException::new, 78, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ROUTING_MISSING_EXCEPTION(RoutingMissingException.class, RoutingMissingException::new, 79, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_RESTORE_FAILED_EXCEPTION(IndexShardRestoreFailedException.class, IndexShardRestoreFailedException::new, 81, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        REPOSITORY_EXCEPTION(RepositoryException.class, RepositoryException::new, 82, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RECEIVE_TIMEOUT_TRANSPORT_EXCEPTION(ReceiveTimeoutTransportException.class, ReceiveTimeoutTransportException::new, 83, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NODE_DISCONNECTED_EXCEPTION(NodeDisconnectedException.class, NodeDisconnectedException::new, 84, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        AGGREGATION_EXECUTION_EXCEPTION(AggregationExecutionException.class, AggregationExecutionException::new, 86, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INVALID_INDEX_TEMPLATE_EXCEPTION(InvalidIndexTemplateException.class, InvalidIndexTemplateException::new, 88, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        REFRESH_FAILED_ENGINE_EXCEPTION(RefreshFailedEngineException.class, RefreshFailedEngineException::new, 90, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        AGGREGATION_INITIALIZATION_EXCEPTION(AggregationInitializationException.class, AggregationInitializationException::new, 91, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        DELAY_RECOVERY_EXCEPTION(DelayRecoveryException.class, DelayRecoveryException::new, 92, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NO_NODE_AVAILABLE_EXCEPTION(NoNodeAvailableException.class, NoNodeAvailableException::new, 94, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INVALID_SNAPSHOT_NAME_EXCEPTION(InvalidSnapshotNameException.class, InvalidSnapshotNameException::new, 96, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ILLEGAL_INDEX_SHARD_STATE_EXCEPTION(IllegalIndexShardStateException.class, IllegalIndexShardStateException::new, 97, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_SNAPSHOT_EXCEPTION(IndexShardSnapshotException.class, IndexShardSnapshotException::new, 98, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_NOT_STARTED_EXCEPTION(IndexShardNotStartedException.class, IndexShardNotStartedException::new, 99, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SEARCH_PHASE_EXECUTION_EXCEPTION(SearchPhaseExecutionException.class, SearchPhaseExecutionException::new, 100, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ACTION_NOT_FOUND_TRANSPORT_EXCEPTION(ActionNotFoundTransportException.class, ActionNotFoundTransportException::new, 101, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TRANSPORT_SERIALIZATION_EXCEPTION(TransportSerializationException.class, TransportSerializationException::new, 102, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        REMOTE_TRANSPORT_EXCEPTION(RemoteTransportException.class, RemoteTransportException::new, 103, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ENGINE_CREATION_FAILURE_EXCEPTION(EngineCreationFailureException.class, EngineCreationFailureException::new, 104, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ROUTING_EXCEPTION(RoutingException.class, RoutingException::new, 105, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_RECOVERY_EXCEPTION(IndexShardRecoveryException.class, IndexShardRecoveryException::new, 106, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        REPOSITORY_MISSING_EXCEPTION(RepositoryMissingException.class, RepositoryMissingException::new, 107, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        DOCUMENT_SOURCE_MISSING_EXCEPTION(DocumentSourceMissingException.class, DocumentSourceMissingException::new, 109, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NO_CLASS_SETTINGS_EXCEPTION(NoClassSettingsException.class, NoClassSettingsException::new, 111, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        BIND_TRANSPORT_EXCEPTION(BindTransportException.class, BindTransportException::new, 112, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ALIASES_NOT_FOUND_EXCEPTION(AliasesNotFoundException.class, AliasesNotFoundException::new, 113, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INDEX_SHARD_RECOVERING_EXCEPTION(IndexShardRecoveringException.class, IndexShardRecoveringException::new, 114, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TRANSLOG_EXCEPTION(TranslogException.class, TranslogException::new, 115, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        PROCESS_CLUSTER_EVENT_TIMEOUT_EXCEPTION(ProcessClusterEventTimeoutException.class, ProcessClusterEventTimeoutException::new, 116, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RETRY_ON_PRIMARY_EXCEPTION(ReplicationOperation.RetryOnPrimaryException.class, ReplicationOperation.RetryOnPrimaryException::new, 117, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        ELASTICSEARCH_TIMEOUT_EXCEPTION(ElasticsearchTimeoutException.class, ElasticsearchTimeoutException::new, 118, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        QUERY_PHASE_EXECUTION_EXCEPTION(QueryPhaseExecutionException.class, QueryPhaseExecutionException::new, 119, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        REPOSITORY_VERIFICATION_EXCEPTION(RepositoryVerificationException.class, RepositoryVerificationException::new, 120, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INVALID_AGGREGATION_PATH_EXCEPTION(InvalidAggregationPathException.class, InvalidAggregationPathException::new, 121, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RESOURCE_ALREADY_EXISTS_EXCEPTION(ResourceAlreadyExistsException.class, ResourceAlreadyExistsException::new, 123, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        HTTP_REQUEST_ON_TRANSPORT_EXCEPTION(TcpTransport.HttpRequestOnTransportException.class, TcpTransport.HttpRequestOnTransportException::new, 125, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        MAPPER_PARSING_EXCEPTION(MapperParsingException.class, MapperParsingException::new, 126, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NO_SHARD_AVAILABLE_ACTION_EXCEPTION(NoShardAvailableActionException.class, NoShardAvailableActionException::new, 130, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        UNAVAILABLE_SHARDS_EXCEPTION(UnavailableShardsException.class, UnavailableShardsException::new, 131, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        FLUSH_FAILED_ENGINE_EXCEPTION(FlushFailedEngineException.class, FlushFailedEngineException::new, 132, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        CIRCUIT_BREAKING_EXCEPTION(CircuitBreakingException.class, CircuitBreakingException::new, 133, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NODE_NOT_CONNECTED_EXCEPTION(NodeNotConnectedException.class, NodeNotConnectedException::new, 134, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        STRICT_DYNAMIC_MAPPING_EXCEPTION(StrictDynamicMappingException.class, StrictDynamicMappingException::new, 135, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RETRY_ON_REPLICA_EXCEPTION(TransportReplicationAction.RetryOnReplicaException.class, TransportReplicationAction.RetryOnReplicaException::new, 136, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TYPE_MISSING_EXCEPTION(TypeMissingException.class, TypeMissingException::new, 137, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        FAILED_TO_COMMIT_CLUSTER_STATE_EXCEPTION(FailedToCommitClusterStateException.class, FailedToCommitClusterStateException::new, 140, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        QUERY_SHARD_EXCEPTION(QueryShardException.class, QueryShardException::new, 141, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NO_LONGER_PRIMARY_SHARD_EXCEPTION(ShardStateAction.NoLongerPrimaryShardException.class, ShardStateAction.NoLongerPrimaryShardException::new, 142, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SCRIPT_EXCEPTION(ScriptException.class, ScriptException::new, 143, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NOT_MASTER_EXCEPTION(NotMasterException.class, NotMasterException::new, 144, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        STATUS_EXCEPTION(ElasticsearchStatusException.class, ElasticsearchStatusException::new, 145, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TASK_CANCELLED_EXCEPTION(TaskCancelledException.class, TaskCancelledException::new, 146, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SHARD_LOCK_OBTAIN_FAILED_EXCEPTION(ShardLockObtainFailedException.class, ShardLockObtainFailedException::new, 147, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        TOO_MANY_BUCKETS_EXCEPTION(MultiBucketConsumerService.TooManyBucketsException.class, MultiBucketConsumerService.TooManyBucketsException::new, 149, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        COORDINATION_STATE_REJECTED_EXCEPTION(CoordinationStateRejectedException.class, CoordinationStateRejectedException::new, 150, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SNAPSHOT_IN_PROGRESS_EXCEPTION(SnapshotInProgressException.class, SnapshotInProgressException::new, 151, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NO_SUCH_REMOTE_CLUSTER_EXCEPTION(NoSuchRemoteClusterException.class, NoSuchRemoteClusterException::new, 152, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RETENTION_LEASE_ALREADY_EXISTS_EXCEPTION(RetentionLeaseAlreadyExistsException.class, RetentionLeaseAlreadyExistsException::new, 153, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RETENTION_LEASE_NOT_FOUND_EXCEPTION(RetentionLeaseNotFoundException.class, RetentionLeaseNotFoundException::new, 154, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        SHARD_NOT_IN_PRIMARY_MODE_EXCEPTION(ShardNotInPrimaryModeException.class, ShardNotInPrimaryModeException::new, 155, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        RETENTION_LEASE_INVALID_RETAINING_SEQUENCE_NUMBER_EXCEPTION(RetentionLeaseInvalidRetainingSeqNoException.class, RetentionLeaseInvalidRetainingSeqNoException::new, 156, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        INGEST_PROCESSOR_EXCEPTION(IngestProcessorException.class, IngestProcessorException::new, 157, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        PEER_RECOVERY_NOT_FOUND_EXCEPTION(PeerRecoveryNotFound.class, PeerRecoveryNotFound::new, 158, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        NODE_HEALTH_CHECK_FAILURE_EXCEPTION(NodeHealthCheckFailureException.class, NodeHealthCheckFailureException::new, 159, TransportVersions.V_8_0_0, new TransportVersion[0]),
        NO_SEED_NODE_LEFT_EXCEPTION(NoSeedNodeLeftException.class, NoSeedNodeLeftException::new, 160, UNKNOWN_VERSION_ADDED, new TransportVersion[0]),
        AUTHENTICATION_PROCESSING_ERROR(ElasticsearchAuthenticationProcessingError.class, ElasticsearchAuthenticationProcessingError::new, 162, TransportVersions.V_7_16_0, new TransportVersion[0]),
        REPOSITORY_CONFLICT_EXCEPTION(RepositoryConflictException.class, RepositoryConflictException::new, 163, TransportVersions.V_8_0_0, new TransportVersion[0]),
        DESIRED_NODES_VERSION_CONFLICT_EXCEPTION(VersionConflictException.class, VersionConflictException::new, 164, TransportVersions.V_8_1_0, new TransportVersion[0]),
        SNAPSHOT_NAME_ALREADY_IN_USE_EXCEPTION(SnapshotNameAlreadyInUseException.class, SnapshotNameAlreadyInUseException::new, 165, TransportVersions.V_8_2_0, new TransportVersion[0]),
        HEALTH_NODE_NOT_DISCOVERED_EXCEPTION(HealthNodeNotDiscoveredException.class, HealthNodeNotDiscoveredException::new, 166, TransportVersions.V_8_5_0, new TransportVersion[0]),
        UNSUPPORTED_AGGREGATION_ON_DOWNSAMPLED_INDEX_EXCEPTION(UnsupportedAggregationOnDownsampledIndex.class, UnsupportedAggregationOnDownsampledIndex::new, 167, TransportVersions.V_8_5_0, new TransportVersion[0]),
        DOCUMENT_PARSING_EXCEPTION(DocumentParsingException.class, DocumentParsingException::new, 168, TransportVersions.V_8_8_0, new TransportVersion[0]),
        HTTP_HEADERS_VALIDATION_EXCEPTION(HttpHeadersValidationException.class, HttpHeadersValidationException::new, 169, TransportVersions.V_8_9_X, new TransportVersion[0]),
        ROLE_RESTRICTION_EXCEPTION(ElasticsearchRoleRestrictionException.class, ElasticsearchRoleRestrictionException::new, 170, TransportVersions.V_8_9_X, new TransportVersion[0]),
        API_NOT_AVAILABLE_EXCEPTION(ApiNotAvailableException.class, ApiNotAvailableException::new, 171, TransportVersions.V_8_11_X, new TransportVersion[0]),
        RECOVERY_COMMIT_TOO_NEW_EXCEPTION(RecoveryCommitTooNewException.class, RecoveryCommitTooNewException::new, 172, TransportVersions.V_8_11_X, new TransportVersion[0]),
        TOO_MANY_SCROLL_CONTEXTS_NEW_EXCEPTION(TooManyScrollContextsException.class, TooManyScrollContextsException::new, 173, TransportVersions.V_8_12_0, new TransportVersion[0]),
        INVALID_BUCKET_PATH_EXCEPTION(AggregationExecutionException.InvalidPath.class, AggregationExecutionException.InvalidPath::new, 174, TransportVersions.V_8_12_0, new TransportVersion[0]),
        MISSED_INDICES_UPDATE_EXCEPTION(AutoscalingMissedIndicesUpdateException.class, AutoscalingMissedIndicesUpdateException::new, 175, TransportVersions.V_8_12_0, new TransportVersion[0]),
        SEARCH_TIMEOUT_EXCEPTION(SearchTimeoutException.class, SearchTimeoutException::new, 176, TransportVersions.V_8_13_0, new TransportVersion[0]),
        INGEST_GRAPH_STRUCTURE_EXCEPTION(GraphStructureException.class, GraphStructureException::new, 177, TransportVersions.V_8_13_0, new TransportVersion[0]),
        FAILURE_INDEX_NOT_SUPPORTED_EXCEPTION(FailureIndexNotSupportedException.class, FailureIndexNotSupportedException::new, 178, TransportVersions.V_8_14_0, new TransportVersion[0]),
        NOT_PERSISTENT_TASK_NODE_EXCEPTION(NotPersistentTaskNodeException.class, NotPersistentTaskNodeException::new, 179, TransportVersions.V_8_14_0, new TransportVersion[0]),
        PERSISTENT_TASK_NODE_NOT_ASSIGNED_EXCEPTION(PersistentTaskNodeNotAssignedException.class, PersistentTaskNodeNotAssignedException::new, 180, TransportVersions.V_8_14_0, new TransportVersion[0]),
        RESOURCE_ALREADY_UPLOADED_EXCEPTION(ResourceAlreadyUploadedException.class, ResourceAlreadyUploadedException::new, 181, TransportVersions.V_8_15_0, new TransportVersion[0]),
        INGEST_PIPELINE_EXCEPTION(IngestPipelineException.class, IngestPipelineException::new, 182, TransportVersions.V_8_16_0, new TransportVersion[0]),
        INDEX_RESPONSE_WRAPPER_EXCEPTION(IndexDocFailureStoreStatus.ExceptionWithFailureStoreStatus.class, IndexDocFailureStoreStatus.ExceptionWithFailureStoreStatus::new, 183, TransportVersions.V_8_16_0, new TransportVersion[0]);

        final Class<? extends ElasticsearchException> exceptionClass;
        final CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException> constructor;
        final int id;
        private final TransportVersion versionAdded;
        private final TransportVersion[] patchVersions;

        private <E extends ElasticsearchException> ElasticsearchExceptionHandle(Class<E> exceptionClass, CheckedFunction<StreamInput, E, IOException> constructor, int id, TransportVersion versionAdded, TransportVersion ... patchVersions) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.id = id;
            this.versionAdded = versionAdded;
            this.patchVersions = patchVersions;
        }
    }
}

