/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;

public final class MvMedianLongEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMedianLongEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMedian";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            MvMedian.Longs work = new MvMedian.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    long value = v.getLong(i);
                    MvMedian.process(work, value);
                }
                long result = MvMedian.finish(work);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            MvMedian.Longs work = new MvMedian.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    long value = v.getLong(i);
                    MvMedian.process(work, value);
                }
                long result = MvMedian.finish(work);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            MvMedian.Longs work = new MvMedian.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                long result = MvMedian.ascending(v, first, valueCount);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            MvMedian.Longs work = new MvMedian.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                long result = MvMedian.ascending(v, first, valueCount);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMedianLongEvaluator get(DriverContext context) {
            return new MvMedianLongEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMedian[field=" + String.valueOf(this.field) + "]";
        }
    }
}

