/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10;

public final class Log10IntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final DriverContext driverContext;
    private Warnings warnings;

    public Log10IntEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock valBlock = (IntBlock)this.val.eval(page);){
            IntVector valVector = valBlock.asVector();
            if (valVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valVector);
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, IntBlock valBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(Log10.process(valBlock.getInt(valBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, IntVector valVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(Log10.process(valVector.getInt(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "Log10IntEvaluator[val=" + String.valueOf(this.val) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val) {
            this.source = source;
            this.val = val;
        }

        public Log10IntEvaluator get(DriverContext context) {
            return new Log10IntEvaluator(this.source, this.val.get(context), context);
        }

        public String toString() {
            return "Log10IntEvaluator[val=" + String.valueOf(this.val) + "]";
        }
    }
}

