/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Hypot;

public final class HypotEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator n1;
    private final EvalOperator.ExpressionEvaluator n2;
    private final DriverContext driverContext;
    private Warnings warnings;

    public HypotEvaluator(Source source, EvalOperator.ExpressionEvaluator n1, EvalOperator.ExpressionEvaluator n2, DriverContext driverContext) {
        this.source = source;
        this.n1 = n1;
        this.n2 = n2;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock n1Block = (DoubleBlock)this.n1.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                DoubleVector n2Vector;
                DoubleVector n1Vector;
                DoubleBlock n2Block;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                n2Block = (DoubleBlock)this.n2.eval(page);
                                try {
                                    n1Vector = n1Block.asVector();
                                    if (n1Vector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), n1Block, n2Block);
                                    if (n2Block == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (n2Block != null) {
                                        try {
                                            n2Block.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                n2Block.close();
                            }
                            return doubleBlock3;
                        }
                        n2Vector = n2Block.asVector();
                        if (n2Vector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), n1Block, n2Block);
                        if (n2Block == null) break block19;
                        n2Block.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), n1Vector, n2Vector).asBlock();
                if (n2Block == null) break block20;
                n2Block.close();
            }
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock n1Block, DoubleBlock n2Block) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (n1Block.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (n1Block.getValueCount(p) != 1) {
                    if (n1Block.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (n2Block.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (n2Block.getValueCount(p) != 1) {
                    if (n2Block.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Hypot.process(n1Block.getDouble(n1Block.getFirstValueIndex(p)), n2Block.getDouble(n2Block.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector n1Vector, DoubleVector n2Vector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(p, Hypot.process(n1Vector.getDouble(p), n2Vector.getDouble(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "HypotEvaluator[n1=" + String.valueOf(this.n1) + ", n2=" + String.valueOf(this.n2) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.n1, this.n2});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory n1;
        private final EvalOperator.ExpressionEvaluator.Factory n2;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory n1, EvalOperator.ExpressionEvaluator.Factory n2) {
            this.source = source;
            this.n1 = n1;
            this.n2 = n2;
        }

        public HypotEvaluator get(DriverContext context) {
            return new HypotEvaluator(this.source, this.n1.get(context), this.n2.get(context), context);
        }

        public String toString() {
            return "HypotEvaluator[n1=" + String.valueOf(this.n1) + ", n2=" + String.valueOf(this.n2) + "]";
        }
    }
}

