/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;

public final class ShardGenerations {
    private static final Logger logger = LogManager.getLogger(ShardGenerations.class);
    public static final ShardGenerations EMPTY = new ShardGenerations(Collections.emptyMap());
    public static final ShardGeneration NEW_SHARD_GEN = new ShardGeneration("_new");
    public static final ShardGeneration DELETED_SHARD_GEN = new ShardGeneration("_deleted");
    private final Map<IndexId, List<ShardGeneration>> shardGenerations;
    private static final Pattern IS_NUMBER = Pattern.compile("^\\d+$");

    private ShardGenerations(Map<IndexId, List<ShardGeneration>> shardGenerations) {
        this.shardGenerations = Map.copyOf(shardGenerations);
    }

    @Nullable
    public static ShardGeneration fixShardGeneration(@Nullable ShardGeneration shardGeneration) {
        if (shardGeneration == null) {
            return null;
        }
        return IS_NUMBER.matcher(shardGeneration.toString()).matches() ? null : shardGeneration;
    }

    public int totalShards() {
        return this.shardGenerations.values().stream().mapToInt(List::size).sum();
    }

    public Collection<IndexId> indices() {
        return this.shardGenerations.keySet();
    }

    public Map<IndexId, Map<Integer, ShardGeneration>> obsoleteShardGenerations(ShardGenerations previous) {
        HashMap result = new HashMap();
        previous.shardGenerations.forEach((indexId, oldGens) -> {
            List<ShardGeneration> updatedGenerations = this.shardGenerations.get(indexId);
            HashMap<Integer, ShardGeneration> obsoleteShardIndices = new HashMap<Integer, ShardGeneration>();
            assert (updatedGenerations != null) : "Index [" + String.valueOf(indexId) + "] present in previous shard generations, but missing from updated generations";
            for (int i = 0; i < Math.min(oldGens.size(), updatedGenerations.size()); ++i) {
                ShardGeneration oldGeneration = (ShardGeneration)oldGens.get(i);
                ShardGeneration updatedGeneration = updatedGenerations.get(i);
                if (updatedGeneration == null || oldGeneration == null || oldGeneration.equals(updatedGeneration)) continue;
                obsoleteShardIndices.put(i, oldGeneration);
                logger.debug("Marking snapshot generation [{}] for cleanup. The new generation is [{}]. Index [{}], shard ID [{}]", (Object)oldGeneration, (Object)updatedGeneration, indexId, (Object)i);
            }
            result.put(indexId, Collections.unmodifiableMap(obsoleteShardIndices));
        });
        return Collections.unmodifiableMap(result);
    }

    @Nullable
    public ShardGeneration getShardGen(IndexId indexId, int shardId) {
        List<ShardGeneration> generations = this.shardGenerations.get(indexId);
        if (generations == null || generations.size() < shardId + 1) {
            return null;
        }
        return generations.get(shardId);
    }

    public boolean hasShardGen(RepositoryShardId repositoryShardId) {
        List<ShardGeneration> indexShardGens = this.getGens(repositoryShardId.index());
        return repositoryShardId.shardId() < indexShardGens.size() && indexShardGens.get(repositoryShardId.shardId()) != null;
    }

    public List<ShardGeneration> getGens(IndexId indexId) {
        return this.shardGenerations.getOrDefault(indexId, Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardGenerations that = (ShardGenerations)o;
        return this.shardGenerations.equals(that.shardGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.shardGenerations);
    }

    public String toString() {
        return "ShardGenerations{generations:" + String.valueOf(this.shardGenerations) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<IndexId, Map<Integer, ShardGeneration>> generations = new HashMap<IndexId, Map<Integer, ShardGeneration>>();

        public Builder retainIndicesAndPruneDeletes(Set<IndexId> indices) {
            this.generations.keySet().retainAll(indices);
            for (IndexId index : indices) {
                Map shards = this.generations.getOrDefault(index, Collections.emptyMap());
                Iterator iterator = shards.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ShardGeneration generation = (ShardGeneration)entry.getValue();
                    if (!generation.equals(DELETED_SHARD_GEN)) continue;
                    iterator.remove();
                }
                if (!shards.isEmpty()) continue;
                this.generations.remove(index);
            }
            return this;
        }

        public Builder putAll(ShardGenerations shardGenerations) {
            shardGenerations.shardGenerations.forEach((indexId, gens) -> {
                for (int i = 0; i < gens.size(); ++i) {
                    ShardGeneration gen = (ShardGeneration)gens.get(i);
                    if (gen == null) continue;
                    this.put((IndexId)indexId, i, gen);
                }
            });
            return this;
        }

        public Builder update(FinalizeSnapshotContext.UpdatedShardGenerations updatedShardGenerations) {
            this.putAll(updatedShardGenerations.liveIndices());
            this.updateIfPresent(updatedShardGenerations.deletedIndices());
            return this;
        }

        public Builder put(IndexId indexId, int shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            return this.put(indexId, shardId, status.state().failed() ? null : status.generation());
        }

        public Builder put(IndexId indexId, int shardId, ShardGeneration generation) {
            assert (this.noDuplicateIndicesWithSameName(indexId));
            ShardGeneration existingGeneration = this.generations.computeIfAbsent(indexId, i -> new HashMap()).put(shardId, generation);
            assert (generation != null || existingGeneration == null) : "must not overwrite existing generation with null generation [" + String.valueOf(existingGeneration) + "]";
            return this;
        }

        private void updateIfPresent(ShardGenerations shardGenerations) {
            shardGenerations.shardGenerations.forEach((indexId, gens) -> {
                Map<Integer, ShardGeneration> existingShardGens = this.generations.get(indexId);
                if (existingShardGens != null) {
                    for (int i = 0; i < gens.size(); ++i) {
                        ShardGeneration gen = (ShardGeneration)gens.get(i);
                        if (gen == null) continue;
                        existingShardGens.put(i, gen);
                    }
                }
            });
        }

        private boolean noDuplicateIndicesWithSameName(IndexId newId) {
            for (IndexId id : this.generations.keySet()) {
                if (id.getName().equals(newId.getName()) && !id.equals(newId)) assert (false) : Strings.format("Unable to add: %s. There's another index id with the same name: %s", newId, id);
            }
            return true;
        }

        public ShardGenerations build() {
            if (this.generations.isEmpty()) {
                return EMPTY;
            }
            return new ShardGenerations(this.generations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Set shardIds = ((Map)entry.getValue()).keySet();
                assert (!shardIds.isEmpty());
                int size = shardIds.stream().mapToInt(i -> i).max().getAsInt() + 1;
                ShardGeneration[] gens = new ShardGeneration[size];
                ((Map)entry.getValue()).forEach((shardId, generation) -> {
                    gens[shardId.intValue()] = generation;
                });
                return Collections.unmodifiableList(Arrays.asList(gens));
            })));
        }
    }
}

