/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class NodeAllocationOrdering {
    private final AtomicLong order = new AtomicLong(0L);
    private final Map<String, Long> recentAllocations = new HashMap<String, Long>();
    private final Comparator<String> comparator = Comparator.comparing(nodeId -> this.recentAllocations.getOrDefault(nodeId, 0L));

    public void recordAllocation(String nodeId) {
        this.recentAllocations.put(nodeId, this.order.incrementAndGet());
    }

    public List<String> sort(Collection<String> nodeIds) {
        ArrayList<String> list = new ArrayList<String>(nodeIds);
        list.sort(this.comparator);
        return list;
    }

    public void retainNodes(Set<String> retainedNodeIds) {
        this.recentAllocations.keySet().retainAll(retainedNodeIds);
    }

    public void clear() {
        this.order.set(0L);
        this.recentAllocations.clear();
    }
}

