/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.search.CanMatchPreFilterSearchPhase;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.SearchShardsResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public class TransportSearchShardsAction
extends HandledTransportAction<SearchShardsRequest, SearchShardsResponse> {
    public static final String NAME = "indices:admin/search/search_shards";
    public static final ActionType<SearchShardsResponse> TYPE = new ActionType("indices:admin/search/search_shards");
    public static final RemoteClusterActionType<SearchShardsResponse> REMOTE_TYPE = new RemoteClusterActionType<SearchShardsResponse>("indices:admin/search/search_shards", SearchShardsResponse::new);
    private final TransportService transportService;
    private final TransportSearchAction transportSearchAction;
    private final SearchService searchService;
    private final RemoteClusterService remoteClusterService;
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ThreadPool threadPool;

    @Inject
    public TransportSearchShardsAction(TransportService transportService, SearchService searchService, ActionFilters actionFilters, ClusterService clusterService, TransportSearchAction transportSearchAction, SearchTransportService searchTransportService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), transportService, actionFilters, SearchShardsRequest::new, transportService.getThreadPool().executor("search_coordination"));
        this.transportService = transportService;
        this.transportSearchAction = transportSearchAction;
        this.searchService = searchService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.threadPool = transportService.getThreadPool();
    }

    @Override
    protected void doExecute(Task task, SearchShardsRequest searchShardsRequest, ActionListener<SearchShardsResponse> listener) {
        this.searchShards(task, searchShardsRequest, listener);
    }

    public void searchShards(Task task, SearchShardsRequest searchShardsRequest, ActionListener<SearchShardsResponse> listener) {
        long relativeStartNanos = System.nanoTime();
        SearchRequest original = new SearchRequest(searchShardsRequest.indices()).indicesOptions(searchShardsRequest.indicesOptions()).routing(searchShardsRequest.routing()).preference(searchShardsRequest.preference()).allowPartialSearchResults(searchShardsRequest.allowPartialSearchResults());
        if (searchShardsRequest.query() != null) {
            original.source(new SearchSourceBuilder().query(searchShardsRequest.query()));
        }
        TransportSearchAction.SearchTimeProvider timeProvider = new TransportSearchAction.SearchTimeProvider(original.getOrCreateAbsoluteStartMillis(), relativeStartNanos, System::nanoTime);
        ClusterState clusterState = this.clusterService.state();
        ResolvedIndices resolvedIndices = ResolvedIndices.resolveWithIndicesRequest(searchShardsRequest, clusterState, this.indexNameExpressionResolver, this.remoteClusterService, timeProvider.absoluteStartMillis());
        if (!resolvedIndices.getRemoteClusterIndices().isEmpty()) {
            throw new UnsupportedOperationException("search_shards API doesn't support remote indices " + String.valueOf(searchShardsRequest));
        }
        Rewriteable.rewriteAndFetch(original, this.searchService.getRewriteContext(timeProvider::absoluteStartMillis, resolvedIndices, null), listener.delegateFailureAndWrap((delegate, searchRequest) -> {
            Index[] concreteIndices = resolvedIndices.getConcreteLocalIndices();
            Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(clusterState, searchRequest.indices());
            Map<String, AliasFilter> aliasFilters = this.transportSearchAction.buildIndexAliasFilters(clusterState, indicesAndAliases, concreteIndices);
            String[] concreteIndexNames = (String[])Arrays.stream(concreteIndices).map(Index::getName).toArray(String[]::new);
            GroupShardsIterator<SearchShardIterator> shardIts = GroupShardsIterator.sortAndCreate(this.transportSearchAction.getLocalShardsIterator(clusterState, (SearchRequest)searchRequest, searchShardsRequest.clusterAlias(), indicesAndAliases, concreteIndexNames));
            if (!SearchService.canRewriteToMatchNone(searchRequest.source())) {
                delegate.onResponse(new SearchShardsResponse(TransportSearchShardsAction.toGroups(shardIts), clusterState.nodes().getAllNodes(), aliasFilters));
            } else {
                new CanMatchPreFilterSearchPhase(this.logger, this.searchTransportService, (clusterAlias, node) -> {
                    assert (Objects.equals(clusterAlias, searchShardsRequest.clusterAlias()));
                    return this.transportService.getConnection(clusterState.nodes().get((String)node));
                }, aliasFilters, Map.of(), this.threadPool.executor("search_coordination"), (SearchRequest)searchRequest, shardIts, timeProvider, (SearchTask)task, false, this.searchService.getCoordinatorRewriteContextProvider(timeProvider::absoluteStartMillis), delegate.map(its -> new SearchShardsResponse(TransportSearchShardsAction.toGroups(its), clusterState.nodes().getAllNodes(), aliasFilters))).start();
            }
        }));
    }

    private static List<SearchShardsGroup> toGroups(GroupShardsIterator<SearchShardIterator> shardIts) {
        ArrayList<SearchShardsGroup> groups = new ArrayList<SearchShardsGroup>(shardIts.size());
        for (SearchShardIterator shardIt : shardIts) {
            SearchShardTarget target;
            boolean skip = shardIt.skip();
            shardIt.reset();
            ArrayList<String> targetNodes = new ArrayList<String>();
            while ((target = shardIt.nextOrNull()) != null) {
                targetNodes.add(target.getNodeId());
            }
            ShardId shardId = shardIt.shardId();
            groups.add(new SearchShardsGroup(shardId, targetNodes, skip));
        }
        return groups;
    }
}

