/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesRequestCache;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.ResponseHandler;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class TransportResumeFollowAction
extends AcknowledgedTransportMasterNodeAction<ResumeFollowAction.Request> {
    static final ByteSizeValue DEFAULT_MAX_READ_REQUEST_SIZE = ByteSizeValue.of((long)32L, (ByteSizeUnit)ByteSizeUnit.MB);
    static final ByteSizeValue DEFAULT_MAX_WRITE_REQUEST_SIZE = ByteSizeValue.ofBytes((long)Long.MAX_VALUE);
    private static final TimeValue DEFAULT_MAX_RETRY_DELAY = new TimeValue(500L);
    private static final int DEFAULT_MAX_OUTSTANDING_WRITE_REQUESTS = 9;
    private static final int DEFAULT_MAX_WRITE_BUFFER_COUNT = Integer.MAX_VALUE;
    private static final ByteSizeValue DEFAULT_MAX_WRITE_BUFFER_SIZE = ByteSizeValue.of((long)512L, (ByteSizeUnit)ByteSizeUnit.MB);
    private static final int DEFAULT_MAX_READ_REQUEST_OPERATION_COUNT = 5120;
    private static final int DEFAULT_MAX_WRITE_REQUEST_OPERATION_COUNT = 5120;
    private static final int DEFAULT_MAX_OUTSTANDING_READ_REQUESTS = 12;
    static final TimeValue DEFAULT_READ_POLL_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final Client client;
    private final Executor remoteClientResponseExecutor;
    private final PersistentTasksService persistentTasksService;
    private final IndicesService indicesService;
    private final CcrLicenseChecker ccrLicenseChecker;
    static final Set<Setting<?>> NON_REPLICATED_SETTINGS = Set.of(IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING, IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING, IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING, IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING, IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING, IndexMetadata.INDEX_READ_ONLY_SETTING, IndexMetadata.INDEX_BLOCKS_READ_SETTING, IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, IndexMetadata.INDEX_BLOCKS_METADATA_SETTING, IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, IndexMetadata.INDEX_PRIORITY_SETTING, IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS, IndexMetadata.INDEX_HIDDEN_SETTING, EnableAllocationDecider.INDEX_ROUTING_REBALANCE_ENABLE_SETTING, EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING, ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING, MaxRetryAllocationDecider.SETTING_ALLOCATION_MAX_RETRY, UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING, IndexSettings.MAX_RESULT_WINDOW_SETTING, IndexSettings.INDEX_WARMER_ENABLED_SETTING, IndexSettings.INDEX_REFRESH_INTERVAL_SETTING, IndexSettings.MAX_RESCORE_WINDOW_SETTING, IndexSettings.MAX_INNER_RESULT_WINDOW_SETTING, IndexSettings.DEFAULT_FIELD_SETTING, IndexSettings.QUERY_STRING_LENIENT_SETTING, IndexSettings.QUERY_STRING_ANALYZE_WILDCARD, IndexSettings.QUERY_STRING_ALLOW_LEADING_WILDCARD, IndexSettings.ALLOW_UNMAPPED, IndexSettings.INDEX_SEARCH_IDLE_AFTER, IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING, IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING, IndexSettings.MAX_SCRIPT_FIELDS_SETTING, IndexSettings.MAX_REGEX_LENGTH_SETTING, IndexSettings.MAX_TERMS_COUNT_SETTING, IndexSettings.MAX_ANALYZED_OFFSET_SETTING, IndexSettings.WEIGHT_MATCHES_MODE_ENABLED_SETTING, IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING, IndexSettings.MAX_TOKEN_COUNT_SETTING, IndexSettings.MAX_SLICES_PER_SCROLL, IndexSettings.DEFAULT_PIPELINE, IndexSettings.FINAL_PIPELINE, IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING, IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING, IndexSettings.INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING, IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_AGE_SETTING, IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING, IndexSettings.INDEX_TRANSLOG_SYNC_INTERVAL_SETTING, IndexSettings.INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING, IndexSettings.INDEX_GC_DELETES_SETTING, IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD, IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING, BitsetFilterCache.INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING, SearchSlowLog.INDEX_SEARCH_SLOWLOG_INCLUDE_USER_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING, IndexingSlowLog.INDEX_INDEXING_SLOWLOG_INCLUDE_USER_SETTING, MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_TYPE_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING, MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING, MergeSchedulerConfig.AUTO_THROTTLE_SETTING, MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING, MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, EngineConfig.INDEX_CODEC_SETTING, DataTier.TIER_PREFERENCE_SETTING, IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING, MetadataIndexStateService.VERIFIED_READ_ONLY_SETTING);

    @Inject
    public TransportResumeFollowAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, PersistentTasksService persistentTasksService, IndicesService indicesService, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:admin/xpack/ccr/resume_follow", true, transportService, clusterService, threadPool, actionFilters, ResumeFollowAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.remoteClientResponseExecutor = threadPool.executor("ccr");
        this.persistentTasksService = persistentTasksService;
        this.indicesService = indicesService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    protected ClusterBlockException checkBlock(ResumeFollowAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, ResumeFollowAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        IndexMetadata followerIndexMetadata = state.getMetadata().index(request.getFollowerIndex());
        if (followerIndexMetadata == null) {
            listener.onFailure((Exception)new IndexNotFoundException(request.getFollowerIndex()));
            return;
        }
        Map ccrMetadata = followerIndexMetadata.getCustomData("ccr");
        if (ccrMetadata == null) {
            throw new IllegalArgumentException("follow index [" + request.getFollowerIndex() + "] does not have ccr metadata");
        }
        String leaderCluster = (String)ccrMetadata.get("remote_cluster_name");
        this.client.getRemoteClusterClient(leaderCluster, this.remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
        String leaderIndex = (String)ccrMetadata.get("leader_index_name");
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchLeaderIndexMetadataAndHistoryUUIDs(this.client, leaderCluster, leaderIndex, arg_0 -> listener.onFailure(arg_0), (leaderHistoryUUID, leaderIndexMetadata) -> {
            try {
                this.start(request, leaderCluster, (IndexMetadata)leaderIndexMetadata.v1(), followerIndexMetadata, (String[])leaderHistoryUUID, listener);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    void start(ResumeFollowAction.Request request, String clusterNameAlias, IndexMetadata leaderIndexMetadata, IndexMetadata followIndexMetadata, String[] leaderIndexHistoryUUIDs, ActionListener<AcknowledgedResponse> listener) throws IOException {
        MapperService mapperService = followIndexMetadata != null ? this.indicesService.createIndexMapperServiceForValidation(followIndexMetadata) : null;
        TransportResumeFollowAction.validate(request, leaderIndexMetadata, followIndexMetadata, leaderIndexHistoryUUIDs, mapperService);
        int numShards = followIndexMetadata.getNumberOfShards();
        ResponseHandler handler = new ResponseHandler(numShards, listener);
        Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)this.clusterService.state());
        for (int shardId = 0; shardId < numShards; ++shardId) {
            String taskId = followIndexMetadata.getIndexUUID() + "-" + shardId;
            ShardFollowTask shardFollowTask = TransportResumeFollowAction.createShardFollowTask(shardId, clusterNameAlias, request.getParameters(), leaderIndexMetadata, followIndexMetadata, filteredHeaders);
            this.persistentTasksService.sendStartRequest(taskId, "xpack/ccr/shard_follow_task", (PersistentTaskParams)shardFollowTask, request.masterNodeTimeout(), handler.getActionListener(shardId));
        }
    }

    static void validate(ResumeFollowAction.Request request, IndexMetadata leaderIndex, IndexMetadata followIndex, String[] leaderIndexHistoryUUID, MapperService followerMapperService) {
        String recordedLeaderIndexUUID;
        Map ccrIndexMetadata = followIndex.getCustomData("ccr");
        if (ccrIndexMetadata == null) {
            throw new IllegalArgumentException("follow index [" + followIndex.getIndex().getName() + "] does not have ccr metadata");
        }
        String leaderIndexUUID = leaderIndex.getIndex().getUUID();
        if (!leaderIndexUUID.equals(recordedLeaderIndexUUID = (String)ccrIndexMetadata.get("leader_index_uuid"))) {
            throw new IllegalArgumentException("follow index [" + request.getFollowerIndex() + "] should reference [" + leaderIndexUUID + "] as leader index but instead reference [" + recordedLeaderIndexUUID + "] as leader index");
        }
        String[] recordedHistoryUUIDs = TransportResumeFollowAction.extractLeaderShardHistoryUUIDs(ccrIndexMetadata);
        assert (recordedHistoryUUIDs.length == leaderIndexHistoryUUID.length);
        for (int i = 0; i < leaderIndexHistoryUUID.length; ++i) {
            String recordedLeaderIndexHistoryUUID = recordedHistoryUUIDs[i];
            String actualLeaderIndexHistoryUUID = leaderIndexHistoryUUID[i];
            if (recordedLeaderIndexHistoryUUID.equals(actualLeaderIndexHistoryUUID)) continue;
            throw new IllegalArgumentException("leader shard [" + request.getFollowerIndex() + "][" + i + "] should reference [" + recordedLeaderIndexHistoryUUID + "] as history uuid but instead reference [" + actualLeaderIndexHistoryUUID + "] as history uuid");
        }
        if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(leaderIndex.getSettings())).booleanValue()) {
            throw new IllegalArgumentException("leader index [" + leaderIndex.getIndex().getName() + "] does not have soft deletes enabled");
        }
        if (leaderIndex.isSearchableSnapshot()) {
            throw new IllegalArgumentException("leader index [" + leaderIndex.getIndex().getName() + "] is a searchable snapshot index and cannot be used for cross-cluster replication purpose");
        }
        if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(followIndex.getSettings())).booleanValue()) {
            throw new IllegalArgumentException("follower index [" + request.getFollowerIndex() + "] does not have soft deletes enabled");
        }
        if (followIndex.isSearchableSnapshot()) {
            throw new IllegalArgumentException("follower index [" + request.getFollowerIndex() + "] is a searchable snapshot index and cannot be used for cross-cluster replication purpose");
        }
        if (leaderIndex.getNumberOfShards() != followIndex.getNumberOfShards()) {
            throw new IllegalArgumentException("leader index primary shards [" + leaderIndex.getNumberOfShards() + "] does not match with the number of shards of the follow index [" + followIndex.getNumberOfShards() + "]");
        }
        if (leaderIndex.getRoutingNumShards() != followIndex.getRoutingNumShards()) {
            throw new IllegalArgumentException("leader index number_of_routing_shards [" + leaderIndex.getRoutingNumShards() + "] does not match with the number_of_routing_shards of the follow index [" + followIndex.getRoutingNumShards() + "]");
        }
        if (leaderIndex.getState() != IndexMetadata.State.OPEN || followIndex.getState() != IndexMetadata.State.OPEN) {
            throw new IllegalArgumentException("leader and follow index must be open");
        }
        if (!((Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(followIndex.getSettings())).booleanValue()) {
            throw new IllegalArgumentException("the following index [" + request.getFollowerIndex() + "] is not ready to follow; the setting [" + CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey() + "] must be enabled.");
        }
        TransportResumeFollowAction.validateSettings(leaderIndex.getSettings(), followIndex.getSettings());
        followerMapperService.merge(leaderIndex, MapperService.MergeReason.MAPPING_RECOVERY);
    }

    private static void validateSettings(Settings leaderIndexSettings, Settings followerIndexSettings) {
        Settings followerSettings;
        Settings leaderSettings = TransportResumeFollowAction.filter(leaderIndexSettings);
        if (!leaderSettings.equals((Object)(followerSettings = TransportResumeFollowAction.filter(followerIndexSettings)))) {
            String message = String.format(Locale.ROOT, "the leader index settings [%s] and follower index settings [%s] must be identical", leaderSettings, followerSettings);
            throw new IllegalArgumentException(message);
        }
    }

    private static ShardFollowTask createShardFollowTask(int shardId, String clusterAliasName, FollowParameters parameters, IndexMetadata leaderIndexMetadata, IndexMetadata followIndexMetadata, Map<String, String> filteredHeaders) {
        int maxReadRequestOperationCount = parameters.getMaxReadRequestOperationCount() != null ? parameters.getMaxReadRequestOperationCount() : 5120;
        ByteSizeValue maxReadRequestSize = parameters.getMaxReadRequestSize() != null ? parameters.getMaxReadRequestSize() : DEFAULT_MAX_READ_REQUEST_SIZE;
        int maxOutstandingReadRequests = parameters.getMaxOutstandingReadRequests() != null ? parameters.getMaxOutstandingReadRequests() : 12;
        int maxWriteRequestOperationCount = parameters.getMaxWriteRequestOperationCount() != null ? parameters.getMaxWriteRequestOperationCount() : 5120;
        ByteSizeValue maxWriteRequestSize = parameters.getMaxWriteRequestSize() != null ? parameters.getMaxWriteRequestSize() : DEFAULT_MAX_WRITE_REQUEST_SIZE;
        int maxOutstandingWriteRequests = parameters.getMaxOutstandingWriteRequests() != null ? parameters.getMaxOutstandingWriteRequests() : 9;
        int maxWriteBufferCount = parameters.getMaxWriteBufferCount() != null ? parameters.getMaxWriteBufferCount() : Integer.MAX_VALUE;
        ByteSizeValue maxWriteBufferSize = parameters.getMaxWriteBufferSize() != null ? parameters.getMaxWriteBufferSize() : DEFAULT_MAX_WRITE_BUFFER_SIZE;
        TimeValue maxRetryDelay = parameters.getMaxRetryDelay() == null ? DEFAULT_MAX_RETRY_DELAY : parameters.getMaxRetryDelay();
        TimeValue readPollTimeout = parameters.getReadPollTimeout() == null ? DEFAULT_READ_POLL_TIMEOUT : parameters.getReadPollTimeout();
        return new ShardFollowTask(clusterAliasName, new ShardId(followIndexMetadata.getIndex(), shardId), new ShardId(leaderIndexMetadata.getIndex(), shardId), maxReadRequestOperationCount, maxWriteRequestOperationCount, maxOutstandingReadRequests, maxOutstandingWriteRequests, maxReadRequestSize, maxWriteRequestSize, maxWriteBufferCount, maxWriteBufferSize, maxRetryDelay, readPollTimeout, filteredHeaders);
    }

    static String[] extractLeaderShardHistoryUUIDs(Map<String, String> ccrIndexMetadata) {
        String historyUUIDs = ccrIndexMetadata.get("leader_index_shard_history_uuids");
        if (historyUUIDs == null) {
            throw new IllegalArgumentException("leader index shard UUIDs are missing");
        }
        return historyUUIDs.split(",");
    }

    public static Settings filter(Settings originalSettings) {
        Settings.Builder settings = Settings.builder().put(originalSettings);
        settings.remove(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey());
        settings.remove(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey());
        settings.remove("index.version.created");
        settings.remove("index.uuid");
        settings.remove("index.history.uuid");
        settings.remove("index.provided_name");
        settings.remove("index.creation_date");
        settings.remove("index.version.upgraded");
        settings.remove("index.version.upgraded_string");
        Iterator iterator = settings.keys().iterator();
        block0: while (iterator.hasNext()) {
            String key = (String)iterator.next();
            for (Setting<?> whitelistedSetting : NON_REPLICATED_SETTINGS) {
                if (!whitelistedSetting.match(key)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return settings.build();
    }
}

