/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.http.ContentTooLongException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.BackoffPolicy;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.RejectAwareActionListener;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.reindex.remote.RemoteRequestBuilders;
import org.elasticsearch.reindex.remote.RemoteResponseParsers;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class RemoteScrollableHitSource
extends ScrollableHitSource {
    private final RestClient client;
    private final RemoteInfo remote;
    private final SearchRequest searchRequest;
    Version remoteVersion;

    public RemoteScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<ScrollableHitSource.AsyncResponse> onResponse, Consumer<Exception> fail, RestClient client, RemoteInfo remoteInfo, SearchRequest searchRequest) {
        super(logger, backoffPolicy, threadPool, countSearchRetry, onResponse, fail);
        this.remote = remoteInfo;
        this.searchRequest = searchRequest;
        this.client = client;
    }

    protected void doStart(RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        this.lookupRemoteVersion((RejectAwareActionListener<Version>)RejectAwareActionListener.withResponseHandler(searchListener, version -> {
            this.remoteVersion = version;
            this.execute(RemoteRequestBuilders.initialSearch(this.searchRequest, this.remote.getQuery(), this.remoteVersion), (BiFunction)RemoteResponseParsers.RESPONSE_PARSER, (RejectAwareActionListener)RejectAwareActionListener.withResponseHandler((RejectAwareActionListener)searchListener, r -> this.onStartResponse(searchListener, (ScrollableHitSource.Response)r)));
        }));
    }

    void lookupRemoteVersion(RejectAwareActionListener<Version> listener) {
        this.execute(new Request("GET", ""), (BiFunction)RemoteResponseParsers.MAIN_ACTION_PARSER, (RejectAwareActionListener)listener);
    }

    private void onStartResponse(RejectAwareActionListener<ScrollableHitSource.Response> searchListener, ScrollableHitSource.Response response) {
        if (org.elasticsearch.common.Strings.hasLength((String)response.getScrollId()) && response.getHits().isEmpty()) {
            this.logger.debug("First response looks like a scan response. Jumping right to the second. scroll=[{}]", (Object)response.getScrollId());
            this.doStartNextScroll(response.getScrollId(), TimeValue.timeValueMillis((long)0L), searchListener);
        } else {
            searchListener.onResponse((Object)response);
        }
    }

    protected void doStartNextScroll(String scrollId, TimeValue extraKeepAlive, RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        TimeValue keepAlive = TimeValue.timeValueNanos((long)(this.searchRequest.scroll().nanos() + extraKeepAlive.nanos()));
        this.execute(RemoteRequestBuilders.scroll(scrollId, keepAlive, this.remoteVersion), (BiFunction)RemoteResponseParsers.RESPONSE_PARSER, (RejectAwareActionListener)searchListener);
    }

    protected void clearScroll(final String scrollId, final Runnable onCompletion) {
        this.client.performRequestAsync(RemoteRequestBuilders.clearScroll(scrollId, this.remoteVersion), new ResponseListener(){

            public void onSuccess(Response response) {
                RemoteScrollableHitSource.this.logger.debug("Successfully cleared [{}]", (Object)scrollId);
                onCompletion.run();
            }

            public void onFailure(Exception e) {
                this.logFailure(e);
                onCompletion.run();
            }

            private void logFailure(Exception e) {
                if (e instanceof ResponseException) {
                    ResponseException re = (ResponseException)e;
                    if (RemoteScrollableHitSource.this.remoteVersion.before((VersionId)Version.fromId((int)2000099)) && re.getResponse().getStatusLine().getStatusCode() == 404) {
                        RemoteScrollableHitSource.this.logger.debug(() -> Strings.format((String)"Failed to clear scroll [%s] from pre-2.0 Elasticsearch. This is normal if the request terminated normally as the scroll has already been cleared automatically.", (Object[])new Object[]{scrollId}), (Throwable)e);
                        return;
                    }
                }
                RemoteScrollableHitSource.this.logger.warn(() -> "Failed to clear scroll [" + scrollId + "]", (Throwable)e);
            }
        });
    }

    protected void cleanup(Runnable onCompletion) {
        this.threadPool.generic().submit(() -> {
            try {
                this.client.close();
                this.logger.debug("Shut down remote connection");
                this.remote.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to shutdown the remote connection", (Throwable)e);
            }
            finally {
                onCompletion.run();
            }
        });
    }

    private <T> void execute(Request request, final BiFunction<XContentParser, XContentType, T> parser, final RejectAwareActionListener<? super T> listener) {
        final Supplier contextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        try {
            this.client.performRequestAsync(request, new ResponseListener(){

                public void onSuccess(Response response) {
                    try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                        Object parsedResponse;
                        assert (ctx != null);
                        try {
                            HttpEntity responseEntity = response.getEntity();
                            InputStream content = responseEntity.getContent();
                            XContentType xContentType = null;
                            if (responseEntity.getContentType() != null) {
                                String mimeType = ContentType.parse((String)responseEntity.getContentType().getValue()).getMimeType();
                                xContentType = XContentType.fromMediaType((String)mimeType);
                            }
                            if (xContentType == null) {
                                try {
                                    throw new ElasticsearchException("Response didn't include Content-Type: " + RemoteScrollableHitSource.bodyMessage(response.getEntity()), new Object[0]);
                                }
                                catch (IOException e) {
                                    ElasticsearchException ee = new ElasticsearchException("Error extracting body from response", new Object[0]);
                                    ee.addSuppressed((Throwable)e);
                                    throw ee;
                                }
                            }
                            try (XContentParser xContentParser = xContentType.xContent().createParser(XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), content);){
                                parsedResponse = parser.apply(xContentParser, xContentType);
                            }
                            catch (XContentParseException e) {
                                throw new ElasticsearchException("Error parsing the response, remote is likely not an Elasticsearch instance", (Throwable)e, new Object[0]);
                            }
                        }
                        catch (IOException e) {
                            throw new ElasticsearchException("Error deserializing response, remote is likely not an Elasticsearch instance", (Throwable)e, new Object[0]);
                        }
                        listener.onResponse(parsedResponse);
                    }
                }

                public void onFailure(Exception e) {
                    try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                        assert (ctx != null);
                        if (e instanceof ResponseException) {
                            ResponseException re = (ResponseException)e;
                            int statusCode = re.getResponse().getStatusLine().getStatusCode();
                            e = RemoteScrollableHitSource.wrapExceptionToPreserveStatus(statusCode, re.getResponse().getEntity(), (Exception)re);
                            if (RestStatus.TOO_MANY_REQUESTS.getStatus() == statusCode) {
                                listener.onRejection(e);
                                return;
                            }
                        } else if (e instanceof ContentTooLongException) {
                            e = new IllegalArgumentException("Remote responded with a chunk that was too large. Use a smaller batch size.", e);
                        }
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    static ElasticsearchStatusException wrapExceptionToPreserveStatus(int statusCode, @Nullable HttpEntity entity, Exception cause) {
        RestStatus status = RestStatus.fromCode((int)statusCode);
        Object messagePrefix = "";
        if (status == null) {
            messagePrefix = "Couldn't extract status [" + statusCode + "]. ";
            status = RestStatus.INTERNAL_SERVER_ERROR;
        }
        try {
            return new ElasticsearchStatusException((String)messagePrefix + RemoteScrollableHitSource.bodyMessage(entity), status, (Throwable)cause, new Object[0]);
        }
        catch (IOException ioe) {
            ElasticsearchStatusException e = new ElasticsearchStatusException((String)messagePrefix + "Failed to extract body.", status, (Throwable)cause, new Object[0]);
            e.addSuppressed((Throwable)ioe);
            return e;
        }
    }

    private static String bodyMessage(@Nullable HttpEntity entity) throws IOException {
        if (entity == null) {
            return "No error body.";
        }
        return "body=" + EntityUtils.toString((HttpEntity)entity);
    }
}

