/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public final class RequestInfo {
    private static final String CANVAS = "canvas";
    public static final String ODBC_32 = "odbc32";
    private static final String ODBC_64 = "odbc64";
    public static final Set<String> CLIENT_IDS;
    public static final Set<String> ODBC_CLIENT_IDS;
    private Mode mode;
    private String clientId;
    private SqlVersion version;

    public RequestInfo(Mode mode) {
        this(mode, null, null);
    }

    public RequestInfo(Mode mode, String clientId) {
        this(mode, clientId, null);
    }

    public RequestInfo(Mode mode, String clientId, String version) {
        this.mode(mode);
        this.clientId(clientId);
        this.version(version);
    }

    public RequestInfo(Mode mode, SqlVersion version) {
        this.mode(mode);
        this.version = version;
    }

    public Mode mode() {
        return this.mode;
    }

    public void mode(Mode mode) {
        this.mode = mode;
    }

    public String clientId() {
        return this.clientId;
    }

    public void clientId(String clientId) {
        if (clientId != null && !CLIENT_IDS.contains(clientId = clientId.toLowerCase(Locale.ROOT))) {
            clientId = null;
        }
        this.clientId = clientId;
    }

    public void version(String clientVersion) {
        this.version = SqlVersion.fromString(clientVersion);
    }

    public SqlVersion version() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.clientId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestInfo that = (RequestInfo)o;
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.clientId, that.clientId);
    }

    static {
        HashSet<String> clientIds = new HashSet<String>(4);
        clientIds.add(CANVAS);
        clientIds.add(ODBC_32);
        clientIds.add(ODBC_64);
        HashSet<String> odbcClientIds = new HashSet<String>(2);
        odbcClientIds.add(ODBC_32);
        odbcClientIds.add(ODBC_64);
        CLIENT_IDS = Collections.unmodifiableSet(clientIds);
        ODBC_CLIENT_IDS = Collections.unmodifiableSet(odbcClientIds);
    }
}

