/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets;

import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.secrets.action.DeleteConnectorSecretResponse;
import org.elasticsearch.xpack.application.connector.secrets.action.GetConnectorSecretResponse;
import org.elasticsearch.xpack.application.connector.secrets.action.PostConnectorSecretRequest;
import org.elasticsearch.xpack.application.connector.secrets.action.PostConnectorSecretResponse;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretRequest;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretResponse;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class ConnectorSecretsIndexService {
    private final Client clientWithOrigin;
    public static final String CONNECTOR_SECRETS_INDEX_NAME = ".connector-secrets";
    private static final int CURRENT_INDEX_VERSION = 1;
    private static final String MAPPING_VERSION_VARIABLE = "connector-secrets.version";
    private static final String MAPPING_MANAGED_VERSION_VARIABLE = "connector-secrets.managed.index.version";

    public ConnectorSecretsIndexService(Client client) {
        this.clientWithOrigin = new OriginSettingClient(client, "connectors");
    }

    public static SystemIndexDescriptor getSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        String templateSource = TemplateUtils.loadTemplate((String)"/connector-secrets.json", (String)Version.CURRENT.toString(), (String)MAPPING_VERSION_VARIABLE, Map.of(MAPPING_MANAGED_VERSION_VARIABLE, Integer.toString(1)));
        request.source(templateSource, XContentType.JSON);
        return SystemIndexDescriptor.builder().setIndexPattern(".connector-secrets*").setPrimaryIndex(".connector-secrets-1").setDescription("Secret values managed by Connectors").setMappings(request.mappings()).setSettings(request.settings()).setAliasName(CONNECTOR_SECRETS_INDEX_NAME).setOrigin("connectors").setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).build();
    }

    public void getSecret(String id, ActionListener<GetConnectorSecretResponse> listener) {
        this.clientWithOrigin.prepareGet(CONNECTOR_SECRETS_INDEX_NAME, id).execute(listener.delegateFailureAndWrap((delegate, getResponse) -> {
            if (getResponse.isSourceEmpty()) {
                delegate.onFailure((Exception)new ResourceNotFoundException("No secret with id [" + id + "]", new Object[0]));
                return;
            }
            delegate.onResponse((Object)new GetConnectorSecretResponse(getResponse.getId(), getResponse.getSource().get("value").toString()));
        }));
    }

    public void createSecret(PostConnectorSecretRequest request, ActionListener<PostConnectorSecretResponse> listener) {
        try {
            this.clientWithOrigin.prepareIndex(CONNECTOR_SECRETS_INDEX_NAME).setSource(request.toXContent(XContentFactory.jsonBuilder())).execute(listener.delegateFailureAndWrap((l, indexResponse) -> l.onResponse((Object)new PostConnectorSecretResponse(indexResponse.getId()))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void createSecretWithDocId(PutConnectorSecretRequest request, ActionListener<PutConnectorSecretResponse> listener) {
        String connectorSecretId = request.id();
        try {
            this.clientWithOrigin.prepareIndex(CONNECTOR_SECRETS_INDEX_NAME).setId(connectorSecretId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).setSource(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).execute(listener.delegateFailureAndWrap((l, indexResponse) -> l.onResponse((Object)new PutConnectorSecretResponse(indexResponse.getResult()))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteSecret(String id, ActionListener<DeleteConnectorSecretResponse> listener) {
        try {
            this.clientWithOrigin.prepareDelete(CONNECTOR_SECRETS_INDEX_NAME, id).execute(listener.delegateFailureAndWrap((delegate, deleteResponse) -> {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    delegate.onFailure((Exception)new ResourceNotFoundException("No secret with id [" + id + "]", new Object[0]));
                    return;
                }
                delegate.onResponse((Object)new DeleteConnectorSecretResponse(deleteResponse.getResult() == DocWriteResponse.Result.DELETED));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

