/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorConfiguration;
import org.elasticsearch.xpack.application.connector.ConnectorFeatures;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.ConnectorInvalidStatusTransitionException;
import org.elasticsearch.xpack.application.connector.ConnectorScheduling;
import org.elasticsearch.xpack.application.connector.ConnectorSearchResult;
import org.elasticsearch.xpack.application.connector.ConnectorStateMachine;
import org.elasticsearch.xpack.application.connector.ConnectorStatus;
import org.elasticsearch.xpack.application.connector.ConnectorSyncInfo;
import org.elasticsearch.xpack.application.connector.action.ConnectorCreateActionResponse;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorApiKeyIdAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorConfigurationAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorIndexNameAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorLastSyncStatsAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorNameAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorNativeAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorPipelineAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorSchedulingAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorServiceTypeAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorStatusAction;
import org.elasticsearch.xpack.application.connector.filtering.FilteringAdvancedSnippet;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRule;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationInfo;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationState;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobIndexService;

public class ConnectorIndexService {
    private final Client clientWithOrigin;
    public static final String CONNECTOR_INDEX_NAME = ".elastic-connectors-v1";

    public ConnectorIndexService(Client client) {
        this.clientWithOrigin = new OriginSettingClient(client, "connectors");
    }

    public void createConnector(String connectorId, String description, String indexName, Boolean isNative, String language, String name, String serviceType, ActionListener<ConnectorCreateActionResponse> listener) {
        Connector connector = this.createConnectorWithDefaultValues(description, indexName, isNative, language, name, serviceType);
        try {
            this.isDataIndexNameAlreadyInUse(indexName, connectorId, (ActionListener<Boolean>)listener.delegateFailure((l, isIndexNameInUse) -> {
                if (isIndexNameInUse.booleanValue()) {
                    l.onFailure((Exception)new ElasticsearchStatusException("Index name [" + indexName + "] is used by another connector.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                try {
                    IndexRequest indexRequest = ((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(connector.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
                    if (!Strings.isNullOrEmpty((String)connectorId)) {
                        indexRequest = indexRequest.id(connectorId);
                    }
                    this.clientWithOrigin.index(indexRequest, listener.delegateFailureAndWrap((ll, indexResponse) -> ll.onResponse((Object)new ConnectorCreateActionResponse(indexResponse.getId(), indexResponse.getResult()))));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private Connector createConnectorWithDefaultValues(String description, String indexName, Boolean isNative, String language, String name, String serviceType) {
        boolean isNativeConnector = Objects.requireNonNullElse(isNative, false);
        ConnectorStatus status = isNativeConnector ? ConnectorStatus.NEEDS_CONFIGURATION : ConnectorStatus.CREATED;
        return new Connector.Builder().setConfiguration(Collections.emptyMap()).setCustomScheduling(Collections.emptyMap()).setDescription(description).setFiltering(List.of(ConnectorFiltering.getDefaultConnectorFilteringConfig())).setIndexName(indexName).setIsNative(isNativeConnector).setLanguage(language).setSyncInfo(new ConnectorSyncInfo.Builder().build()).setName(Objects.requireNonNullElse(name, "")).setScheduling(ConnectorScheduling.getDefaultConnectorScheduling()).setServiceType(serviceType).setStatus(status).build();
    }

    public void getConnector(String connectorId, boolean includeDeleted, ActionListener<ConnectorSearchResult> listener) {
        try {
            GetRequest getRequest = new GetRequest(CONNECTOR_INDEX_NAME).id(connectorId).realtime(true);
            this.clientWithOrigin.get(getRequest, new DelegatingIndexNotFoundActionListener<GetResponse, ConnectorSearchResult>(connectorId, listener, (l, getResponse) -> {
                if (!getResponse.isExists()) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                try {
                    boolean connectorIsSoftDeleted;
                    ConnectorSearchResult connector = new ConnectorSearchResult.Builder().setId(connectorId).setResultBytes(getResponse.getSourceAsBytesRef()).setResultMap(getResponse.getSourceAsMap()).build();
                    boolean bl = connectorIsSoftDeleted = !includeDeleted && this.isConnectorDeleted(connector);
                    if (connectorIsSoftDeleted) {
                        l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    l.onResponse((Object)connector);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteConnector(String connectorId, boolean hardDelete, boolean shouldDeleteSyncJobs, ActionListener<DocWriteResponse> listener) {
        try {
            if (hardDelete) {
                DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(CONNECTOR_INDEX_NAME).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.clientWithOrigin.delete(deleteRequest, new DelegatingIndexNotFoundActionListener<DeleteResponse, DocWriteResponse>(connectorId, listener, (l, deleteResponse) -> {
                    if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    if (shouldDeleteSyncJobs) {
                        new ConnectorSyncJobIndexService(this.clientWithOrigin).deleteAllSyncJobsByConnectorId(connectorId, (ActionListener<BulkByScrollResponse>)l.map(r -> deleteResponse));
                    } else {
                        l.onResponse(deleteResponse);
                    }
                }));
            } else {
                this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
                    UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).source(Map.of(Connector.IS_DELETED_FIELD.getPreferredName(), true)));
                    this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, l, (ll, updateResponse) -> {
                        if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                            ll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                            return;
                        }
                        if (shouldDeleteSyncJobs) {
                            new ConnectorSyncJobIndexService(this.clientWithOrigin).deleteAllSyncJobsByConnectorId(connectorId, (ActionListener<BulkByScrollResponse>)ll.map(r -> updateResponse));
                        } else {
                            ll.onResponse(updateResponse);
                        }
                    }));
                }));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void listConnectors(int from, int size, List<String> indexNames, List<String> connectorNames, List<String> serviceTypes, String searchQuery, boolean includeDeleted, final ActionListener<ConnectorResult> listener) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().from(from).size(size).query(this.buildListQuery(indexNames, connectorNames, serviceTypes, searchQuery, includeDeleted)).fetchSource(true).sort(Connector.INDEX_NAME_FIELD.getPreferredName(), SortOrder.ASC);
            SearchRequest req = new SearchRequest(new String[]{CONNECTOR_INDEX_NAME}).source(source);
            this.clientWithOrigin.search(req, (ActionListener)new ActionListener<SearchResponse>(this){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        listener.onResponse((Object)ConnectorIndexService.mapSearchResponseToConnectorList(searchResponse));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)new ConnectorResult(Collections.emptyList(), 0L));
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private QueryBuilder buildListQuery(List<String> indexNames, List<String> connectorNames, List<String> serviceTypes, String searchQuery, boolean includeDeleted) {
        boolean filterByIndexNames = indexNames != null && !indexNames.isEmpty();
        boolean filterByConnectorNames = indexNames != null && !connectorNames.isEmpty();
        boolean filterByServiceTypes = serviceTypes != null && !serviceTypes.isEmpty();
        boolean filterBySearchQuery = !Strings.isNullOrEmpty((String)searchQuery);
        boolean usesFilter = filterByIndexNames || filterByConnectorNames || filterByServiceTypes || filterBySearchQuery;
        BoolQueryBuilder boolFilterQueryBuilder = new BoolQueryBuilder();
        if (usesFilter) {
            if (filterByIndexNames) {
                boolFilterQueryBuilder.must().add(new TermsQueryBuilder(Connector.INDEX_NAME_FIELD.getPreferredName(), indexNames));
            }
            if (filterByConnectorNames) {
                boolFilterQueryBuilder.must().add(new TermsQueryBuilder(Connector.NAME_FIELD.getPreferredName(), connectorNames));
            }
            if (filterByServiceTypes) {
                boolFilterQueryBuilder.must().add(new TermsQueryBuilder(Connector.SERVICE_TYPE_FIELD.getPreferredName(), serviceTypes));
            }
            if (filterBySearchQuery) {
                String wildcardQueryValue = "*" + searchQuery + "*";
                boolFilterQueryBuilder.must().add(new BoolQueryBuilder().should((QueryBuilder)new WildcardQueryBuilder(Connector.INDEX_NAME_FIELD.getPreferredName(), wildcardQueryValue)).should((QueryBuilder)new WildcardQueryBuilder(Connector.NAME_FIELD.getPreferredName(), wildcardQueryValue)).should((QueryBuilder)new WildcardQueryBuilder(Connector.DESCRIPTION_FIELD.getPreferredName(), wildcardQueryValue)));
            }
        }
        if (!includeDeleted) {
            boolFilterQueryBuilder.mustNot((QueryBuilder)new TermQueryBuilder(Connector.IS_DELETED_FIELD.getPreferredName(), true));
        }
        return boolFilterQueryBuilder;
    }

    public void updateConnectorConfiguration(UpdateConnectorConfigurationAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            Map<String, ConnectorConfiguration> fullConfiguration = request.getConfiguration();
            Map<String, Object> configurationValues = request.getConfigurationValues();
            String connectorId = request.getConnectorId();
            this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                if (fullConfiguration != null) {
                    String updateConfigurationScript = String.format(Locale.ROOT, "ctx._source.%s = params.%s;\nctx._source.%s = params.%s;\n", Connector.CONFIGURATION_FIELD.getPreferredName(), Connector.CONFIGURATION_FIELD.getPreferredName(), Connector.STATUS_FIELD.getPreferredName(), Connector.STATUS_FIELD.getPreferredName());
                    Script script = new Script(ScriptType.INLINE, "painless", updateConfigurationScript, Map.of(Connector.CONFIGURATION_FIELD.getPreferredName(), request.getConfigurationAsMap(), Connector.STATUS_FIELD.getPreferredName(), ConnectorStatus.CONFIGURED.toString()));
                    updateRequest = updateRequest.script(script);
                } else if (configurationValues != null) {
                    Set newConfigurationKeys;
                    Set<String> existingKeys = this.getConnectorConfigurationFromSearchResult((ConnectorSearchResult)connector).keySet();
                    if (!existingKeys.containsAll(newConfigurationKeys = configurationValues.keySet())) {
                        Set unknownConfigKeys = newConfigurationKeys.stream().filter(key -> !existingKeys.contains(key)).collect(Collectors.toSet());
                        l.onFailure((Exception)new ElasticsearchStatusException("Unknown [configuration] fields in the request payload: [" + String.join((CharSequence)", ", unknownConfigKeys) + "]. Remove them from request or register their schema first.", RestStatus.BAD_REQUEST, new Object[0]));
                        return;
                    }
                    Map<String, Object> configurationValuesUpdatePayload = configurationValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Map.of(ConnectorConfiguration.VALUE_FIELD.getPreferredName(), entry.getValue())));
                    updateRequest = updateRequest.doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.CONFIGURATION_FIELD.getPreferredName(), configurationValuesUpdatePayload, Connector.STATUS_FIELD.getPreferredName(), ConnectorStatus.CONFIGURED.toString())));
                } else {
                    l.onFailure((Exception)new ElasticsearchStatusException("[configuration] and [values] cannot both be null.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, l, (ll, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        ll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    ll.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorError(String connectorId, final String error, ActionListener<UpdateResponse> listener) {
        try {
            final ConnectorStatus connectorStatus = Strings.isNullOrEmpty((String)error) ? ConnectorStatus.CONNECTED : ConnectorStatus.ERROR;
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source((Map)new HashMap<String, Object>(){
                {
                    this.put(Connector.ERROR_FIELD.getPreferredName(), error);
                    this.put(Connector.STATUS_FIELD.getPreferredName(), connectorStatus.toString());
                }
            }));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorNameOrDescription(UpdateConnectorNameAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorFiltering(String connectorId, List<ConnectorFiltering> filtering, ActionListener<UpdateResponse> listener) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.FILTERING_FIELD.getPreferredName(), filtering)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorFeatures(String connectorId, ConnectorFeatures features, ActionListener<UpdateResponse> listener) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.FEATURES_FIELD.getPreferredName(), features)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorFilteringDraft(String connectorId, FilteringAdvancedSnippet advancedSnippet, List<FilteringRule> rules, ActionListener<UpdateResponse> listener) {
        try {
            this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
                ArrayList<FilteringRule> newDraftRules;
                List<ConnectorFiltering> connectorFilteringList = ConnectorFiltering.fromXContentBytesConnectorFiltering(connector.getSourceRef(), XContentType.JSON);
                ConnectorFiltering connectorFilteringSingleton = connectorFilteringList.get(0);
                FilteringAdvancedSnippet newDraftAdvancedSnippet = advancedSnippet == null ? connectorFilteringSingleton.getDraft().getAdvancedSnippet() : advancedSnippet;
                List<Object> list = newDraftRules = rules == null ? connectorFilteringSingleton.getDraft().getRules() : new ArrayList(rules);
                if (rules != null) {
                    newDraftRules = ConnectorFiltering.sortFilteringRulesByOrder(newDraftRules);
                }
                ConnectorFiltering connectorFilteringWithUpdatedDraft = connectorFilteringSingleton.setDraft(new FilteringRules.Builder().setRules(newDraftRules).setAdvancedSnippet(newDraftAdvancedSnippet).setFilteringValidationInfo(FilteringValidationInfo.getInitialDraftValidationInfo()).build());
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.FILTERING_FIELD.getPreferredName(), List.of(connectorFilteringWithUpdatedDraft))));
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, listener, (ll, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        ll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    ll.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorDraftFilteringValidation(String connectorId, FilteringValidationInfo validation, ActionListener<UpdateResponse> listener) {
        this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
            try {
                List<ConnectorFiltering> connectorFilteringList = ConnectorFiltering.fromXContentBytesConnectorFiltering(connector.getSourceRef(), XContentType.JSON);
                ConnectorFiltering connectorFilteringSingleton = connectorFilteringList.get(0);
                ConnectorFiltering activatedConnectorFiltering = connectorFilteringSingleton.setDraft(new FilteringRules.Builder().setRules(connectorFilteringSingleton.getDraft().getRules()).setAdvancedSnippet(connectorFilteringSingleton.getDraft().getAdvancedSnippet()).setFilteringValidationInfo(validation).build());
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.FILTERING_FIELD.getPreferredName(), List.of(activatedConnectorFiltering))));
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, l, (ll, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        ll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    ll.onResponse(updateResponse);
                }));
            }
            catch (Exception e) {
                l.onFailure(e);
            }
        }));
    }

    public void activateConnectorDraftFiltering(String connectorId, ActionListener<UpdateResponse> listener) {
        this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
            try {
                List<ConnectorFiltering> connectorFilteringList = ConnectorFiltering.fromXContentBytesConnectorFiltering(connector.getSourceRef(), XContentType.JSON);
                ConnectorFiltering connectorFilteringSingleton = connectorFilteringList.get(0);
                FilteringValidationState currentValidationState = connectorFilteringSingleton.getDraft().getFilteringValidationInfo().getValidationState();
                if (currentValidationState != FilteringValidationState.VALID) {
                    throw new ElasticsearchStatusException("Filtering draft needs to be validated by the connector service before activation. Current filtering draft validation state [" + currentValidationState.toString() + "] is not equal to [" + String.valueOf((Object)FilteringValidationState.VALID) + "].", RestStatus.BAD_REQUEST, new Object[0]);
                }
                ConnectorFiltering activatedConnectorFiltering = connectorFilteringSingleton.setActive(connectorFilteringSingleton.getDraft());
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.FILTERING_FIELD.getPreferredName(), List.of(activatedConnectorFiltering))));
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, l, (ll, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        ll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    ll.onResponse(updateResponse);
                }));
            }
            catch (Exception e) {
                l.onFailure(e);
            }
        }));
    }

    public void checkInConnector(String connectorId, ActionListener<UpdateResponse> listener) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.LAST_SEEN_FIELD.getPreferredName(), Instant.now())));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorLastSyncStats(UpdateConnectorLastSyncStatsAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorNative(UpdateConnectorNativeAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            boolean isNative = request.isNative();
            this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
                boolean doesNotHaveContentPrefix;
                String indexName = this.getConnectorIndexNameFromSearchResult((ConnectorSearchResult)connector);
                boolean bl = doesNotHaveContentPrefix = indexName != null && !this.isValidManagedConnectorIndexName(indexName);
                if (isNative && doesNotHaveContentPrefix) {
                    l.onFailure((Exception)new ElasticsearchStatusException("The index name [" + indexName + "] attached to the connector [" + connectorId + "] must start with the required prefix: [content-] to be Elastic-managed. Please update the attached index first to comply with this requirement.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                ConnectorStatus status = this.getConnectorStatusFromSearchResult((ConnectorSearchResult)connector);
                boolean isConnected = status == ConnectorStatus.CONNECTED;
                boolean isValidTransitionToConfigured = ConnectorStateMachine.isValidTransition(status, ConnectorStatus.CONFIGURED);
                if (isConnected && isValidTransitionToConfigured) {
                    status = ConnectorStatus.CONFIGURED;
                }
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).source(Map.of(Connector.IS_NATIVE_FIELD.getPreferredName(), isNative, Connector.STATUS_FIELD.getPreferredName(), status.toString())));
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, listener, (ll, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        ll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    ll.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorPipeline(UpdateConnectorPipelineAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.PIPELINE_FIELD.getPreferredName(), request.getPipeline())).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorIndexName(final UpdateConnectorIndexNameAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            String indexName = request.getIndexName();
            this.isDataIndexNameAlreadyInUse(indexName, connectorId, (ActionListener<Boolean>)listener.delegateFailure((l, isIndexNameInUse) -> {
                if (isIndexNameInUse.booleanValue()) {
                    l.onFailure((Exception)new ElasticsearchStatusException("Index name [" + indexName + "] is used by another connector.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)l.delegateFailure((ll, connector) -> {
                    Boolean isNativeConnector = this.getConnectorIsNativeFlagFromSearchResult((ConnectorSearchResult)connector);
                    Boolean doesNotHaveContentPrefix = indexName != null && !this.isValidManagedConnectorIndexName(indexName);
                    if (isNativeConnector.booleanValue() && doesNotHaveContentPrefix.booleanValue()) {
                        ll.onFailure((Exception)new ElasticsearchStatusException("Index attached to an Elastic-managed connector must start with the prefix: [content-]. The index name in the payload [" + indexName + "] doesn't comply with this requirement.", RestStatus.BAD_REQUEST, new Object[0]));
                        return;
                    }
                    UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source((Map)new HashMap<String, Object>(){
                        {
                            this.put(Connector.INDEX_NAME_FIELD.getPreferredName(), request.getIndexName());
                        }
                    }));
                    this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, listener, (lll, updateResponse) -> {
                        if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                            lll.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                            return;
                        }
                        lll.onResponse(updateResponse);
                    }));
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorScheduling(UpdateConnectorSchedulingAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.SCHEDULING_FIELD.getPreferredName(), request.getScheduling())));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorServiceType(UpdateConnectorServiceTypeAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
                ConnectorStatus prevStatus = this.getConnectorStatusFromSearchResult((ConnectorSearchResult)connector);
                ConnectorStatus newStatus = prevStatus == ConnectorStatus.CREATED ? ConnectorStatus.CREATED : ConnectorStatus.NEEDS_CONFIGURATION;
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.SERVICE_TYPE_FIELD.getPreferredName(), request.getServiceType(), Connector.STATUS_FIELD.getPreferredName(), newStatus.toString())));
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, listener, (updateListener, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        updateListener.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    updateListener.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorStatus(UpdateConnectorStatusAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            ConnectorStatus newStatus = request.getStatus();
            this.getConnector(connectorId, false, (ActionListener<ConnectorSearchResult>)listener.delegateFailure((l, connector) -> {
                ConnectorStatus prevStatus = this.getConnectorStatusFromSearchResult((ConnectorSearchResult)connector);
                try {
                    ConnectorStateMachine.assertValidStateTransition(prevStatus, newStatus);
                }
                catch (ConnectorInvalidStatusTransitionException e) {
                    l.onFailure((Exception)new ElasticsearchStatusException(e.getMessage(), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
                    return;
                }
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(Map.of(Connector.STATUS_FIELD.getPreferredName(), request.getStatus())));
                this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener(connectorId, listener, (updateListener, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        updateListener.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                        return;
                    }
                    updateListener.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateConnectorApiKeyIdOrApiKeySecretId(UpdateConnectorApiKeyIdAction.Request request, ActionListener<UpdateResponse> listener) {
        try {
            String connectorId = request.getConnectorId();
            UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_INDEX_NAME, connectorId).doc(((IndexRequest)new IndexRequest(CONNECTOR_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).id(connectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(request.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)));
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundActionListener<UpdateResponse, UpdateResponse>(connectorId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(this.connectorNotFoundErrorMsg(connectorId), new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private ConnectorStatus getConnectorStatusFromSearchResult(ConnectorSearchResult searchResult) {
        return ConnectorStatus.connectorStatus((String)searchResult.getResultMap().get(Connector.STATUS_FIELD.getPreferredName()));
    }

    private Boolean getConnectorIsNativeFlagFromSearchResult(ConnectorSearchResult searchResult) {
        return (Boolean)searchResult.getResultMap().get(Connector.IS_NATIVE_FIELD.getPreferredName());
    }

    private String getConnectorIndexNameFromSearchResult(ConnectorSearchResult searchResult) {
        return (String)searchResult.getResultMap().get(Connector.INDEX_NAME_FIELD.getPreferredName());
    }

    private boolean isValidManagedConnectorIndexName(String indexName) {
        return indexName.startsWith("content-");
    }

    private Map<String, Object> getConnectorConfigurationFromSearchResult(ConnectorSearchResult searchResult) {
        return (Map)searchResult.getResultMap().get(Connector.CONFIGURATION_FIELD.getPreferredName());
    }

    private boolean isConnectorDeleted(ConnectorSearchResult searchResult) {
        Boolean isDeletedFlag = (Boolean)searchResult.getResultMap().get(Connector.IS_DELETED_FIELD.getPreferredName());
        return Boolean.TRUE.equals(isDeletedFlag);
    }

    private static ConnectorResult mapSearchResponseToConnectorList(SearchResponse response) {
        List<ConnectorSearchResult> connectorResults = Arrays.stream(response.getHits().getHits()).map(ConnectorIndexService::hitToConnector).toList();
        return new ConnectorResult(connectorResults, (int)response.getHits().getTotalHits().value());
    }

    private static ConnectorSearchResult hitToConnector(SearchHit searchHit) {
        return new ConnectorSearchResult.Builder().setId(searchHit.getId()).setResultBytes(searchHit.getSourceRef()).setResultMap(searchHit.getSourceAsMap()).build();
    }

    private void isDataIndexNameAlreadyInUse(String indexName, String connectorId, final ActionListener<Boolean> listener) {
        if (indexName == null) {
            listener.onResponse((Object)false);
            return;
        }
        try {
            BoolQueryBuilder boolFilterQueryBuilder = new BoolQueryBuilder();
            boolFilterQueryBuilder.must().add(new TermQueryBuilder(Connector.INDEX_NAME_FIELD.getPreferredName(), indexName));
            boolFilterQueryBuilder.mustNot((QueryBuilder)new TermQueryBuilder(Connector.IS_DELETED_FIELD.getPreferredName(), true));
            if (connectorId != null) {
                boolFilterQueryBuilder.mustNot((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{connectorId}));
            }
            SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)boolFilterQueryBuilder);
            SearchRequest searchRequest = new SearchRequest(new String[]{CONNECTOR_INDEX_NAME}).source(searchSource);
            this.clientWithOrigin.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){

                public void onResponse(SearchResponse searchResponse) {
                    boolean indexNameIsInUse = searchResponse.getHits().getTotalHits().value() > 0L;
                    listener.onResponse((Object)indexNameIsInUse);
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)false);
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private String connectorNotFoundErrorMsg(String connectorId) {
        return "connector [" + connectorId + "] not found";
    }

    static class DelegatingIndexNotFoundActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;
        private final String connectorId;

        DelegatingIndexNotFoundActionListener(String connectorId, ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
            this.connectorId = connectorId;
        }

        public void onResponse(T t) {
            this.bc.accept((ActionListener<R>)this.delegate, (ActionListener)t);
        }

        public void onFailure(Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                this.delegate.onFailure((Exception)new ResourceNotFoundException("connector [" + this.connectorId + "] not found", new Object[0]));
                return;
            }
            this.delegate.onFailure(e);
        }
    }

    public record ConnectorResult(List<ConnectorSearchResult> connectors, long totalResults) {
    }
}

