/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.Requests;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.esnative.UserAndPassword;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativeUsersStore {
    public static final String USER_DOC_TYPE = "user";
    public static final String RESERVED_USER_TYPE = "reserved-user";
    public static final String USER_NOT_FOUND_MESSAGE = "user must exist in order to change password";
    private static final Logger logger = LogManager.getLogger(NativeUsersStore.class);
    private final Settings settings;
    private final Client client;
    private final SecurityIndexManager securityIndex;

    public NativeUsersStore(Settings settings, Client client, SecurityIndexManager securityIndex) {
        this.settings = settings;
        this.client = client;
        this.securityIndex = securityIndex;
    }

    public void getUser(String username, ActionListener<User> listener) {
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(uap -> listener.onResponse((Object)(uap == null ? null : uap.user())), arg_0 -> listener.onFailure(arg_0)));
    }

    public void getUsers(String[] userNames, ActionListener<Collection<User>> listener) {
        Consumer<Exception> handleException = t -> {
            if (TransportActions.isShardNotAvailableException((Throwable)t)) {
                logger.trace("could not retrieve users because of a shard not available exception", (Throwable)t);
                if (t instanceof IndexNotFoundException) {
                    listener.onResponse(Collections.emptyList());
                } else {
                    listener.onFailure(t);
                }
            }
            listener.onFailure(t);
        };
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else if (userNames.length == 1) {
            String username = userNames[0];
            this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(uap -> listener.onResponse(uap == null ? Collections.emptyList() : Collections.singletonList(uap.user())), handleException));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder query;
                if (userNames == null || userNames.length == 0) {
                    query = QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)USER_DOC_TYPE);
                } else {
                    String[] users = (String[])Arrays.stream(userNames).map(s -> NativeUsersStore.getIdForUser(USER_DOC_TYPE, s)).toArray(String[]::new);
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery().addIds(users));
                }
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> {
                        UserAndPassword u = NativeUsersStore.transformUser(hit.getId(), hit.getSourceAsMap());
                        return u != null ? u.user() : null;
                    });
                }
            });
        }
    }

    public void queryUsers(SearchRequest searchRequest, ActionListener<QueryUserResults> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            logger.debug("security index does not exist");
            listener.onResponse((Object)QueryUserResults.EMPTY);
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
                long total = searchResponse.getHits().getTotalHits().value();
                if (total == 0L) {
                    logger.debug("No users found for query [{}]", (Object)searchRequest.source().query());
                    listener.onResponse((Object)QueryUserResults.EMPTY);
                    return;
                }
                List<QueryUserResult> userItems = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> {
                    UserAndPassword userAndPassword = NativeUsersStore.transformUser(hit.getId(), hit.getSourceAsMap());
                    return userAndPassword != null ? new QueryUserResult(userAndPassword.user(), hit.getSortValues()) : null;
                }).filter(Objects::nonNull).toList();
                listener.onResponse((Object)new QueryUserResults(userItems, total));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        }
    }

    void getUserCount(ActionListener<Long> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)0L);
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)((SearchRequest)this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)USER_DOC_TYPE)).setSize(0).setTrackTotalHits(true).request()), (ActionListener)listener.safeMap(response -> response.getHits().getTotalHits().value()), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1)));
        }
    }

    private void getUserAndPassword(final String user, final ActionListener<UserAndPassword> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            if (!frozenSecurityIndex.indexExists()) {
                logger.trace("could not retrieve user [{}] because security index does not exist", (Object)user);
            } else {
                logger.warn("could not retrieve user [{}] because security index is not available", (Object)user);
            }
            listener.onResponse(null);
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)((GetRequest)this.client.prepareGet(".security", NativeUsersStore.getIdForUser(USER_DOC_TYPE, user)).request()), (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    logger.trace("user [{}] is doc [{}] in index [{}] with primTerm [{}] and seqNo [{}]", (Object)user, (Object)response.getId(), (Object)response.getIndex(), (Object)response.getPrimaryTerm(), (Object)response.getSeqNo());
                    listener.onResponse((Object)NativeUsersStore.transformUser(response.getId(), response.getSource()));
                }

                public void onFailure(Exception t) {
                    if (t instanceof IndexNotFoundException) {
                        logger.trace(() -> "could not retrieve user [" + user + "] because security index does not exist", (Throwable)t);
                    } else {
                        logger.error(() -> "failed to retrieve user [" + user + "]", (Throwable)t);
                    }
                    listener.onResponse(null);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
        }
    }

    public void changePassword(final ChangePasswordRequest request, final ActionListener<Void> listener) {
        final String username = request.username();
        final String docType = ClientReservedRealm.isReserved((String)username, (Settings)this.settings) ? RESERVED_USER_TYPE : USER_DOC_TYPE;
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareUpdate(".security", NativeUsersStore.getIdForUser(docType, username)).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(request.passwordHash())}).setRefreshPolicy(request.getRefreshPolicy()).request(), (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED || updateResponse.getResult() == DocWriteResponse.Result.NOOP);
                NativeUsersStore.this.clearRealmCache(request.username(), listener, null);
            }

            public void onFailure(Exception e) {
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    if (docType.equals(NativeUsersStore.RESERVED_USER_TYPE)) {
                        NativeUsersStore.this.updateReservedUser(username, request.passwordHash(), DocWriteRequest.OpType.INDEX, request.getRefreshPolicy(), (ActionListener<Void>)listener);
                    } else {
                        logger.debug(() -> Strings.format((String)"failed to change password for user [%s]", (Object[])new Object[]{request.username()}), (Throwable)e);
                        ValidationException validationException = new ValidationException();
                        validationException.addValidationError(NativeUsersStore.USER_NOT_FOUND_MESSAGE);
                        listener.onFailure((Exception)validationException);
                    }
                } else {
                    listener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
    }

    public void createElasticUser(char[] passwordHash, ActionListener<Void> listener) {
        this.updateReservedUser("elastic", passwordHash, DocWriteRequest.OpType.CREATE, WriteRequest.RefreshPolicy.IMMEDIATE, listener);
    }

    private void updateReservedUser(String username, char[] passwordHash, DocWriteRequest.OpType opType, WriteRequest.RefreshPolicy refresh, ActionListener<Void> listener) {
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareIndex(".security").setOpType(opType).setId(NativeUsersStore.getIdForUser(RESERVED_USER_TYPE, username)).setSource(new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(passwordHash), User.Fields.ENABLED.getPreferredName(), true, User.Fields.TYPE.getPreferredName(), RESERVED_USER_TYPE}).setRefreshPolicy(refresh).request(), (ActionListener)listener.delegateFailure((l, indexResponse) -> this.clearRealmCache(username, (ActionListener)l, null)), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
    }

    public void putUser(PutUserRequest request, ActionListener<Boolean> listener) {
        if (request.passwordHash() == null) {
            this.updateUserWithoutPassword(request, listener);
        } else {
            this.indexUser(request, listener);
        }
    }

    private void updateUserWithoutPassword(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        assert (putUserRequest.passwordHash() == null);
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareUpdate(".security", NativeUsersStore.getIdForUser(USER_DOC_TYPE, putUserRequest.username())).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata(), User.Fields.ENABLED.getPreferredName(), putUserRequest.enabled(), User.Fields.TYPE.getPreferredName(), USER_DOC_TYPE}).setRefreshPolicy(putUserRequest.getRefreshPolicy()).request(), (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED || updateResponse.getResult() == DocWriteResponse.Result.NOOP) : "Expected 'UPDATED' or 'NOOP' result [" + String.valueOf(updateResponse) + "] for request [" + String.valueOf(putUserRequest) + "]";
                NativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, false);
            }

            public void onFailure(Exception e) {
                Exception failure = e;
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    logger.debug(() -> Strings.format((String)"failed to update user document with username [%s]", (Object[])new Object[]{putUserRequest.username()}), (Throwable)e);
                    ValidationException validationException = new ValidationException();
                    validationException.addValidationError("password must be specified unless you are updating an existing user");
                    failure = validationException;
                }
                listener.onFailure(failure);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
    }

    private void indexUser(PutUserRequest putUserRequest, ActionListener<Boolean> listener) {
        assert (putUserRequest.passwordHash() != null);
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareIndex(".security").setId(NativeUsersStore.getIdForUser(USER_DOC_TYPE, putUserRequest.username())).setSource(new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.PASSWORD.getPreferredName(), String.valueOf(putUserRequest.passwordHash()), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata(), User.Fields.ENABLED.getPreferredName(), putUserRequest.enabled(), User.Fields.TYPE.getPreferredName(), USER_DOC_TYPE}).setRefreshPolicy(putUserRequest.getRefreshPolicy()).request(), (ActionListener)listener.delegateFailure((l, updateResponse) -> this.clearRealmCache(putUserRequest.username(), (ActionListener)l, updateResponse.getResult() == DocWriteResponse.Result.CREATED)), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
    }

    public void setEnabled(String username, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Void> listener) {
        if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
            this.setReservedUserEnabled(username, enabled, refreshPolicy, true, listener);
        } else {
            this.setRegularUserEnabled(username, enabled, refreshPolicy, listener);
        }
    }

    private void setRegularUserEnabled(final String username, final boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<Void> listener) {
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareUpdate(".security", NativeUsersStore.getIdForUser(USER_DOC_TYPE, username)).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), enabled}).setRefreshPolicy(refreshPolicy).request(), (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                NativeUsersStore.this.clearRealmCache(username, listener, null);
            }

            public void onFailure(Exception e) {
                Exception failure = e;
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    logger.debug(() -> Strings.format((String)"failed to %s user [%s]", (Object[])new Object[]{enabled ? "enable" : "disable", username}), (Throwable)e);
                    ValidationException validationException = new ValidationException();
                    validationException.addValidationError("only existing users can be " + (enabled ? "enabled" : "disabled"));
                    failure = validationException;
                }
                listener.onFailure(failure);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
    }

    private void setReservedUserEnabled(String username, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, boolean clearCache, ActionListener<Void> listener) {
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareUpdate(".security", NativeUsersStore.getIdForUser(RESERVED_USER_TYPE, username)).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), enabled}).setUpsert(XContentType.JSON, new Object[]{User.Fields.PASSWORD.getPreferredName(), "", User.Fields.ENABLED.getPreferredName(), enabled, User.Fields.TYPE.getPreferredName(), RESERVED_USER_TYPE}).setRefreshPolicy(refreshPolicy).request(), (ActionListener)listener.delegateFailure((l, updateResponse) -> {
            if (clearCache) {
                this.clearRealmCache(username, (ActionListener)l, null);
            } else {
                l.onResponse(null);
            }
        }), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
    }

    public void deleteUser(DeleteUserRequest deleteUserRequest, ActionListener<Boolean> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)false);
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                DeleteRequest request = this.client.prepareDelete(".security", NativeUsersStore.getIdForUser(USER_DOC_TYPE, deleteUserRequest.username())).request();
                request.setRefreshPolicy(deleteUserRequest.getRefreshPolicy());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)request, (ActionListener)listener.delegateFailure((l, deleteResponse) -> this.clearRealmCache(deleteUserRequest.username(), (ActionListener)l, deleteResponse.getResult() == DocWriteResponse.Result.DELETED)), (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
            });
        }
    }

    void verifyPassword(String username, SecureString password, ActionListener<AuthenticationResult<User>> listener) {
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(userAndPassword -> {
            if (userAndPassword == null) {
                logger.trace("user [{}] does not exist in index [{}], cannot authenticate against the native realm", (Object)username, (Object)this.securityIndex.aliasName());
                listener.onResponse((Object)AuthenticationResult.notHandled());
            } else if (userAndPassword.passwordHash() == null) {
                logger.debug("user [{}] in index [{}] does not have a password, cannot authenticate", (Object)username, (Object)this.securityIndex.aliasName());
                listener.onResponse((Object)AuthenticationResult.notHandled());
            } else if (userAndPassword.verifyPassword(password)) {
                logger.trace("successfully authenticated user [{}] (security index [{}])", userAndPassword, (Object)this.securityIndex.aliasName());
                listener.onResponse((Object)AuthenticationResult.success((Object)userAndPassword.user()));
            } else {
                logger.trace("password mismatch for user [{}] (security index [{}])", userAndPassword, (Object)this.securityIndex.aliasName());
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Password authentication failed for " + username), null));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    void getReservedUserInfo(final String username, final ActionListener<ReservedUserInfo> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(null);
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)((GetRequest)this.client.prepareGet(".security", NativeUsersStore.getIdForUser(RESERVED_USER_TYPE, username)).request()), (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse getResponse) {
                    if (getResponse.isExists()) {
                        Map sourceMap = getResponse.getSourceAsMap();
                        String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
                        Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
                        if (password == null) {
                            listener.onFailure((Exception)new IllegalStateException("password hash must not be null!"));
                        } else if (enabled == null) {
                            listener.onFailure((Exception)new IllegalStateException("enabled must not be null!"));
                        } else if (password.isEmpty()) {
                            listener.onResponse((Object)(enabled != false ? ReservedUserInfo.defaultEnabledUserInfo() : ReservedUserInfo.defaultDisabledUserInfo()));
                        } else {
                            listener.onResponse((Object)new ReservedUserInfo(password.toCharArray(), enabled));
                        }
                    } else {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception e) {
                    if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                        logger.trace(() -> Strings.format((String)"could not retrieve built in user [%s] info since security index unavailable", (Object[])new Object[]{username}), (Throwable)e);
                    }
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
        }
    }

    void getAllReservedUserInfo(final ActionListener<Map<String, ReservedUserInfo>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyMap());
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)((SearchRequest)this.client.prepareSearch(new String[]{".security"}).setTrackTotalHits(true).setQuery((QueryBuilder)QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)RESERVED_USER_TYPE)).setFetchSource(true).request()), (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    HashMap<String, ReservedUserInfo> userInfos = new HashMap<String, ReservedUserInfo>();
                    assert (searchResponse.getHits().getTotalHits().value() <= 10L) : "there are more than 10 reserved users we need to change this to retrieve them all!";
                    for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                        Map sourceMap = searchHit.getSourceAsMap();
                        String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
                        Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
                        String id = searchHit.getId();
                        assert (id != null && id.startsWith(NativeUsersStore.RESERVED_USER_TYPE)) : "id [" + id + "] does not start with reserved-user prefix";
                        String username = id.substring(NativeUsersStore.RESERVED_USER_TYPE.length() + 1);
                        if (password == null) {
                            listener.onFailure((Exception)new IllegalStateException("password hash must not be null!"));
                            return;
                        }
                        if (enabled == null) {
                            listener.onFailure((Exception)new IllegalStateException("enabled must not be null!"));
                            return;
                        }
                        userInfos.put(username, new ReservedUserInfo(password.toCharArray(), enabled));
                    }
                    listener.onResponse(userInfos);
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        logger.trace("could not retrieve built in users since security index does not exist", (Throwable)e);
                        listener.onResponse(Collections.emptyMap());
                    } else {
                        logger.error("failed to retrieve built in users", (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            }, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1)));
        }
    }

    private <Response> void clearRealmCache(final String username, final ActionListener<Response> listener, final Response response) {
        ClearRealmCacheRequest request = new ClearRealmCacheRequest().usernames(new String[]{username});
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearRealmCacheAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<ClearRealmCacheResponse>(this){

            public void onResponse(ClearRealmCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                logger.error(() -> "unable to clear realm cache for user [" + username + "]", (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + username + "] failed. please clear the realm cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)((Object)exception));
            }
        });
    }

    @Nullable
    private static UserAndPassword transformUser(String id, Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        assert (id != null && id.startsWith(USER_DOC_TYPE)) : "id [" + id + "] does not start with user prefix";
        String username = id.substring(USER_DOC_TYPE.length() + 1);
        try {
            String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
            String[] roles = ((List)sourceMap.get(User.Fields.ROLES.getPreferredName())).toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
            String fullName = (String)sourceMap.get(User.Fields.FULL_NAME.getPreferredName());
            String email = (String)sourceMap.get(User.Fields.EMAIL.getPreferredName());
            Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
            if (enabled == null) {
                enabled = Boolean.TRUE;
            }
            Map metadata = (Map)sourceMap.get(User.Fields.METADATA.getPreferredName());
            return new UserAndPassword(new User(username, roles, fullName, email, metadata, enabled.booleanValue()), password.toCharArray());
        }
        catch (Exception e) {
            logger.error(() -> "error in the format of data for user [" + username + "]", (Throwable)e);
            return null;
        }
    }

    private static boolean isIndexNotFoundOrDocumentMissing(Exception e) {
        Throwable cause;
        return e instanceof ElasticsearchException && ((cause = ExceptionsHelper.unwrapCause((Throwable)e)) instanceof IndexNotFoundException || cause instanceof DocumentMissingException);
    }

    public static String getIdForUser(String docType, String userName) {
        return docType + "-" + userName;
    }

    public record QueryUserResults(List<QueryUserResult> userQueryResult, long total) {
        public static final QueryUserResults EMPTY = new QueryUserResults(List.of(), 0L);
    }

    public record QueryUserResult(User user, Object[] sortValues) {
    }

    static final class ReservedUserInfo {
        public final char[] passwordHash;
        public final boolean enabled;
        private final Hasher hasher;

        ReservedUserInfo(char[] passwordHash, boolean enabled) {
            this.passwordHash = passwordHash;
            this.enabled = enabled;
            this.hasher = Hasher.resolveFromHash((char[])this.passwordHash);
        }

        boolean hasEmptyPassword() {
            return this.passwordHash.length == 0;
        }

        boolean verifyPassword(SecureString data) {
            return this.hasher.verify(data, this.passwordHash);
        }

        static ReservedUserInfo defaultEnabledUserInfo() {
            return new ReservedUserInfo(new char[0], true);
        }

        static ReservedUserInfo defaultDisabledUserInfo() {
            return new ReservedUserInfo(new char[0], false);
        }
    }
}

