/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.embeddings;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public enum CohereEmbeddingType {
    FLOAT(DenseVectorFieldMapper.ElementType.FLOAT, "float"),
    INT8(DenseVectorFieldMapper.ElementType.BYTE, "int8"),
    BYTE(DenseVectorFieldMapper.ElementType.BYTE, "int8");

    private static final Map<DenseVectorFieldMapper.ElementType, CohereEmbeddingType> ELEMENT_TYPE_TO_COHERE_EMBEDDING;
    static final EnumSet<DenseVectorFieldMapper.ElementType> SUPPORTED_ELEMENT_TYPES;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final String requestString;

    private CohereEmbeddingType(DenseVectorFieldMapper.ElementType elementType, String requestString) {
        this.elementType = elementType;
        this.requestString = requestString;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toRequestString() {
        return this.requestString;
    }

    public static String toLowerCase(CohereEmbeddingType type) {
        return type.toString().toLowerCase(Locale.ROOT);
    }

    public static CohereEmbeddingType fromString(String name) {
        return CohereEmbeddingType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static CohereEmbeddingType fromElementType(DenseVectorFieldMapper.ElementType elementType) {
        CohereEmbeddingType embedding = ELEMENT_TYPE_TO_COHERE_EMBEDDING.get(elementType);
        if (embedding == null) {
            Object[] validElementTypes = (String[])SUPPORTED_ELEMENT_TYPES.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
            Arrays.sort(validElementTypes);
            throw new IllegalArgumentException(Strings.format((String)"Element type [%s] does not map to a Cohere embedding value, must be one of [%s]", (Object[])new Object[]{elementType, String.join((CharSequence)", ", (CharSequence[])validElementTypes)}));
        }
        return embedding;
    }

    public DenseVectorFieldMapper.ElementType toElementType() {
        return this.elementType;
    }

    public static CohereEmbeddingType translateToVersion(CohereEmbeddingType embeddingType, TransportVersion version) {
        if (version.before((VersionId)TransportVersions.V_8_14_0) && embeddingType == BYTE) {
            return INT8;
        }
        return embeddingType;
    }

    static {
        ELEMENT_TYPE_TO_COHERE_EMBEDDING = Map.of(DenseVectorFieldMapper.ElementType.FLOAT, FLOAT, DenseVectorFieldMapper.ElementType.BYTE, BYTE);
        SUPPORTED_ELEMENT_TYPES = EnumSet.copyOf(ELEMENT_TYPE_TO_COHERE_EMBEDDING.keySet());
    }

    private static final class RequestConstants {
        private static final String FLOAT = "float";
        private static final String INT8 = "int8";

        private RequestConstants() {
        }
    }
}

