/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.completion;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioConstants;

public record AzureAiStudioChatCompletionRequestTaskSettings(@Nullable Double temperature, @Nullable Double topP, @Nullable Boolean doSample, @Nullable Integer maxNewTokens) {
    public static final AzureAiStudioChatCompletionRequestTaskSettings EMPTY_SETTINGS = new AzureAiStudioChatCompletionRequestTaskSettings(null, null, null, null);

    public static AzureAiStudioChatCompletionRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        Double temperature = ServiceUtils.extractOptionalDoubleInRange(map, "temperature", AzureAiStudioConstants.MIN_TEMPERATURE_TOP_P, AzureAiStudioConstants.MAX_TEMPERATURE_TOP_P, "task_settings", validationException);
        Double topP = ServiceUtils.extractOptionalDoubleInRange(map, "top_p", AzureAiStudioConstants.MIN_TEMPERATURE_TOP_P, AzureAiStudioConstants.MAX_TEMPERATURE_TOP_P, "task_settings", validationException);
        Boolean doSample = ServiceUtils.extractOptionalBoolean(map, "do_sample", validationException);
        Integer maxNewTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_new_tokens", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioChatCompletionRequestTaskSettings(temperature, topP, doSample, maxNewTokens);
    }
}

