/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapCheck;
import co.elastic.apm.agent.premain.common.util.SystemStandardOutputLogger;
import co.elastic.apm.agent.premain.common.util.WildcardMatcher;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ExcludeJvmBootstrapCheck
implements BootstrapCheck {
    public static final String ALLOWLIST_SYSTEM_PROPERTY = "elastic.apm.bootstrap_allowlist";
    public static final String ALLOWLIST_ENV_VARIABLE = "ELASTIC_APM_BOOTSTRAP_ALLOWLIST";
    public static final String EXCLUDE_LIST_SYSTEM_PROPERTY = "elastic.apm.bootstrap_exclude_list";
    public static final String EXCLUDE_LIST_ENV_VARIABLE = "ELASTIC_APM_BOOTSTRAP_EXCLUDE_LIST";
    @Nullable
    private final String cmd;
    @Nullable
    private String allowListRaw;
    @Nullable
    private List<WildcardMatcher> configuredAllowList;
    @Nullable
    private String excludeListRaw;
    @Nullable
    private List<String> configuredExcludeList;

    public ExcludeJvmBootstrapCheck(@Nullable String cmd) {
        this.cmd = cmd;
        this.allowListRaw = System.getProperty(ALLOWLIST_SYSTEM_PROPERTY);
        if (this.allowListRaw == null) {
            this.allowListRaw = System.getenv(ALLOWLIST_ENV_VARIABLE);
        }
        if (this.allowListRaw != null) {
            this.configuredAllowList = this.parse(this.allowListRaw, new WildCardMatcherConverter());
        }
        this.excludeListRaw = System.getProperty(EXCLUDE_LIST_SYSTEM_PROPERTY);
        if (this.excludeListRaw == null) {
            this.excludeListRaw = System.getenv(EXCLUDE_LIST_ENV_VARIABLE);
        }
        if (this.excludeListRaw != null) {
            this.configuredExcludeList = this.parse(this.excludeListRaw, new StringConverter());
        }
    }

    @Override
    public void doBootstrapCheck(final BootstrapCheck.BootstrapCheckResult result) {
        if (this.configuredAllowList != null) {
            if (this.cmd == null || this.cmd.isEmpty()) {
                result.addWarn(String.format("'%s' or '%s' are configured, but they cannot be matched with the JVM command,as it is not properly discovered: '%s'", ALLOWLIST_SYSTEM_PROPERTY, ALLOWLIST_ENV_VARIABLE, this.cmd));
            } else {
                if (WildcardMatcher.isNoneMatch(this.configuredAllowList, this.cmd)) {
                    result.addError(String.format("'%s' or '%s' are configured with the pattern list '%s', which does not match this JVM's command: '%s'", ALLOWLIST_SYSTEM_PROPERTY, ALLOWLIST_ENV_VARIABLE, this.allowListRaw, this.cmd));
                } else {
                    SystemStandardOutputLogger.stdOutInfo(String.format("Attaching an agent to this process as its command '%s' matches the configured allowlist: '%s'%n", this.cmd, this.allowListRaw));
                }
                return;
            }
        }
        if (this.configuredExcludeList != null) {
            if (System.getSecurityManager() == null) {
                this.doExcludeListCheck(result, this.configuredExcludeList);
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExcludeJvmBootstrapCheck.this.doExcludeListCheck(result, ExcludeJvmBootstrapCheck.this.configuredExcludeList);
                    return null;
                }
            });
        }
    }

    private void doExcludeListCheck(BootstrapCheck.BootstrapCheckResult result, List<String> excludeSystemProperties) {
        for (String excludeSystemProperty : excludeSystemProperties) {
            if (System.getProperty(excludeSystemProperty) == null) continue;
            result.addError(String.format("Found the '%s' System property, which is configured to cause the exclusion of this JVM. Change either the '%s' System property or '%s' environment variable setting in order to override this exclusion. Current configured value is: '%s'.", excludeSystemProperty, EXCLUDE_LIST_SYSTEM_PROPERTY, EXCLUDE_LIST_ENV_VARIABLE, this.excludeListRaw));
            return;
        }
    }

    private <T> List<T> parse(String commaSeparatedList, ListItemConverter<T> converter) {
        if (commaSeparatedList != null && commaSeparatedList.length() > 0) {
            ArrayList<T> result = new ArrayList<T>();
            for (String part : commaSeparatedList.split(",")) {
                result.add(converter.convert(part.trim()));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private static class WildCardMatcherConverter
    implements ListItemConverter<WildcardMatcher> {
        private WildCardMatcherConverter() {
        }

        @Override
        public WildcardMatcher convert(String rawValue) {
            return WildcardMatcher.valueOf(rawValue);
        }
    }

    private static interface ListItemConverter<T> {
        public T convert(String var1);
    }

    private static class StringConverter
    implements ListItemConverter<String> {
        private StringConverter() {
        }

        @Override
        public String convert(String rawValue) {
            return rawValue;
        }
    }
}

