/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.plan.logical.AbstractJoin;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Join
extends AbstractJoin {
    private final KeyedFilter until;
    private final Attribute timestamp;
    private final Attribute tiebreaker;
    private final Order.OrderDirection direction;

    public Join(Source source, List<KeyedFilter> queries, KeyedFilter until, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction) {
        super(source, queries, until);
        this.until = until;
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
        this.direction = direction;
    }

    private Join(Source source, List<LogicalPlan> queries, LogicalPlan until, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction) {
        this(source, Join.asKeyed(queries), Join.asKeyed(until), timestamp, tiebreaker, direction);
    }

    protected NodeInfo<? extends Join> info() {
        return NodeInfo.create((Node)this, Join::new, this.queries(), (Object)((Object)this.until), (Object)this.timestamp, (Object)this.tiebreaker, (Object)this.direction);
    }

    public Join replaceChildren(List<LogicalPlan> newChildren) {
        int lastIndex = newChildren.size() - 1;
        return new Join(this.source(), newChildren.subList(0, lastIndex), newChildren.get(lastIndex), this.timestamp, this.tiebreaker, this.direction);
    }

    @Override
    public List<Attribute> output() {
        ArrayList<Attribute> out = new ArrayList<Attribute>();
        out.add(this.timestamp);
        if (Expressions.isPresent((NamedExpression)this.tiebreaker)) {
            out.add(this.tiebreaker);
        }
        out.addAll(super.output());
        return out;
    }

    @Override
    public boolean expressionsResolved() {
        return this.timestamp.resolved() && this.tiebreaker.resolved() && this.until.resolved() && super.expressionsResolved();
    }

    public KeyedFilter until() {
        return this.until;
    }

    public Attribute timestamp() {
        return this.timestamp;
    }

    public Attribute tiebreaker() {
        return this.tiebreaker;
    }

    public Order.OrderDirection direction() {
        return this.direction;
    }

    public Join with(List<KeyedFilter> queries, KeyedFilter until, Order.OrderDirection direction) {
        return new Join(this.source(), queries, until, this.timestamp, this.tiebreaker, direction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.timestamp, this.tiebreaker, this.until, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Join other = (Join)((Object)obj);
            return Objects.equals(this.direction, other.direction) && Objects.equals((Object)this.until, (Object)other.until) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.tiebreaker, other.tiebreaker);
        }
        return false;
    }

    public List<Object> nodeProperties() {
        return Collections.singletonList(this.direction);
    }
}

