/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.eql.execution.ExecutionUtils;
import org.elasticsearch.xpack.eql.execution.assembler.BoxedQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.Executable;
import org.elasticsearch.xpack.eql.execution.assembler.SequenceCriterion;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.execution.search.Timestamp;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceMatcher;
import org.elasticsearch.xpack.eql.execution.sequence.SequencePayload;
import org.elasticsearch.xpack.eql.session.EmptyPayload;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.eql.util.ReversedIterator;
import org.elasticsearch.xpack.eql.util.SearchHitUtils;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.util.ActionListeners;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class TumblingWindow
implements Executable {
    private static final int CACHE_MAX_SIZE = 64;
    private static final int MISSING_EVENTS_SEQUENCES_CHECK_BATCH_SIZE = 1000;
    private static final Logger log = LogManager.getLogger(TumblingWindow.class);
    private final Map<String, String> stringCache = new LinkedHashMap<String, String>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() >= 64;
        }
    };
    private final QueryClient client;
    private final List<SequenceCriterion> criteria;
    private final SequenceCriterion until;
    private final SequenceMatcher matcher;
    private final int maxStages;
    private final int windowSize;
    private final boolean hasKeys;
    private final List<List<Attribute>> listOfKeys;
    private final boolean allowPartialSearchResults;
    private final boolean allowPartialSequenceResults;
    private Map<String, ShardSearchFailure> shardFailures = new HashMap<String, ShardSearchFailure>();
    private boolean restartWindowFromTailQuery;
    private long startTime;

    public TumblingWindow(QueryClient client, List<SequenceCriterion> criteria, SequenceCriterion until, SequenceMatcher matcher, List<List<Attribute>> listOfKeys, boolean allowPartialSearchResults, boolean allowPartialSequenceResults) {
        this.client = client;
        this.until = until;
        this.criteria = criteria;
        this.maxStages = criteria.size();
        this.matcher = matcher;
        SequenceCriterion baseRequest = criteria.get(matcher.firstPositiveStage);
        this.windowSize = baseRequest.queryRequest().searchSource().size();
        this.hasKeys = baseRequest.keySize() > 0;
        this.restartWindowFromTailQuery = baseRequest.descending();
        this.listOfKeys = listOfKeys;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.allowPartialSequenceResults = allowPartialSequenceResults;
    }

    @Override
    public void execute(ActionListener<Payload> listener) {
        log.trace("Starting sequence window w/ fetch size [{}]", (Object)this.windowSize);
        this.startTime = System.currentTimeMillis();
        this.tumbleWindow(this.matcher.firstPositiveStage, (ActionListener<Payload>)ActionListener.runAfter(listener, () -> {
            this.matcher.clear();
            this.client.close((ActionListener<Boolean>)listener.delegateFailure((l, r) -> {}));
        }));
    }

    private void tumbleWindow(int currentStage, ActionListener<Payload> listener) {
        if (!this.allowPartialSequenceResults && !this.shardFailures.isEmpty()) {
            this.doPayload(listener);
        }
        if (currentStage > this.matcher.firstPositiveStage && !this.matcher.hasCandidates()) {
            if (this.restartWindowFromTailQuery) {
                currentStage = this.matcher.firstPositiveStage;
            } else {
                this.checkMissingEvents(() -> this.doPayload(listener), listener);
                return;
            }
        }
        log.trace("Tumbling window...");
        if (this.restartWindowFromTailQuery) {
            if (currentStage == this.matcher.firstPositiveStage) {
                this.matcher.trim(null);
            }
        } else {
            Ordinal marker = this.criteria.get(currentStage).queryRequest().after();
            if (marker != null) {
                this.matcher.trim(marker);
            }
        }
        int c = currentStage;
        this.checkMissingEvents(() -> this.advance(c, listener), listener);
    }

    private void rebaseWindow(int nextStage, ActionListener<Payload> listener) {
        log.trace("Rebasing window...");
        this.checkMissingEvents(() -> this.advance(nextStage, listener), listener);
    }

    public void checkMissingEvents(Runnable next, ActionListener<Payload> listener) {
        Set<Sequence> sequencesToCheck = this.matcher.toCheckForMissing();
        if (sequencesToCheck.isEmpty()) {
            if (this.matcher.limitReached()) {
                this.doPayload(listener);
                return;
            }
            next.run();
        } else {
            Iterator<Sequence> iterator = sequencesToCheck.iterator();
            ArrayList<Sequence> batchToCheck = new ArrayList<Sequence>();
            for (int i = 0; i < 1000 && iterator.hasNext(); ++i) {
                batchToCheck.add(iterator.next());
                iterator.remove();
            }
            List<SearchRequest> queries = this.prepareQueryForMissingEvents(batchToCheck);
            this.client.multiQuery(queries, (ActionListener<MultiSearchResponse>)listener.delegateFailureAndWrap((l, p) -> this.doCheckMissingEvents((List<Sequence>)batchToCheck, (MultiSearchResponse)p, (ActionListener<Payload>)l, next)));
        }
    }

    private void doCheckMissingEvents(List<Sequence> batchToCheck, MultiSearchResponse p, ActionListener<Payload> listener, Runnable next) {
        MultiSearchResponse.Item[] responses;
        for (MultiSearchResponse.Item response : responses = p.getResponses()) {
            SearchHitUtils.addShardFailures(this.shardFailures, response.getResponse());
        }
        int nextResponse = 0;
        for (Sequence sequence : batchToCheck) {
            boolean leading = true;
            boolean discarded = false;
            Timestamp lastLeading = null;
            Timestamp firstTrailing = null;
            for (int i = 0; i < this.criteria.size(); ++i) {
                SequenceCriterion criterion = this.criteria.get(i);
                if (criterion.missing()) {
                    Timestamp hitTimestamp;
                    SearchResponse response = responses[nextResponse++].getResponse();
                    if (discarded) continue;
                    SearchHit[] hits = response.getHits().getHits();
                    if (leading) {
                        if (hits.length == 0) continue;
                        hitTimestamp = criterion.timestamp(hits[0]);
                        lastLeading = lastLeading == null || lastLeading.instant().compareTo(hitTimestamp.instant()) < 0 ? hitTimestamp : lastLeading;
                        continue;
                    }
                    if (this.trailing(i)) {
                        if (hits.length == 0) continue;
                        hitTimestamp = criterion.timestamp(hits[0]);
                        firstTrailing = firstTrailing == null || firstTrailing.instant().compareTo(hitTimestamp.instant()) > 0 ? hitTimestamp : firstTrailing;
                        continue;
                    }
                    if (hits.length <= 0) continue;
                    discarded = true;
                    continue;
                }
                leading = false;
            }
            if (discarded) continue;
            int lastStage = this.criteria.size() - 1;
            if (!(firstTrailing == null && lastLeading == null || lastLeading == null && this.matcher.isMissingEvent(0) || firstTrailing == null && this.matcher.isMissingEvent(lastStage) || this.matcher.isMissingEvent(0) && this.matcher.isMissingEvent(lastStage) && this.biggerThanMaxSpan(lastLeading, firstTrailing) || this.matcher.isMissingEvent(0) && !this.matcher.isMissingEvent(lastStage) && this.biggerThanMaxSpan(lastLeading, sequence.ordinal().timestamp())) && (this.matcher.isMissingEvent(0) || !this.matcher.isMissingEvent(lastStage) || !this.biggerThanMaxSpan(sequence.startOrdinal().timestamp(), firstTrailing))) continue;
            this.matcher.addToCompleted(sequence);
        }
        this.checkMissingEvents(next, listener);
    }

    private boolean biggerThanMaxSpan(Timestamp from, Timestamp to) {
        if (from == null || to == null) {
            return true;
        }
        return this.matcher.exceedsMaxSpan(from, to);
    }

    private List<SearchRequest> prepareQueryForMissingEvents(List<Sequence> toCheck) {
        ArrayList<SearchRequest> result = new ArrayList<SearchRequest>();
        for (Sequence sequence : toCheck) {
            boolean leading = true;
            for (int i = 0; i < this.criteria.size(); ++i) {
                SequenceCriterion criterion = this.criteria.get(i);
                if (criterion.missing()) {
                    BoxedQueryRequest r = criterion.queryRequest();
                    RangeQueryBuilder range = r.timestampRangeQuery();
                    SearchSourceBuilder builder = ExecutionUtils.copySource(r.searchSource());
                    if (leading) {
                        builder.sorts().clear();
                        builder.sort(r.timestampField(), SortOrder.DESC);
                        range.lt((Object)sequence.startOrdinal().timestamp().instant().toEpochMilli());
                    } else if (this.trailing(i)) {
                        builder.sorts().clear();
                        builder.sort(r.timestampField(), SortOrder.ASC);
                        range.gt((Object)sequence.ordinal().timestamp().instant().toEpochMilli());
                    } else {
                        range.lt((Object)sequence.matchAt(this.matcher.nextPositiveStage(i)).ordinal().timestamp().instant().toEpochMilli());
                        range.gt((Object)sequence.matchAt(this.matcher.previousPositiveStage(i)).ordinal().timestamp().instant().toEpochMilli());
                        builder.sort(r.timestampField(), SortOrder.ASC);
                    }
                    this.addKeyFilter(i, sequence, builder);
                    RuntimeUtils.combineFilters(builder, (QueryBuilder)range);
                    result.add(RuntimeUtils.prepareRequest(builder.size(1).trackTotalHits(false), false, this.allowPartialSearchResults, Strings.EMPTY_ARRAY));
                    continue;
                }
                leading = false;
            }
        }
        return result;
    }

    private void addKeyFilter(int stage, Sequence sequence, SearchSourceBuilder builder) {
        List<Attribute> keys = this.listOfKeys.get(stage);
        if (keys.isEmpty()) {
            return;
        }
        for (int i = 0; i < keys.size(); ++i) {
            Attribute k = keys.get(i);
            RuntimeUtils.combineFilters(builder, (QueryBuilder)new TermQueryBuilder(k.qualifiedName(), sequence.key().asList().get(i)));
        }
    }

    private boolean trailing(int i) {
        return this.matcher.nextPositiveStage(i - 1) < 0;
    }

    private void advance(int stage, ActionListener<Payload> listener) {
        SequenceCriterion base = this.criteria.get(stage);
        base.queryRequest().to(null);
        if (this.hasKeys) {
            this.addKeyConstraints(this.matcher.previousPositiveStage(stage), base.queryRequest());
        }
        log.trace("{}", (Object)this.matcher);
        log.trace("Querying base stage [{}] {}", (Object)stage, (Object)base.queryRequest());
        this.client.query(base.queryRequest(), (ActionListener<SearchResponse>)listener.delegateFailureAndWrap((l, p) -> this.baseCriterion(stage, (SearchResponse)p, (ActionListener<Payload>)l)));
    }

    private void baseCriterion(int baseStage, SearchResponse r, ActionListener<Payload> listener) {
        WindowInfo info;
        SearchHitUtils.addShardFailures(this.shardFailures, r);
        SequenceCriterion base = this.criteria.get(baseStage);
        SearchHits hits = r.getHits();
        log.trace("Found [{}] hits", (Object)hits.getHits().length);
        Ordinal begin = null;
        Ordinal end = null;
        if (hits.getHits().length > 0) {
            List<SearchHit> hitsAsList = Arrays.asList(hits.getHits());
            begin = TumblingWindow.headOrdinal(hitsAsList, base);
            end = TumblingWindow.tailOrdinal(hitsAsList, base);
            info = new WindowInfo(baseStage, begin, end);
            log.trace("Found {}base [{}] window {}->{}", (Object)(base.descending() ? "tail " : ""), (Object)base.stage(), (Object)begin, (Object)end);
            base.queryRequest().nextAfter(end);
            if (this.until != null && baseStage > 0) {
                hits.incRef();
                this.untilCriterion(info, listener, () -> {
                    try {
                        this.completeBaseCriterion(baseStage, hits, info, listener);
                    }
                    finally {
                        hits.decRef();
                    }
                });
                return;
            }
        } else {
            info = null;
            if (baseStage == this.matcher.firstPositiveStage && baseStage == this.matcher.lastPositiveStage) {
                this.payload(listener);
                return;
            }
        }
        this.completeBaseCriterion(baseStage, hits, info, listener);
    }

    private void completeBaseCriterion(int baseStage, SearchHits hits, WindowInfo info, ActionListener<Payload> listener) {
        boolean windowCompleted;
        SequenceCriterion base = this.criteria.get(baseStage);
        if (!this.matcher.match(baseStage, this.wrapValues(base, Arrays.asList(hits.getHits())))) {
            this.payload(listener);
            return;
        }
        int nextStage = this.nextPositiveStage(baseStage);
        boolean bl = windowCompleted = hits.getHits().length < this.windowSize;
        if (nextStage > 0) {
            boolean descendingQuery = base.descending();
            Runnable next = null;
            if (info != null) {
                if (descendingQuery) {
                    this.setupWindowFromTail(info.end);
                } else {
                    this.boxQuery(info, this.criteria.get(nextStage));
                }
            }
            if (windowCompleted) {
                boolean shouldTerminate = false;
                if (descendingQuery) {
                    if (info != null) {
                        this.restartWindowFromTailQuery = false;
                        int stage = this.nextPositiveStage(this.matcher.firstPositiveStage);
                        next = () -> this.checkMissingEvents(() -> this.advance(stage, listener), listener);
                    } else {
                        shouldTerminate = true;
                    }
                } else if (this.matcher.hasFollowingCandidates(this.matcher.previousPositiveStage(nextStage))) {
                    next = () -> this.rebaseWindow(nextStage, listener);
                } else if (!this.restartWindowFromTailQuery) {
                    shouldTerminate = true;
                } else {
                    next = () -> this.tumbleWindow(this.matcher.firstPositiveStage, listener);
                }
                if (shouldTerminate) {
                    this.payload(listener);
                    return;
                }
            } else {
                next = descendingQuery ? () -> this.advance(this.nextPositiveStage(this.matcher.firstPositiveStage), listener) : () -> this.secondaryCriterion(info, nextStage, listener);
            }
            if (this.until != null && info != null && info.baseStage == this.matcher.firstPositiveStage) {
                this.untilCriterion(info, listener, next);
            } else {
                next.run();
            }
        } else if (windowCompleted) {
            if (this.restartWindowFromTailQuery) {
                this.tumbleWindow(this.matcher.firstPositiveStage, listener);
            } else {
                this.payload(listener);
            }
        } else {
            this.tumbleWindow(baseStage, listener);
        }
    }

    private int nextPositiveStage(int current) {
        return this.matcher.nextPositiveStage(current);
    }

    private void untilCriterion(WindowInfo window, ActionListener<Payload> listener, Runnable next) {
        BoxedQueryRequest request = this.until.queryRequest();
        this.boxQuery(window, this.until);
        if (request.after().after(window.end)) {
            log.trace("Skipping until stage {}", (Object)request);
            next.run();
            return;
        }
        log.trace("Querying until stage {}", (Object)request);
        this.client.query(request, (ActionListener<SearchResponse>)listener.delegateFailureAndWrap((delegate, r) -> {
            List<SearchHit> hits = Arrays.asList(r.getHits().getHits());
            log.trace("Found [{}] hits", (Object)hits.size());
            if (!hits.isEmpty()) {
                request.nextAfter(TumblingWindow.tailOrdinal(hits, this.until));
                this.matcher.until(this.wrapUntilValues(this.wrapValues(this.until, hits)));
            }
            if (hits.size() == this.windowSize && request.after().before(window.end)) {
                this.untilCriterion(window, (ActionListener<Payload>)delegate, next);
            } else {
                next.run();
            }
        }));
    }

    private void secondaryCriterion(WindowInfo window, int currentStage, ActionListener<Payload> listener) {
        SequenceCriterion criterion = this.criteria.get(currentStage);
        BoxedQueryRequest request = criterion.queryRequest();
        this.boxQuery(window, criterion);
        log.trace("Querying (secondary) stage [{}] {}", (Object)criterion.stage(), (Object)request);
        this.client.query(request, (ActionListener<SearchResponse>)listener.delegateFailureAndWrap((delegate, r) -> {
            List<SearchHit> hits = Arrays.asList(r.getHits().getHits());
            hits = TumblingWindow.trim(hits, criterion, window.end);
            log.trace("Found [{}] hits", (Object)hits.size());
            int nextPositiveStage = this.nextPositiveStage(currentStage);
            if (!hits.isEmpty()) {
                BoxedQueryRequest nextRequest;
                Ordinal tailOrdinal = TumblingWindow.tailOrdinal(hits, criterion);
                Ordinal headOrdinal = TumblingWindow.headOrdinal(hits, criterion);
                log.trace("Found range [{}] -> [{}]", (Object)headOrdinal, (Object)tailOrdinal);
                if (tailOrdinal.after(window.end)) {
                    tailOrdinal = window.end;
                }
                request.nextAfter(tailOrdinal);
                if (!this.matcher.match(criterion.stage(), this.wrapValues(criterion, hits))) {
                    this.payload((ActionListener<Payload>)delegate);
                    return;
                }
                if (nextPositiveStage > 0 && ((nextRequest = this.criteria.get(nextPositiveStage).queryRequest()).from() == null || nextRequest.after() == null)) {
                    nextRequest.from(headOrdinal);
                    nextRequest.nextAfter(headOrdinal);
                }
            }
            if (hits.size() == this.windowSize && request.after().before(window.end)) {
                this.secondaryCriterion(window, currentStage, (ActionListener<Payload>)delegate);
            } else if (nextPositiveStage > 0 && this.matcher.hasFollowingCandidates(criterion.stage())) {
                this.secondaryCriterion(window, nextPositiveStage, (ActionListener<Payload>)delegate);
            } else {
                this.tumbleWindow(window.baseStage, (ActionListener<Payload>)delegate);
            }
        }));
    }

    private static List<SearchHit> trim(List<SearchHit> searchHits, SequenceCriterion criterion, Ordinal boundary) {
        Ordinal ordinal;
        int offset = 0;
        for (int i = searchHits.size() - 1; i >= 0 && (ordinal = criterion.ordinal(searchHits.get(i))).after(boundary); --i) {
            ++offset;
        }
        return offset == 0 ? searchHits : searchHits.subList(0, searchHits.size() - offset);
    }

    private void boxQuery(WindowInfo window, SequenceCriterion criterion) {
        BoxedQueryRequest request = criterion.queryRequest();
        if (!window.end.equals(request.to())) {
            request.to(window.end);
        }
        if (request.from() == null) {
            request.from(window.begin);
            request.nextAfter(window.begin);
        }
        if (this.hasKeys) {
            int stage = criterion == this.until ? Integer.MIN_VALUE : window.baseStage;
            this.addKeyConstraints(stage, request);
        }
    }

    private void setupWindowFromTail(Ordinal from) {
        int secondPositiveStage = this.nextPositiveStage(this.matcher.firstPositiveStage);
        BoxedQueryRequest request = this.criteria.get(secondPositiveStage).queryRequest();
        if (!from.equals(request.from())) {
            request.from(from).nextAfter(from);
            if (this.until != null) {
                this.until.queryRequest().from(from).nextAfter(from);
            }
            for (int i = secondPositiveStage + 1; i < this.maxStages; ++i) {
                BoxedQueryRequest subRequest = this.criteria.get(i).queryRequest();
                subRequest.from(null);
            }
        }
    }

    private void addKeyConstraints(int keyStage, BoxedQueryRequest request) {
        if (keyStage >= 0 || keyStage == Integer.MIN_VALUE) {
            Set<SequenceKey> keys = keyStage == Integer.MIN_VALUE ? this.matcher.keys() : this.matcher.keys(keyStage);
            int size = keys.size();
            if (size > 0) {
                request.keys(keys.stream().map(SequenceKey::asList).collect(Collectors.toList()));
            } else {
                request.keys(null);
            }
        } else {
            request.keys(null);
        }
    }

    private void payload(ActionListener<Payload> listener) {
        this.checkMissingEvents(() -> this.doPayload(listener), listener);
    }

    private void doPayload(ActionListener<Payload> listener) {
        List<Sequence> completed = this.matcher.completed();
        log.trace("Sending payload for [{}] sequences", (Object)completed.size());
        if (completed.isEmpty() || !this.allowPartialSequenceResults && !this.shardFailures.isEmpty()) {
            listener.onResponse((Object)new EmptyPayload(Payload.Type.SEQUENCE, this.timeTook(), this.shardFailures.values().toArray(new ShardSearchFailure[this.shardFailures.size()])));
            return;
        }
        this.client.fetchHits(this.hits(completed), (ActionListener<List<List<SearchHit>>>)ActionListeners.map(listener, listOfHits -> {
            if (this.criteria.get(this.matcher.firstPositiveStage).descending()) {
                Collections.reverse(completed);
            }
            return new SequencePayload(completed, this.addMissingEventPlaceholders((List<List<SearchHit>>)listOfHits), false, this.timeTook(), this.shardFailures.values().toArray(new ShardSearchFailure[0]));
        }));
    }

    private List<List<SearchHit>> addMissingEventPlaceholders(List<List<SearchHit>> hitLists) {
        ArrayList<List<SearchHit>> result = new ArrayList<List<SearchHit>>();
        for (List<SearchHit> hits : hitLists) {
            ArrayList<SearchHit> filled = new ArrayList<SearchHit>();
            result.add(filled);
            int nextHit = 0;
            for (int i = 0; i < this.criteria.size(); ++i) {
                if (this.matcher.isMissingEvent(i)) {
                    filled.add(null);
                    continue;
                }
                filled.add(hits.get(nextHit++));
            }
        }
        return result;
    }

    private TimeValue timeTook() {
        return new TimeValue(System.currentTimeMillis() - this.startTime);
    }

    private String cache(String string) {
        String value = this.stringCache.putIfAbsent(string, string);
        return value == null ? string : value;
    }

    private SequenceKey key(Object[] keys) {
        SequenceKey key;
        if (keys == null) {
            key = SequenceKey.NONE;
        } else {
            for (int i = 0; i < keys.length; ++i) {
                Object o = keys[i];
                if (!(o instanceof String)) continue;
                String s = (String)o;
                keys[i] = this.cache(s);
            }
            key = new SequenceKey(keys);
        }
        return key;
    }

    private static Ordinal headOrdinal(List<SearchHit> hits, SequenceCriterion criterion) {
        return criterion.ordinal(hits.get(0));
    }

    private static Ordinal tailOrdinal(List<SearchHit> hits, SequenceCriterion criterion) {
        return criterion.ordinal(hits.get(hits.size() - 1));
    }

    Iterable<List<HitReference>> hits(List<Sequence> sequences) {
        return () -> {
            final Iterator<Object> delegate = this.criteria.get(this.matcher.firstPositiveStage).descending() ? new ReversedIterator(sequences) : sequences.iterator();
            return new Iterator<List<HitReference>>(this){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public List<HitReference> next() {
                    ArrayList<HitReference> result = new ArrayList<HitReference>();
                    List<HitReference> originalHits = ((Sequence)delegate.next()).hits();
                    for (HitReference hit : originalHits) {
                        if (hit == null) continue;
                        result.add(hit);
                    }
                    return result;
                }
            };
        };
    }

    Iterable<Tuple<KeyAndOrdinal, HitReference>> wrapValues(final SequenceCriterion criterion, List<SearchHit> hits) {
        return () -> {
            final Iterator<Object> delegate = criterion.descending() ? new ReversedIterator(hits) : hits.iterator();
            return new Iterator<Tuple<KeyAndOrdinal, HitReference>>(){
                SearchHit lastFetchedHit;
                List<Object[]> remainingHitJoinKeys;
                {
                    this.lastFetchedHit = delegate.hasNext() ? (SearchHit)delegate.next() : null;
                    this.remainingHitJoinKeys = this.lastFetchedHit == null ? Collections.emptyList() : this.extractJoinKeys(this.lastFetchedHit);
                }

                private List<Object[]> extractJoinKeys(SearchHit hit) {
                    if (hit == null) {
                        return null;
                    }
                    Object[] originalKeys = criterion.key(hit);
                    ArrayList<Object> partial = new ArrayList<Object[]>();
                    if (originalKeys == null) {
                        partial.add(null);
                    } else {
                        int keySize = originalKeys.length;
                        partial.add(new Object[keySize]);
                        for (int i = 0; i < keySize; ++i) {
                            Iterator iterator = originalKeys[i];
                            if (iterator instanceof List) {
                                List possibleValues = (List)((Object)iterator);
                                ArrayList<Object[]> newPartial = new ArrayList<Object[]>(possibleValues.size() * partial.size());
                                for (Object possibleValue : possibleValues) {
                                    for (Object[] objectArray : partial) {
                                        Object[] newKey = new Object[keySize];
                                        if (i > 0) {
                                            System.arraycopy(objectArray, 0, newKey, 0, i);
                                        }
                                        newKey[i] = possibleValue;
                                        newPartial.add(newKey);
                                    }
                                }
                                partial = newPartial;
                                continue;
                            }
                            for (Object[] objectArray : partial) {
                                objectArray[i] = originalKeys[i];
                            }
                        }
                    }
                    return partial;
                }

                @Override
                public boolean hasNext() {
                    return !CollectionUtils.isEmpty(this.remainingHitJoinKeys) || delegate.hasNext();
                }

                @Override
                public Tuple<KeyAndOrdinal, HitReference> next() {
                    if (this.remainingHitJoinKeys.isEmpty()) {
                        this.lastFetchedHit = (SearchHit)delegate.next();
                        this.remainingHitJoinKeys = this.extractJoinKeys(this.lastFetchedHit);
                    }
                    Object[] joinKeys = this.remainingHitJoinKeys.remove(0);
                    SequenceKey k = TumblingWindow.this.key(joinKeys);
                    Ordinal o = criterion.ordinal(this.lastFetchedHit);
                    return new Tuple((Object)new KeyAndOrdinal(k, o), (Object)new HitReference(TumblingWindow.this.cache(SearchHitUtils.qualifiedIndex(this.lastFetchedHit)), this.lastFetchedHit.getId()));
                }
            };
        };
    }

    <E> Iterable<KeyAndOrdinal> wrapUntilValues(Iterable<Tuple<KeyAndOrdinal, E>> iterable) {
        return () -> {
            final Iterator delegate = iterable.iterator();
            return new Iterator<KeyAndOrdinal>(this){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public KeyAndOrdinal next() {
                    return (KeyAndOrdinal)((Tuple)delegate.next()).v1();
                }
            };
        };
    }

    private static class WindowInfo {
        private final int baseStage;
        private final Ordinal begin;
        private final Ordinal end;

        WindowInfo(int baseStage, Ordinal begin, Ordinal end) {
            this.baseStage = baseStage;
            this.begin = begin;
            this.end = end;
        }
    }
}

