/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public final class ExchangeRequest
extends TransportRequest {
    private final String exchangeId;
    private final boolean sourcesFinished;

    public ExchangeRequest(String exchangeId, boolean sourcesFinished) {
        this.exchangeId = exchangeId;
        this.sourcesFinished = sourcesFinished;
    }

    public ExchangeRequest(StreamInput in) throws IOException {
        super(in);
        this.exchangeId = in.readString();
        this.sourcesFinished = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.exchangeId);
        out.writeBoolean(this.sourcesFinished);
    }

    public TaskId getParentTask() {
        if (this.sourcesFinished) {
            return TaskId.EMPTY_TASK_ID;
        }
        return super.getParentTask();
    }

    public boolean sourcesFinished() {
        return this.sourcesFinished;
    }

    public String exchangeId() {
        return this.exchangeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExchangeRequest that = (ExchangeRequest)((Object)o);
        return this.sourcesFinished == that.sourcesFinished && this.exchangeId.equals(that.exchangeId);
    }

    public int hashCode() {
        return Objects.hash(this.exchangeId, this.sourcesFinished);
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        if (!this.sourcesFinished && !parentTaskId.isSet()) {
            assert (false) : "ExchangeRequest with sourcesFinished=false must have a parent task";
            throw new IllegalStateException("ExchangeRequest with sourcesFinished=false must have a parent task");
        }
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            public String getDescription() {
                return "exchange request id=" + ExchangeRequest.this.exchangeId;
            }
        };
    }
}

