/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;

public record ChunkedInferenceEmbeddingByte(List<ByteEmbeddingChunk> chunks) implements ChunkedInference
{
    public Iterator<ChunkedInference.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) throws IOException {
        ArrayList<ChunkedInference.Chunk> asChunk = new ArrayList<ChunkedInference.Chunk>();
        for (ByteEmbeddingChunk chunk : this.chunks) {
            asChunk.add(new ChunkedInference.Chunk(chunk.matchedText(), chunk.offset(), ChunkedInferenceEmbeddingByte.toBytesReference(xcontent, chunk.embedding())));
        }
        return asChunk.iterator();
    }

    private static BytesReference toBytesReference(XContent xContent, byte[] value) throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)xContent);
        builder.startArray();
        for (byte v : value) {
            builder.value(v);
        }
        builder.endArray();
        return BytesReference.bytes((XContentBuilder)builder);
    }

    public record ByteEmbeddingChunk(byte[] embedding, String matchedText, ChunkedInference.TextOffset offset) {
    }
}

