/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.random;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;

public class RandomRankFeaturePhaseRankCoordinatorContext
extends RankFeaturePhaseRankCoordinatorContext {
    private final Integer seed;

    public RandomRankFeaturePhaseRankCoordinatorContext(int size, int from, int rankWindowSize, Integer seed) {
        super(size, from, rankWindowSize);
        this.seed = seed;
    }

    protected void computeScores(RankFeatureDoc[] featureDocs, ActionListener<float[]> scoreListener) {
        float[] scores = new float[featureDocs.length];
        for (int i = 0; i < featureDocs.length; ++i) {
            RankFeatureDoc featureDoc = featureDocs[i];
            int doc = featureDoc.doc;
            long docSeed = this.seed != null ? (long)(this.seed + doc) : (long)doc;
            scores[i] = new Random(docSeed).nextFloat();
        }
        scoreListener.onResponse((Object)scores);
    }

    protected RankFeatureDoc[] preprocess(RankFeatureDoc[] originalDocs) {
        return (RankFeatureDoc[])Arrays.stream(originalDocs).sorted(Comparator.comparing(doc -> Float.valueOf(doc.score)).reversed()).toArray(RankFeatureDoc[]::new);
    }
}

