/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockClientCache;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockExecutor;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.embeddings.AmazonBedrockEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.AmazonBedrockResponseHandler;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.embeddings.AmazonBedrockEmbeddingsResponseListener;

public class AmazonBedrockEmbeddingsExecutor
extends AmazonBedrockExecutor {
    private final AmazonBedrockEmbeddingsRequest embeddingsRequest;

    protected AmazonBedrockEmbeddingsExecutor(AmazonBedrockEmbeddingsRequest request, AmazonBedrockResponseHandler responseHandler, Logger logger, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> inferenceResultsListener, AmazonBedrockClientCache clientCache) {
        super(request, responseHandler, logger, hasRequestCompletedFunction, inferenceResultsListener, clientCache);
        this.embeddingsRequest = request;
    }

    @Override
    protected void executeClientRequest(AmazonBedrockBaseClient awsBedrockClient) {
        AmazonBedrockEmbeddingsResponseListener embeddingsResponseListener = new AmazonBedrockEmbeddingsResponseListener(this.embeddingsRequest, this.responseHandler, (ActionListener<InferenceServiceResults>)this.inferenceResultsListener);
        this.embeddingsRequest.executeEmbeddingsRequest(awsBedrockClient, embeddingsResponseListener);
    }
}

