/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.jinaai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.jinaai.JinaAIActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.JinaAIEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.JinaAIRerankRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.jinaai.rerank.JinaAIRerankModel;

public class JinaAIActionCreator
implements JinaAIActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public JinaAIActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(JinaAIEmbeddingsModel model, Map<String, Object> taskSettings, InputType inputType) {
        JinaAIEmbeddingsModel overriddenModel = JinaAIEmbeddingsModel.of(model, taskSettings, inputType);
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("JinaAI embeddings");
        JinaAIEmbeddingsRequestManager requestCreator = JinaAIEmbeddingsRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        return new SenderExecutableAction(this.sender, requestCreator, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(JinaAIRerankModel model, Map<String, Object> taskSettings) {
        JinaAIRerankModel overriddenModel = JinaAIRerankModel.of(model, taskSettings);
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("JinaAI rerank");
        JinaAIRerankRequestManager requestCreator = JinaAIRerankRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        return new SenderExecutableAction(this.sender, requestCreator, failedToSendRequestErrorMessage);
    }
}

