/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.EvalMapper;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEqualsConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEqualsEvaluator;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.Layout;

public class InsensitiveEqualsMapper
extends ExpressionMapper<InsensitiveEquals> {
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> keywords = InsensitiveEqualsEvaluator.Factory::new;

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory map(FoldContext foldCtx, InsensitiveEquals bc, Layout layout, List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
        DataType leftType = bc.left().dataType();
        DataType rightType = bc.right().dataType();
        EvalOperator.ExpressionEvaluator.Factory leftEval = EvalMapper.toEvaluator(foldCtx, bc.left(), layout, shardContexts);
        EvalOperator.ExpressionEvaluator.Factory rightEval = EvalMapper.toEvaluator(foldCtx, bc.right(), layout, shardContexts);
        if (DataType.isString((DataType)leftType)) {
            if (bc.right().foldable() && DataType.isString((DataType)rightType)) {
                BytesRef rightVal = BytesRefs.toBytesRef((Object)bc.right().fold(FoldContext.small()));
                Automaton automaton = InsensitiveEquals.automaton(rightVal);
                return dvrCtx -> new InsensitiveEqualsConstantEvaluator(bc.source(), leftEval.get(dvrCtx), new ByteRunAutomaton(automaton), dvrCtx);
            }
            return (EvalOperator.ExpressionEvaluator.Factory)this.keywords.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        throw new EsqlIllegalArgumentException("resolved type for [" + String.valueOf(bc) + "] but didn't implement mapping");
    }
}

