/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.execution;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.planner.mapper.Mapper;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.esql.session.IndexResolver;
import org.elasticsearch.xpack.esql.session.QueryBuilderResolver;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.telemetry.Metrics;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetry;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetryManager;
import org.elasticsearch.xpack.esql.telemetry.QueryMetric;

public class PlanExecutor {
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final EsqlFunctionRegistry functionRegistry;
    private final Mapper mapper;
    private final Metrics metrics;
    private final Verifier verifier;
    private final PlanTelemetryManager planTelemetryManager;

    public PlanExecutor(IndexResolver indexResolver, MeterRegistry meterRegistry, XPackLicenseState licenseState) {
        this.indexResolver = indexResolver;
        this.preAnalyzer = new PreAnalyzer();
        this.functionRegistry = new EsqlFunctionRegistry();
        this.mapper = new Mapper();
        this.metrics = new Metrics(this.functionRegistry);
        this.verifier = new Verifier(this.metrics, licenseState);
        this.planTelemetryManager = new PlanTelemetryManager(meterRegistry);
    }

    public void esql(EsqlQueryRequest request, String sessionId, Configuration cfg, FoldContext foldContext, EnrichPolicyResolver enrichPolicyResolver, EsqlExecutionInfo executionInfo, IndicesExpressionGrouper indicesExpressionGrouper, EsqlSession.PlanRunner planRunner, QueryBuilderResolver queryBuilderResolver, ActionListener<Result> listener) {
        PlanTelemetry planTelemetry = new PlanTelemetry(this.functionRegistry);
        EsqlSession session = new EsqlSession(sessionId, cfg, this.indexResolver, enrichPolicyResolver, this.preAnalyzer, this.functionRegistry, new LogicalPlanOptimizer(new LogicalOptimizerContext(cfg, foldContext)), this.mapper, this.verifier, planTelemetry, indicesExpressionGrouper, queryBuilderResolver);
        QueryMetric clientId = QueryMetric.fromString("rest");
        this.metrics.total(clientId);
        ActionListener executeListener = ActionListener.wrap(x -> {
            this.planTelemetryManager.publish(planTelemetry, true);
            listener.onResponse(x);
        }, ex -> {
            this.metrics.failed(clientId);
            this.planTelemetryManager.publish(planTelemetry, false);
            listener.onFailure(ex);
        });
        ActionListener.run((ActionListener)executeListener, l -> session.execute(request, executionInfo, planRunner, (ActionListener<Result>)l));
    }

    public IndexResolver indexResolver() {
        return this.indexResolver;
    }

    public Metrics metrics() {
        return this.metrics;
    }
}

