/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xpack.esql.core.plugin.EsqlCorePlugin;
import org.elasticsearch.xpack.esql.plugin.EsqlFeatures;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;

public class EsqlCapabilities {
    public static final Set<String> CAPABILITIES = EsqlCapabilities.capabilities(false);

    public static Set<String> capabilities(boolean all) {
        ArrayList<String> caps = new ArrayList<String>();
        for (Cap cap : Cap.values()) {
            if (!all && !cap.isEnabled()) continue;
            caps.add(cap.capabilityName());
        }
        for (NodeFeature feature : new EsqlFeatures().getFeatures()) {
            caps.add(EsqlCapabilities.cap(feature));
        }
        return Set.copyOf(caps);
    }

    public static String cap(NodeFeature feature) {
        assert (feature.id().startsWith("esql."));
        return feature.id().substring("esql.".length());
    }

    public static enum Cap {
        MV_SORT,
        DISABLE_NULLABLE_OPTS,
        ST_X_Y,
        SPATIAL_POINTS_FROM_SOURCE,
        SPATIAL_SHAPES,
        GEO_VALIDATION,
        ST_CENTROID_AGG,
        ST_INTERSECTS,
        ST_CONTAINS_WITHIN,
        ST_DISJOINT,
        AGG_VALUES,
        AGG_VALUES_SPATIAL,
        ASYNC_QUERY,
        FROM_OPTIONS,
        STRING_LITERAL_AUTO_CASTING,
        BASE64_DECODE_ENCODE,
        CASTING_OPERATOR,
        MV_ORDERING_SORTED_ASCENDING,
        METRICS_COUNTER_FIELDS,
        STRING_LITERAL_AUTO_CASTING_EXTENDED,
        METADATA_FIELDS,
        INDEX_METADATA_FIELD,
        TIMESPAN_ABBREVIATIONS,
        COUNTER_TYPES,
        FN_BIT_LENGTH,
        FN_BYTE_LENGTH,
        FN_REVERSE,
        FN_REVERSE_GRAPHEME_CLUSTERS,
        FN_CBRT,
        FN_HYPOT,
        FN_MV_APPEND,
        FN_MV_MEDIAN_ABSOLUTE_DEVIATION,
        FN_MV_PERCENTILE,
        FN_IP_PREFIX,
        FN_SUBSTRING_EMPTY_NULL,
        FN_ROUND_UL_FIXES,
        FUNCTIONS_NEVER_EMIT_TEXT,
        INLINESTATS(EsqlPlugin.INLINESTATS_FEATURE_FLAG),
        INLINESTATS_V2(EsqlPlugin.INLINESTATS_FEATURE_FLAG),
        AGG_TOP,
        AGG_MAX_MIN_BOOLEAN_SUPPORT,
        AGG_MAX_MIN_IP_SUPPORT,
        AGG_MAX_MIN_STRING_SUPPORT,
        AGG_TOP_BOOLEAN_SUPPORT,
        AGG_TOP_IP_SUPPORT,
        AGG_TOP_STRING_SUPPORT,
        CASE_MV,
        ENRICH_LOAD,
        ST_CENTROID_AGG_OPTIMIZED,
        METADATA_IGNORED_FIELD,
        LOOKUP_V4(Build.current().isSnapshot()),
        REPEAT,
        STRING_LITERAL_AUTO_CASTING_TO_DATETIME_ADD_SUB,
        NAMED_POSITIONAL_PARAMETER,
        UNION_TYPES,
        UNMAPPED_FIELDS(Build.current().isSnapshot()),
        ST_DISTANCE,
        ST_EXTENT_AGG,
        ST_EXTENT_AGG_DOCVALUES,
        SPATIAL_FUNCTIONS_FIX_CRSTYPE_FOLDING,
        SPATIAL_PREDICATES_SUPPORT_MULTIVALUES,
        SPATIAL_DISTANCE_SUPPORTS_MULTIVALUES,
        SPATIAL_DISTANCE_PUSHDOWN_ENHANCEMENTS,
        SPATIAL_CENTROID_NO_RECORDS,
        ST_ENVELOPE,
        GROK_DISSECT_MASKING,
        DOUBLE_QUOTES_SOURCE_ENCLOSING,
        AGG_WEIGHTED_AVG,
        UNION_TYPES_AGG_CAST,
        FIX_COUNT_PUSHDOWN_FOR_UNION_TYPES,
        GROK_VALIDATION,
        UNION_TYPES_INLINE_FIX,
        UNION_TYPES_REMOVE_FIELDS,
        UNION_TYPES_FIX_RENAME_RESOLUTION,
        RENAME_SEQUENTIAL_PROCESSING,
        UNION_TYPES_MISSING_FIELD,
        UNION_TYPES_NUMERIC_WIDENING,
        FIX_PARSING_LARGE_NEGATIVE_NUMBERS,
        FIX_COUNT_DISTINCT_SOURCE_ERROR,
        RANGEQUERY_FOR_DATETIME,
        ENRICH_STRICT_RANGE_TYPES,
        UNIQUE_NAMES,
        FIXED_PUSHDOWN_PAST_PROJECT,
        MV_PSERIES_WEIGHTED_SUM,
        MATCH_OPERATOR_COLON,
        NO_META,
        COMBINE_BINARY_COMPARISONS,
        DATE_NANOS_TYPE,
        TO_DATE_NANOS,
        DATE_NANOS_BINARY_COMPARISON,
        DATE_NANOS_COMPARE_TO_MILLIS,
        DATE_NANOS_IMPLICIT_CASTING,
        LEAST_GREATEST_FOR_DATENANOS,
        DATE_NANOS_DATE_EXTRACT,
        DATE_NANOS_ADD_SUBTRACT,
        DATE_TRUNC_DATE_NANOS,
        DATE_NANOS_BUCKET,
        DATE_NANOS_AGGREGATIONS,
        DATE_NANOS_IN_OPERATOR,
        DATE_NANOS_DATE_FORMAT,
        DATE_NANOS_DATE_DIFF,
        FIX_DATE_NANOS_LUCENE_PUSHDOWN_BUG,
        FIX_DATE_NANOS_MIXED_RANGE_PUSHDOWN_BUG,
        DATE_NANOS_LOOKUP_JOIN,
        DATE_PARSE_TZ,
        LEAST_GREATEST_FOR_DATES,
        COMBINE_DISJUNCTIVE_CIDRMATCHES,
        ASYNC_QUERY_STATUS_HEADERS,
        BUCKET_INCLUSIVE_UPPER_BOUND,
        SHORT_ERROR_MESSAGES_FOR_UNSUPPORTED_FIELDS,
        BUCKET_WHOLE_NUMBER_AS_SPAN,
        MIXED_NUMERIC_TYPES_IN_COALESCE,
        SPACE,
        CAST_STRING_LITERAL_TO_TEMPORAL_AMOUNT,
        CATEGORIZE_V5,
        CATEGORIZE_MULTIPLE_GROUPINGS,
        QSTR_FUNCTION,
        MATCH_FUNCTION,
        KQL_FUNCTION,
        HASH_FUNCTION,
        HASH_FUNCTION_ALIASES_V1,
        FIXED_WRONG_IS_NOT_NULL_CHECK_ON_CASE,
        DATE_DIFF_YEAR_CALENDARIAL,
        SORTING_ON_SOURCE_AND_COUNTERS_FORBIDDEN,
        SORT_RETURNING_SOURCE_OK,
        SOURCE_FIELD_MAPPING,
        PER_AGG_FILTERING,
        PER_AGG_FILTERING_ORDS,
        STD_DEV,
        FIX_STATS_BY_FOLDABLE_EXPRESSION,
        FUNCTION_STATS,
        SEMANTIC_TEXT_TYPE(EsqlCorePlugin.SEMANTIC_TEXT_FEATURE_FLAG),
        FIX_FILTER_PUSHDOWN_PAST_STATS,
        STATS_ALIAS_COLLISION_WARNINGS,
        SNAPSHOT_TEST_FOR_TELEMETRY(Build.current().isSnapshot()),
        NON_SNAPSHOT_TEST_FOR_TELEMETRY(!Build.current().isSnapshot()),
        NAMED_PARAMETER_FOR_FIELD_AND_FUNCTION_NAMES_SIMPLIFIED_SYNTAX,
        ADD_LIMIT_INSIDE_MV_EXPAND,
        DELAY_DEBUG_FN(Build.current().isSnapshot()),
        METADATA_FIELDS_REMOTE_TEST(false),
        JOIN_PLANNING_V1(Build.current().isSnapshot()),
        IMPLICIT_CASTING_STRING_LITERAL_TO_TEMPORAL_AMOUNT,
        JOIN_LOOKUP_V12,
        LOOKUP_JOIN_TEXT(JOIN_LOOKUP_V12.isEnabled()),
        JOIN_LOOKUP_SKIP_MV(JOIN_LOOKUP_V12.isEnabled()),
        JOIN_LOOKUP_SKIP_MV_ON_LOOKUP_KEY(JOIN_LOOKUP_V12.isEnabled()),
        JOIN_LOOKUP_FIX_LIMIT_PUSHDOWN(JOIN_LOOKUP_V12.isEnabled()),
        FIX_NESTED_FIELDS_NAME_CLASH_IN_INDEXRESOLVER,
        SEMANTIC_TEXT_AGGREGATIONS(EsqlCorePlugin.SEMANTIC_TEXT_FEATURE_FLAG),
        FIX_STATS_BY_FOLDABLE_EXPRESSION_2,
        METADATA_SCORE,
        TERM_FUNCTION(Build.current().isSnapshot()),
        MATCH_ADDITIONAL_TYPES,
        FIXED_REGEX_FOLD,
        FULL_TEXT_FUNCTIONS_DISJUNCTIONS,
        SEMANTIC_TEXT_FIELD_CAPS,
        OPTIONAL_NAMED_ARGUMENT_MAP_FOR_FUNCTION(Build.current().isSnapshot()),
        LOOKUP_JOIN_NO_ALIASES(JOIN_LOOKUP_V12.isEnabled()),
        FULL_TEXT_FUNCTIONS_DISJUNCTIONS_COMPUTE_ENGINE,
        MATCH_FUNCTION_OPTIONS,
        QUERY_STRING_FUNCTION_OPTIONS,
        AGGREGATE_METRIC_DOUBLE(EsqlCorePlugin.AGGREGATE_METRIC_DOUBLE_FEATURE_FLAG.isEnabled()),
        REMOVE_REDUNDANT_SORT,
        INLINESTATS_V7(EsqlPlugin.INLINESTATS_FEATURE_FLAG),
        MIXED_NUMERIC_TYPES_IN_CASE_GREATEST_LEAST,
        STARTS_WITH_ENDS_WITH_LUCENE_PUSHDOWN,
        FULL_TEXT_FUNCTIONS_DISJUNCTIONS_SCORE,
        NON_FULL_TEXT_FUNCTIONS_SCORING,
        MAKE_NUMBER_OF_CHANNELS_CONSISTENT_WITH_LAYOUT,
        FIX_REPLACE_MISSING_FIELD_WITH_NULL_DUPLICATE_NAME_ID_IN_LAYOUT,
        FIX_DOUBLY_RELEASED_NULL_BLOCKS_IN_VALUESOURCEREADER,
        FIX_JOIN_MASKING_EVAL,
        DROP_AGAIN_WITH_WILDCARD_AFTER_EVAL,
        FIX_JOIN_MASKING_REGEX_EXTRACT,
        KEEP_REGEX_EXTRACT_ATTRIBUTES,
        TO_LOWER_EMPTY_STRING;

        private final boolean enabled;

        private Cap() {
            this.enabled = true;
        }

        private Cap(boolean enabled) {
            this.enabled = enabled;
        }

        private Cap(FeatureFlag featureFlag) {
            this.enabled = featureFlag.isEnabled();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String capabilityName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

