/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots.sourceonly;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.repositories.FilterRepository;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.SnapshotIndexCommit;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.sourceonly.SeqIdGeneratingFilterReader;
import org.elasticsearch.snapshots.sourceonly.SourceOnlySnapshot;

public final class SourceOnlySnapshotRepository
extends FilterRepository {
    private static final Setting<String> DELEGATE_TYPE = Setting.simpleString((String)"delegate_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SOURCE_ONLY = Setting.boolSetting((String)"index.source_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Final, Setting.Property.PrivateIndex});
    private static final Logger logger = LogManager.getLogger(SourceOnlySnapshotRepository.class);
    private static final String SNAPSHOT_DIR_NAME = "_snapshot";

    SourceOnlySnapshotRepository(Repository in) {
        super(in);
    }

    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        super.finalizeSnapshot(new FinalizeSnapshotContext(finalizeSnapshotContext.updatedShardGenerations(), finalizeSnapshotContext.repositoryStateId(), SourceOnlySnapshotRepository.metadataToSnapshot(finalizeSnapshotContext.updatedShardGenerations().liveIndices().indices(), finalizeSnapshotContext.clusterMetadata()), finalizeSnapshotContext.snapshotInfo(), finalizeSnapshotContext.repositoryMetaVersion(), (ActionListener)finalizeSnapshotContext, arg_0 -> ((FinalizeSnapshotContext)finalizeSnapshotContext).onDone(arg_0)));
    }

    private static Metadata metadataToSnapshot(Collection<IndexId> indices, Metadata metadata) {
        Metadata.Builder builder = Metadata.builder((Metadata)metadata);
        for (IndexId indexId : indices) {
            IndexMetadata index = metadata.index(indexId.getName());
            IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder((IndexMetadata)index);
            MappingMetadata mmd = index.mapping();
            if (mmd != null) {
                String mapping = "{ \"_doc\" : { \"enabled\": false, \"_meta\": " + mmd.source().string() + " } }";
                indexMetadataBuilder.putMapping(mapping);
            }
            indexMetadataBuilder.settings(Settings.builder().put(index.getSettings()).put(SOURCE_ONLY.getKey(), true).put("index.blocks.write", true));
            indexMetadataBuilder.settingsVersion(1L + indexMetadataBuilder.settingsVersion());
            builder.put(indexMetadataBuilder);
        }
        return builder.build();
    }

    public void snapshotShard(SnapshotShardContext context) {
        MapperService mapperService = context.mapperService();
        if (mapperService.documentMapper() != null && !mapperService.documentMapper().sourceMapper().isComplete() || mapperService.documentMapper() == null && !SourceFieldMapper.isStored((IndexSettings)mapperService.getIndexSettings())) {
            context.onFailure((Exception)new IllegalStateException("Can't snapshot _source only on an index that has incomplete source ie. has _source disabled or filters the source"));
            return;
        }
        Store store = context.store();
        Directory unwrap = FilterDirectory.unwrap((Directory)store.directory());
        if (!(unwrap instanceof FSDirectory)) {
            context.onFailure((Exception)new IllegalStateException(String.valueOf(context.indexCommit()) + " is not a regular index, but [" + unwrap.toString() + "]  and cannot be snapshotted into a source-only repository"));
            return;
        }
        Path dataPath = ((FSDirectory)unwrap).getDirectory().getParent();
        Path snapPath = dataPath.resolve(SNAPSHOT_DIR_NAME);
        ArrayList<Object> toClose = new ArrayList<Object>(3);
        try {
            SourceOnlySnapshot.LinkedFilesDirectory overlayDir = new SourceOnlySnapshot.LinkedFilesDirectory((Directory)new NIOFSDirectory(snapPath));
            toClose.add((Object)overlayDir);
            Store tempStore = new Store(store.shardId(), store.indexSettings(), (Directory)overlayDir, new ShardLock(this, store.shardId()){

                protected void closeInternal() {
                }
            }, Store.OnClose.EMPTY, mapperService.getIndexSettings().getIndexSortConfig().hasIndexSort());
            Supplier<Query> querySupplier = mapperService.hasNested() ? () -> Queries.newNestedFilter((IndexVersion)mapperService.getIndexSettings().getIndexVersionCreated()) : null;
            SourceOnlySnapshot snapshot = new SourceOnlySnapshot(overlayDir, querySupplier);
            IndexCommit snapshotIndexCommit = context.indexCommit();
            try {
                snapshot.syncSnapshot(snapshotIndexCommit);
            }
            catch (FileAlreadyExistsException | NoSuchFileException | CorruptIndexException e) {
                logger.warn(() -> Strings.format((String)"Existing staging directory [%s] appears corrupted and will be pruned and recreated.", (Object[])new Object[]{snapPath}), e);
                Lucene.cleanLuceneIndex((Directory)overlayDir);
                snapshot.syncSnapshot(snapshotIndexCommit);
            }
            SegmentInfos segmentInfos = tempStore.readLastCommittedSegmentsInfo();
            long maxDoc = segmentInfos.totalMaxDoc();
            tempStore.bootstrapNewHistory(maxDoc, maxDoc);
            try (Releasable ignored = context.withCommitRef();){
                store.incRef();
                toClose.add(() -> ((Store)store).decRef());
            }
            DirectoryReader reader = DirectoryReader.open((Directory)tempStore.directory());
            toClose.add(reader);
            IndexCommit indexCommit = reader.getIndexCommit();
            super.snapshotShard(new SnapshotShardContext(tempStore, mapperService, context.snapshotId(), context.indexId(), new SnapshotIndexCommit(new Engine.IndexCommitRef(indexCommit, () -> IOUtils.close((Iterable)toClose))), context.stateIdentifier(), context.status(), context.getRepositoryMetaVersion(), context.snapshotStartTime(), (ActionListener)context));
        }
        catch (Exception e) {
            try {
                IOUtils.close(toClose);
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            context.onFailure(e);
        }
    }

    public static EngineFactory getEngineFactory() {
        return config -> new ReadOnlyEngine(config, null, new TranslogStats(0, 0L, 0, 0L, 0L), true, SourceOnlySnapshotRepository.readerWrapper(config), true, false);
    }

    public static Function<DirectoryReader, DirectoryReader> readerWrapper(EngineConfig engineConfig) {
        return reader -> {
            try {
                return SeqIdGeneratingFilterReader.wrap(reader, engineConfig.getPrimaryTermSupplier().getAsLong());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static Repository.Factory newRepositoryFactory() {
        return new Repository.Factory(){

            public Repository create(RepositoryMetadata metadata) {
                throw new UnsupportedOperationException();
            }

            public Repository create(RepositoryMetadata metadata, Function<String, Repository.Factory> typeLookup) throws Exception {
                String delegateType = (String)DELEGATE_TYPE.get(metadata.settings());
                if (!org.elasticsearch.common.Strings.hasLength((String)delegateType)) {
                    throw new IllegalArgumentException(DELEGATE_TYPE.getKey() + " must be set");
                }
                Repository.Factory factory = typeLookup.apply(delegateType);
                return new SourceOnlySnapshotRepository(factory.create(new RepositoryMetadata(metadata.name(), delegateType, metadata.settings()), typeLookup));
            }
        };
    }
}

