/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CheckAllocator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(CheckAllocator.class);
    private static final @UnknownKeyFor @NonNull @Initialized String ALLOCATOR_PATH_CORE = "org/apache/arrow/memory/DefaultAllocationManagerFactory.class";
    private static final @UnknownKeyFor @NonNull @Initialized String ALLOCATOR_PATH_UNSAFE = "org/apache/arrow/memory/unsafe/DefaultAllocationManagerFactory.class";
    private static final @UnknownKeyFor @NonNull @Initialized String ALLOCATOR_PATH_NETTY = "org/apache/arrow/memory/netty/DefaultAllocationManagerFactory.class";

    private CheckAllocator() {
    }

    static @UnknownKeyFor @NonNull @Initialized String check() {
        Set<URL> urls = CheckAllocator.scanClasspath();
        URL rootAllocator = CheckAllocator.assertOnlyOne(urls);
        CheckAllocator.reportResult(rootAllocator);
        if (rootAllocator.getPath().contains("memory-core") || rootAllocator.getPath().contains("/org/apache/arrow/memory/core/")) {
            return "org.apache.arrow.memory.DefaultAllocationManagerFactory";
        }
        if (rootAllocator.getPath().contains("memory-unsafe") || rootAllocator.getPath().contains("/org/apache/arrow/memory/unsafe/")) {
            return "org.apache.arrow.memory.unsafe.DefaultAllocationManagerFactory";
        }
        if (rootAllocator.getPath().contains("memory-netty") || rootAllocator.getPath().contains("/org/apache/arrow/memory/netty/")) {
            return "org.apache.arrow.memory.netty.DefaultAllocationManagerFactory";
        }
        throw new IllegalStateException("Unknown allocation manager type to infer. Current: " + rootAllocator.getPath());
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized URL> scanClasspath() {
        LinkedHashSet<URL> allocatorPathSet = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> paths;
            ClassLoader allocatorClassLoader = CheckAllocator.class.getClassLoader();
            if (allocatorClassLoader == null) {
                paths = ClassLoader.getSystemResources(ALLOCATOR_PATH_CORE);
                if (!paths.hasMoreElements()) {
                    paths = ClassLoader.getSystemResources(ALLOCATOR_PATH_UNSAFE);
                }
                if (!paths.hasMoreElements()) {
                    paths = ClassLoader.getSystemResources(ALLOCATOR_PATH_NETTY);
                }
            } else {
                paths = allocatorClassLoader.getResources(ALLOCATOR_PATH_CORE);
                if (!paths.hasMoreElements()) {
                    paths = allocatorClassLoader.getResources(ALLOCATOR_PATH_UNSAFE);
                }
                if (!paths.hasMoreElements()) {
                    paths = allocatorClassLoader.getResources(ALLOCATOR_PATH_NETTY);
                }
            }
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                allocatorPathSet.add(path);
            }
        }
        catch (IOException ioe) {
            logger.error("Error getting resources from path", (Throwable)ioe);
        }
        return allocatorPathSet;
    }

    private static void reportResult(@UnknownKeyFor @NonNull @Initialized URL rootAllocator) {
        String path = rootAllocator.getPath();
        String subPath = path.substring(path.indexOf("memory"));
        logger.info("Using DefaultAllocationManager at {}", (Object)subPath);
    }

    private static @UnknownKeyFor @NonNull @Initialized URL assertOnlyOne(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized URL> urls) {
        if (urls.size() > 1) {
            logger.warn("More than one DefaultAllocationManager on classpath. Choosing first found");
        }
        if (urls.isEmpty()) {
            throw new RuntimeException("No DefaultAllocationManager found on classpath. Can't allocate Arrow buffers. Please consider adding arrow-memory-netty or arrow-memory-unsafe as a dependency.");
        }
        return urls.iterator().next();
    }
}

