/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesBytesRefAggregator {
    ValuesBytesRefAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, BytesRef v) {
        state.values.add(v);
    }

    public static void combineIntermediate(SingleState state, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesBytesRefAggregator.combine(state, values.getBytesRef(i, scratch));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, BytesRef v) {
        state.values.add((long)groupId, BlockHash.hashOrdToGroup(state.bytes.add(v)));
    }

    public static void combineIntermediate(GroupingState state, int groupId, BytesRefBlock values, int valuesPosition) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesBytesRefAggregator.combine(state, groupId, values.getBytesRef(i, scratch));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        BytesRef scratch = new BytesRef();
        int id = 0;
        while ((long)id < state.values.size()) {
            if (state.values.getKey1((long)id) == (long)statePosition) {
                long value = state.values.getKey2((long)id);
                ValuesBytesRefAggregator.combine(current, currentGroupId, state.bytes.get(value, scratch));
            }
            ++id;
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private final BytesRefHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new BytesRefHash(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            BytesRef scratch = new BytesRef();
            if (this.values.size() == 1L) {
                return blockFactory.newConstantBytesRefBlockWith(BytesRef.deepCopyOf((BytesRef)this.values.get(0L, scratch)), 1);
            }
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendBytesRef(this.values.get((long)id, scratch));
                    ++id;
                }
                builder.endPositionEntry();
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final LongLongHash values;
        private final BytesRefHash bytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GroupingState(BigArrays bigArrays) {
            LongLongHash _values = null;
            BytesRefHash _bytes = null;
            try {
                _values = new LongLongHash(1L, bigArrays);
                _bytes = new BytesRefHash(1L, bigArrays);
                this.values = _values;
                this.bytes = _bytes;
                _values = null;
                _bytes = null;
            }
            catch (Throwable throwable) {
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{_values, _bytes});
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{_values, _bytes});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            long selectedCountsSize = 0L;
            long idsSize = 0L;
            try {
                BytesRefBlock bytesRefBlock;
                block21: {
                    int selectedCountsLen = selected.max() + 1;
                    long adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + selectedCountsLen * 4));
                    blockFactory.adjustBreaker(adjust);
                    selectedCountsSize = adjust;
                    int[] selectedCounts = new int[selectedCountsLen];
                    int id = 0;
                    while ((long)id < this.values.size()) {
                        int group = (int)this.values.getKey1((long)id);
                        if (group < selectedCounts.length) {
                            int n = group;
                            selectedCounts[n] = selectedCounts[n] - 1;
                        }
                        ++id;
                    }
                    int total = 0;
                    for (int s = 0; s < selected.getPositionCount(); ++s) {
                        int group = selected.getInt(s);
                        int count = -selectedCounts[group];
                        selectedCounts[group] = total;
                        total += count;
                    }
                    adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + total * 4));
                    blockFactory.adjustBreaker(adjust);
                    idsSize = adjust;
                    int[] ids = new int[total];
                    int id2 = 0;
                    while ((long)id2 < this.values.size()) {
                        int group = (int)this.values.getKey1((long)id2);
                        if (group < selectedCounts.length && selectedCounts[group] >= 0) {
                            int n = group;
                            int n2 = selectedCounts[n];
                            selectedCounts[n] = n2 + 1;
                            ids[n2] = id2;
                        }
                        ++id2;
                    }
                    BytesRef scratch = new BytesRef();
                    BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());
                    try {
                        int start = 0;
                        for (int s = 0; s < selected.getPositionCount(); ++s) {
                            int group = selected.getInt(s);
                            int end = selectedCounts[group];
                            int count = end - start;
                            switch (count) {
                                case 0: {
                                    builder.appendNull();
                                    break;
                                }
                                case 1: {
                                    this.append(builder, ids[start], scratch);
                                    break;
                                }
                                default: {
                                    builder.beginPositionEntry();
                                    for (int i = start; i < end; ++i) {
                                        this.append(builder, ids[i], scratch);
                                    }
                                    builder.endPositionEntry();
                                }
                            }
                            start = end;
                        }
                        bytesRefBlock = builder.build();
                        if (builder == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    builder.close();
                }
                return bytesRefBlock;
            }
            finally {
                blockFactory.adjustBreaker(-selectedCountsSize - idsSize);
            }
        }

        private void append(BytesRefBlock.Builder builder, int id, BytesRef scratch) {
            BytesRef value = this.bytes.get(this.values.getKey2((long)id), scratch);
            builder.appendBytesRef(value);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.values, this.bytes});
        }
    }
}

