/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.CountDistinctFloatAggregator;
import org.elasticsearch.compute.aggregation.HllStates;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class CountDistinctFloatAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("hll", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final HllStates.SingleState state;
    private final List<Integer> channels;
    private final int precision;

    public CountDistinctFloatAggregatorFunction(DriverContext driverContext, List<Integer> channels, HllStates.SingleState state, int precision) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.precision = precision;
    }

    public static CountDistinctFloatAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int precision) {
        return new CountDistinctFloatAggregatorFunction(driverContext, channels, CountDistinctFloatAggregator.initSingle(driverContext.bigArrays(), precision), precision);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            FloatBlock block = (FloatBlock)page.getBlock(this.channels.get(0));
            FloatVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        FloatBlock block = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(FloatVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            CountDistinctFloatAggregator.combine(this.state, vector.getFloat(i));
        }
    }

    private void addRawVector(FloatVector vector, BooleanVector mask) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            CountDistinctFloatAggregator.combine(this.state, vector.getFloat(i));
        }
    }

    private void addRawBlock(FloatBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                CountDistinctFloatAggregator.combine(this.state, block.getFloat(i));
            }
        }
    }

    private void addRawBlock(FloatBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                CountDistinctFloatAggregator.combine(this.state, block.getFloat(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + CountDistinctFloatAggregatorFunction.intermediateStateDesc().size());
        Object hllUncast = page.getBlock(this.channels.get(0));
        if (hllUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector hll = ((BytesRefBlock)hllUncast).asVector();
        assert (hll.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        CountDistinctFloatAggregator.combineIntermediate(this.state, hll.getBytesRef(0, scratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = CountDistinctFloatAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

