/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosAuthenticationToken;

public final class TransportCreateTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private static final String DEFAULT_SCOPE = "full";
    private final ThreadPool threadPool;
    private final TokenService tokenService;
    private final AuthenticationService authenticationService;
    private final SecurityContext securityContext;

    @Inject
    public TransportCreateTokenAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, TokenService tokenService, AuthenticationService authenticationService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/token/create", transportService, actionFilters, CreateTokenRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.tokenService = tokenService;
        this.authenticationService = authenticationService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        CreateTokenRequest.GrantType type = CreateTokenRequest.GrantType.fromString((String)request.getGrantType());
        assert (type != null) : "type should have been validated in the action";
        switch (type) {
            case PASSWORD: 
            case KERBEROS: {
                this.authenticateAndCreateToken(type, request, listener);
                break;
            }
            case CLIENT_CREDENTIALS: {
                Authentication authentication = this.securityContext.getAuthentication();
                if (authentication.isServiceAccount()) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("OAuth2 token creation is not supported for service accounts", new Object[0])));
                    return;
                }
                this.createToken(type, request, authentication, authentication, false, listener);
                break;
            }
            default: {
                listener.onFailure((Exception)new IllegalStateException("grant_type [" + request.getGrantType() + "] is not supported by the create token action"));
            }
        }
    }

    private void authenticateAndCreateToken(CreateTokenRequest.GrantType grantType, CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        Authentication originatingAuthentication = this.securityContext.getAuthentication();
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            Tuple<AuthenticationToken, Optional<Exception>> tokenAndException = TransportCreateTokenAction.extractAuthenticationToken(grantType, request);
            if (((Optional)tokenAndException.v2()).isPresent()) {
                listener.onFailure((Exception)((Optional)tokenAndException.v2()).get());
                return;
            }
            AuthenticationToken authToken = (AuthenticationToken)tokenAndException.v1();
            if (authToken == null) {
                listener.onFailure((Exception)new IllegalStateException("grant_type [" + request.getGrantType() + "] is not supported by the create token action"));
                return;
            }
            this.authenticationService.authenticate("cluster:admin/xpack/security/token/create", (TransportRequest)request, authToken, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                TransportCreateTokenAction.clearCredentialsFromRequest(grantType, request);
                if (authentication != null) {
                    this.createToken(grantType, request, (Authentication)authentication, originatingAuthentication, true, listener);
                } else {
                    listener.onFailure((Exception)new UnsupportedOperationException("cannot create token if authentication is not allowed"));
                }
            }, e -> {
                TransportCreateTokenAction.clearCredentialsFromRequest(grantType, request);
                listener.onFailure(e);
            }));
        }
    }

    private static Tuple<AuthenticationToken, Optional<Exception>> extractAuthenticationToken(CreateTokenRequest.GrantType grantType, CreateTokenRequest request) {
        Object authToken = null;
        if (grantType == CreateTokenRequest.GrantType.PASSWORD) {
            authToken = new UsernamePasswordToken(request.getUsername(), request.getPassword());
        } else if (grantType == CreateTokenRequest.GrantType.KERBEROS) {
            byte[] decodedKerberosTicket;
            SecureString kerberosTicket = request.getKerberosTicket();
            String base64EncodedToken = kerberosTicket.toString();
            try {
                decodedKerberosTicket = Base64.getDecoder().decode(base64EncodedToken);
            }
            catch (IllegalArgumentException iae) {
                return new Tuple(null, Optional.of(new UnsupportedOperationException("could not decode base64 kerberos ticket " + base64EncodedToken, iae)));
            }
            authToken = new KerberosAuthenticationToken(decodedKerberosTicket);
        }
        return new Tuple(authToken, Optional.empty());
    }

    private static void clearCredentialsFromRequest(CreateTokenRequest.GrantType grantType, CreateTokenRequest request) {
        if (grantType == CreateTokenRequest.GrantType.PASSWORD) {
            request.getPassword().close();
        } else if (grantType == CreateTokenRequest.GrantType.KERBEROS) {
            request.getKerberosTicket().close();
        }
    }

    private void createToken(CreateTokenRequest.GrantType grantType, CreateTokenRequest request, Authentication authentication, Authentication originatingAuth, boolean includeRefreshToken, ActionListener<CreateTokenResponse> listener) {
        this.tokenService.createOAuth2Tokens(authentication, originatingAuth, Collections.emptyMap(), includeRefreshToken, (ActionListener<TokenService.CreateTokenResult>)ActionListener.wrap(tokenResult -> {
            String scope = TransportCreateTokenAction.getResponseScopeValue(request.getScope());
            String base64AuthenticateResponse = grantType == CreateTokenRequest.GrantType.KERBEROS ? this.extractOutToken() : null;
            CreateTokenResponse response = new CreateTokenResponse(tokenResult.getAccessToken(), this.tokenService.getExpirationDelay(), scope, tokenResult.getRefreshToken(), base64AuthenticateResponse, authentication);
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private String extractOutToken() {
        String wwwAuthenticateHeaderValue;
        List values = (List)this.threadPool.getThreadContext().getResponseHeaders().get("WWW-Authenticate");
        if (values != null && values.size() == 1 && (wwwAuthenticateHeaderValue = (String)values.get(0)).startsWith("Negotiate ")) {
            String base64EncodedToken = wwwAuthenticateHeaderValue.substring("Negotiate ".length()).trim();
            return base64EncodedToken;
        }
        this.threadPool.getThreadContext().getResponseHeaders().remove("WWW-Authenticate");
        return null;
    }

    static String getResponseScopeValue(String requestScope) {
        String scope = requestScope != null ? DEFAULT_SCOPE : null;
        return scope;
    }
}

