/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.support.FilterBlobContainer;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class BlobContainerSupplier
implements Supplier<BlobContainer> {
    private static final Logger logger = LogManager.getLogger(BlobContainerSupplier.class);
    private final Supplier<BlobStoreRepository> repositorySupplier;
    private final IndexId indexId;
    private final int shardId;
    private volatile LastKnownState lastKnownState = new LastKnownState(null, null);

    public BlobContainerSupplier(Supplier<BlobStoreRepository> repositorySupplier, IndexId indexId, int shardId) {
        this.repositorySupplier = repositorySupplier;
        this.indexId = indexId;
        this.shardId = shardId;
    }

    @Override
    public BlobContainer get() {
        LastKnownState lastKnownState = this.lastKnownState;
        BlobStoreRepository currentRepository = this.repositorySupplier.get();
        if (lastKnownState.blobStoreRepository() == currentRepository) {
            return lastKnownState.blobContainer();
        }
        return this.refreshAndGet();
    }

    private synchronized BlobContainer refreshAndGet() {
        BlobStoreRepository currentRepository = this.repositorySupplier.get();
        if (this.lastKnownState.blobStoreRepository() == currentRepository) {
            return this.lastKnownState.blobContainer();
        }
        logger.debug("creating new blob container [{}][{}][{}]", (Object)currentRepository.getMetadata().name(), (Object)this.indexId, (Object)this.shardId);
        RateLimitingBlobContainer newContainer = new RateLimitingBlobContainer(currentRepository, currentRepository.shardContainer(this.indexId, this.shardId));
        this.lastKnownState = new LastKnownState(currentRepository, (BlobContainer)newContainer);
        return newContainer;
    }

    private record LastKnownState(BlobStoreRepository blobStoreRepository, BlobContainer blobContainer) {
    }

    private static class RateLimitingBlobContainer
    extends FilterBlobContainer {
        private final BlobStoreRepository blobStoreRepository;

        RateLimitingBlobContainer(BlobStoreRepository blobStoreRepository, BlobContainer blobContainer) {
            super(blobContainer);
            this.blobStoreRepository = blobStoreRepository;
        }

        protected BlobContainer wrapChild(BlobContainer child) {
            return new RateLimitingBlobContainer(this.blobStoreRepository, child);
        }

        public InputStream readBlob(OperationPurpose purpose, String blobName) throws IOException {
            return this.blobStoreRepository.maybeRateLimitRestores(super.readBlob(purpose, blobName));
        }

        public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
            return this.blobStoreRepository.maybeRateLimitRestores(super.readBlob(purpose, blobName, position, length));
        }
    }
}

