/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.querydsl.agg.DefaultAggSourceLeafAgg;

public class PercentilesAgg
extends DefaultAggSourceLeafAgg {
    private final List<Double> percents;
    private final PercentilesConfig percentilesConfig;

    public PercentilesAgg(String id, AggSource source, List<Double> percents, PercentilesConfig percentilesConfig) {
        super(id, source);
        this.percents = percents;
        this.percentilesConfig = percentilesConfig;
    }

    @Override
    Function<String, ValuesSourceAggregationBuilder<?>> builder() {
        return s -> AggregationBuilders.percentiles((String)s).percentiles(this.percents.stream().mapToDouble(Double::doubleValue).toArray()).percentilesConfig(this.percentilesConfig);
    }
}

