/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.ConcurrentHistogram;
import org.HdrHistogram.Histogram;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class LongMetric {
    private final Histogram values = new ConcurrentHistogram(2);
    private static final int SIGNIFICANT_DIGITS = 2;

    LongMetric() {
    }

    void record(long v) {
        this.values.recordValue(v);
    }

    LongMetricValue getValue() {
        return new LongMetricValue(this.values);
    }

    public static final class LongMetricValue
    implements Writeable {
        private final Histogram values;

        public LongMetricValue(Histogram values) {
            this.values = values.copy();
        }

        public LongMetricValue(LongMetricValue v) {
            this.values = v.values.copy();
        }

        LongMetricValue() {
            this.values = new Histogram(2);
        }

        public void add(LongMetricValue v) {
            this.values.add((AbstractHistogram)v.values);
        }

        public static LongMetricValue fromStream(StreamInput in) throws IOException {
            byte[] b = in.readByteArray();
            ByteBuffer bb = ByteBuffer.wrap(b);
            try {
                Histogram dh = Histogram.decodeFromCompressedByteBuffer((ByteBuffer)bb, (long)1L);
                dh.setAutoResize(true);
                return new LongMetricValue(dh);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            ByteBuffer b = ByteBuffer.allocate(this.values.getNeededByteBufferCapacity());
            this.values.encodeIntoCompressedByteBuffer(b);
            int size = b.position();
            out.writeVInt(size);
            out.writeBytes(b.array(), 0, size);
        }

        public long count() {
            return this.values.getTotalCount();
        }

        public long max() {
            return this.values.getMaxValue();
        }

        public long avg() {
            return (long)Math.ceil(this.values.getMean());
        }

        public long p90() {
            return this.values.getValueAtPercentile(90.0);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LongMetricValue that = (LongMetricValue)obj;
            return this.values.equals((Object)that.values);
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }

        public String toString() {
            return "LongMetricValue[count=" + this.count() + ", max=" + this.max() + ", avg=" + this.avg() + "]";
        }
    }
}

