/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotStats
implements Writeable,
ToXContentObject {
    private long startTime;
    private long time;
    private int incrementalFileCount;
    private int totalFileCount;
    private int processedFileCount;
    private long incrementalSize;
    private long totalSize;
    private long processedSize;

    SnapshotStats() {
    }

    SnapshotStats(StreamInput in) throws IOException {
        this.startTime = in.readVLong();
        this.time = in.readVLong();
        this.incrementalFileCount = in.readVInt();
        this.processedFileCount = in.readVInt();
        this.incrementalSize = in.readVLong();
        this.processedSize = in.readVLong();
        this.totalFileCount = in.readVInt();
        this.totalSize = in.readVLong();
    }

    SnapshotStats(long startTime, long time, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize) {
        this.startTime = startTime;
        this.time = time;
        assert (time >= 0L) : "Tried to initialize snapshot stats with negative total time [" + time + "]";
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.processedFileCount = processedFileCount;
        this.incrementalSize = incrementalSize;
        this.totalSize = totalSize;
        this.processedSize = processedSize;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTime() {
        return this.time;
    }

    public int getIncrementalFileCount() {
        return this.incrementalFileCount;
    }

    public int getTotalFileCount() {
        return this.totalFileCount;
    }

    public int getProcessedFileCount() {
        return this.processedFileCount;
    }

    public long getIncrementalSize() {
        return this.incrementalSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getProcessedSize() {
        return this.processedSize;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.startTime);
        out.writeVLong(this.time);
        out.writeVInt(this.incrementalFileCount);
        out.writeVInt(this.processedFileCount);
        out.writeVLong(this.incrementalSize);
        out.writeVLong(this.processedSize);
        out.writeVInt(this.totalFileCount);
        out.writeVLong(this.totalSize);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("incremental");
        builder.field("file_count", this.getIncrementalFileCount());
        builder.humanReadableField("size_in_bytes", "size", (Object)ByteSizeValue.ofBytes(this.getIncrementalSize()));
        builder.endObject();
        if (this.getProcessedFileCount() != this.getIncrementalFileCount()) {
            builder.startObject("processed");
            builder.field("file_count", this.getProcessedFileCount());
            builder.humanReadableField("size_in_bytes", "size", (Object)ByteSizeValue.ofBytes(this.getProcessedSize()));
            builder.endObject();
        }
        builder.startObject("total");
        builder.field("file_count", this.getTotalFileCount());
        builder.humanReadableField("size_in_bytes", "size", (Object)ByteSizeValue.ofBytes(this.getTotalSize()));
        builder.endObject();
        builder.field("start_time_in_millis", this.getStartTime());
        builder.humanReadableField("time_in_millis", "time", (Object)new TimeValue(this.getTime()));
        return builder.endObject();
    }

    public static SnapshotStats fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        long startTime = 0L;
        long time = 0L;
        int incrementalFileCount = 0;
        int totalFileCount = 0;
        int processedFileCount = 0;
        long incrementalSize = 0L;
        long totalSize = 0L;
        long processedSize = 0L;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String innerName;
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String currentName = parser.currentName();
            token = parser.nextToken();
            if (currentName.equals("incremental")) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                    innerName = parser.currentName();
                    token = parser.nextToken();
                    if (innerName.equals("file_count")) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                        incrementalFileCount = parser.intValue();
                        continue;
                    }
                    if (innerName.equals("size_in_bytes")) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                        incrementalSize = parser.longValue();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) continue;
                    parser.skipChildren();
                }
                continue;
            }
            if (currentName.equals("processed")) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                    innerName = parser.currentName();
                    token = parser.nextToken();
                    if (innerName.equals("file_count")) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                        processedFileCount = parser.intValue();
                        continue;
                    }
                    if (innerName.equals("size_in_bytes")) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                        processedSize = parser.longValue();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) continue;
                    parser.skipChildren();
                }
                continue;
            }
            if (currentName.equals("total")) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                    innerName = parser.currentName();
                    token = parser.nextToken();
                    if (innerName.equals("file_count")) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                        totalFileCount = parser.intValue();
                        continue;
                    }
                    if (innerName.equals("size_in_bytes")) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                        totalSize = parser.longValue();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) continue;
                    parser.skipChildren();
                }
                continue;
            }
            if (currentName.equals("start_time_in_millis")) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                startTime = parser.longValue();
                continue;
            }
            if (currentName.equals("time_in_millis")) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                time = parser.longValue();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return new SnapshotStats(startTime, time, incrementalFileCount, totalFileCount, processedFileCount, incrementalSize, totalSize, processedSize);
    }

    void add(SnapshotStats stats, boolean updateTimestamps) {
        this.incrementalFileCount += stats.incrementalFileCount;
        this.totalFileCount += stats.totalFileCount;
        this.processedFileCount += stats.processedFileCount;
        this.incrementalSize += stats.incrementalSize;
        this.totalSize += stats.totalSize;
        this.processedSize += stats.processedSize;
        if (this.startTime == 0L) {
            this.startTime = stats.startTime;
            this.time = stats.time;
        } else if (updateTimestamps) {
            long endTime = Math.max(this.startTime + this.time, stats.startTime + stats.time);
            this.startTime = Math.min(this.startTime, stats.startTime);
            this.time = endTime - this.startTime;
        }
        assert (this.time >= 0L) : "Update with [" + Strings.toString((ToXContent)stats) + "][" + updateTimestamps + "] resulted in negative total time [" + this.time + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotStats that = (SnapshotStats)o;
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        if (this.incrementalFileCount != that.incrementalFileCount) {
            return false;
        }
        if (this.totalFileCount != that.totalFileCount) {
            return false;
        }
        if (this.processedFileCount != that.processedFileCount) {
            return false;
        }
        if (this.incrementalSize != that.incrementalSize) {
            return false;
        }
        if (this.totalSize != that.totalSize) {
            return false;
        }
        return this.processedSize == that.processedSize;
    }

    public int hashCode() {
        int result = (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + this.incrementalFileCount;
        result = 31 * result + this.totalFileCount;
        result = 31 * result + this.processedFileCount;
        result = 31 * result + (int)(this.incrementalSize ^ this.incrementalSize >>> 32);
        result = 31 * result + (int)(this.totalSize ^ this.totalSize >>> 32);
        result = 31 * result + (int)(this.processedSize ^ this.processedSize >>> 32);
        return result;
    }

    static final class Fields {
        static final String STATS = "stats";
        static final String INCREMENTAL = "incremental";
        static final String PROCESSED = "processed";
        static final String TOTAL = "total";
        static final String FILE_COUNT = "file_count";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String START_TIME_IN_MILLIS = "start_time_in_millis";
        static final String TIME_IN_MILLIS = "time_in_millis";
        static final String TIME = "time";

        Fields() {
        }
    }
}

