/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Foldables;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.querydsl.query.MatchAll;
import org.elasticsearch.xpack.esql.core.querydsl.query.NotQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.RangeQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.TermQuery;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.versionfield.Version;

public abstract class EsqlBinaryComparison
extends BinaryComparison
implements EvaluatorMapper,
TranslationAware.SingleValueTranslationAware {
    private static final Logger logger = LogManager.getLogger(EsqlBinaryComparison.class);
    private final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap;
    private final BinaryComparisonOperation functionType;
    private final EsqlArithmeticOperation.BinaryEvaluator nanosToMillisEvaluator;
    private final EsqlArithmeticOperation.BinaryEvaluator millisToNanosEvaluator;
    private static final BigDecimal HALF_FLOAT_MAX = BigDecimal.valueOf(65504L);
    private static final BigDecimal UNSIGNED_LONG_MAX = BigDecimal.valueOf(2L).pow(64).subtract(BigDecimal.ONE);

    protected EsqlBinaryComparison(Source source, Expression left, Expression right, BinaryComparisonOperation operation, Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap, EsqlArithmeticOperation.BinaryEvaluator nanosToMillisEvaluator, EsqlArithmeticOperation.BinaryEvaluator millisToNanosEvaluator) {
        this(source, left, right, operation, null, evaluatorMap, nanosToMillisEvaluator, millisToNanosEvaluator);
    }

    protected EsqlBinaryComparison(Source source, Expression left, Expression right, BinaryComparisonOperation operation, ZoneId zoneId, Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap, EsqlArithmeticOperation.BinaryEvaluator nanosToMillisEvaluator, EsqlArithmeticOperation.BinaryEvaluator millisToNanosEvaluator) {
        super(source, left, right, operation.shim, zoneId);
        this.evaluatorMap = evaluatorMap;
        this.functionType = operation;
        this.nanosToMillisEvaluator = nanosToMillisEvaluator;
        this.millisToNanosEvaluator = millisToNanosEvaluator;
    }

    public static EsqlBinaryComparison readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        BinaryComparisonOperation operation = BinaryComparisonOperation.readFromStream(in);
        Expression left = (Expression)in.readNamedWriteable(Expression.class);
        Expression right = (Expression)in.readNamedWriteable(Expression.class);
        ZoneId zoneId = in.readOptionalZoneId();
        return operation.buildNewInstance(source, left, right);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        this.functionType.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
        out.writeOptionalZoneId(this.zoneId());
    }

    public BinaryComparisonOperation getFunctionType() {
        return this.functionType;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory rhs;
        EvalOperator.ExpressionEvaluator.Factory lhs;
        if (this.left().dataType() == DataType.DATE_NANOS && this.right().dataType() == DataType.DATETIME) {
            EvalOperator.ExpressionEvaluator.Factory lhs2 = toEvaluator.apply(this.left());
            EvalOperator.ExpressionEvaluator.Factory rhs2 = toEvaluator.apply(this.right());
            return this.nanosToMillisEvaluator.apply(this.source(), lhs2, rhs2);
        }
        if (this.left().dataType() == DataType.DATETIME && this.right().dataType() == DataType.DATE_NANOS) {
            EvalOperator.ExpressionEvaluator.Factory lhs3 = toEvaluator.apply(this.left());
            EvalOperator.ExpressionEvaluator.Factory rhs3 = toEvaluator.apply(this.right());
            return this.millisToNanosEvaluator.apply(this.source(), lhs3, rhs3);
        }
        DataType commonType = EsqlDataTypeConverter.commonType(this.left().dataType(), this.right().dataType());
        if (commonType.isNumeric()) {
            lhs = Cast.cast(this.source(), this.left().dataType(), commonType, toEvaluator.apply(this.left()));
            rhs = Cast.cast(this.source(), this.right().dataType(), commonType, toEvaluator.apply(this.right()));
        } else {
            lhs = toEvaluator.apply(this.left());
            rhs = toEvaluator.apply(this.right());
        }
        if (!this.evaluatorMap.containsKey(commonType)) {
            throw new EsqlIllegalArgumentException("Unsupported type " + String.valueOf(this.left().dataType()));
        }
        return this.evaluatorMap.get(commonType).apply(this.source(), lhs, rhs);
    }

    public Boolean fold(FoldContext ctx) {
        return (Boolean)EvaluatorMapper.super.fold(this.source(), ctx);
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution typeResolution = super.resolveType();
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        return this.checkCompatibility();
    }

    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isType((Expression)e, this.evaluatorMap::containsKey, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal, (String[])((String[])this.evaluatorMap.keySet().stream().map(DataType::typeName).sorted().toArray(String[]::new)));
    }

    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (rightType == DataType.UNSIGNED_LONG && !(leftType == DataType.UNSIGNED_LONG || leftType == DataType.NULL) || leftType == DataType.UNSIGNED_LONG && !(rightType == DataType.UNSIGNED_LONG || rightType == DataType.NULL)) {
            return new Expression.TypeResolution(EsqlBinaryComparison.formatIncompatibleTypesMessage(this.left().dataType(), this.right().dataType(), this.sourceText()));
        }
        if (leftType.isNumeric() && rightType.isNumeric() || DataType.isString((DataType)leftType) && DataType.isString((DataType)rightType) || leftType.isDate() && rightType.isDate() || leftType.equals((Object)rightType) || DataType.isNull((DataType)leftType) || DataType.isNull((DataType)rightType)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(EsqlBinaryComparison.formatIncompatibleTypesMessage(this.left().dataType(), this.right().dataType(), this.sourceText()));
    }

    public static String formatIncompatibleTypesMessage(DataType leftType, DataType rightType, String sourceText) {
        if (leftType.equals((Object)DataType.UNSIGNED_LONG)) {
            return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [unsigned_long] and second is [{}]. [unsigned_long] can only be operated on together with another [unsigned_long]", (Object[])new Object[]{sourceText, rightType.typeName()});
        }
        if (rightType.equals((Object)DataType.UNSIGNED_LONG)) {
            return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [{}] and second is [unsigned_long]. [unsigned_long] can only be operated on together with another [unsigned_long]", (Object[])new Object[]{sourceText, leftType.typeName()});
        }
        return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [{}] so second argument must also be [{}] but was [{}]", (Object[])new Object[]{sourceText, leftType.isNumeric() ? "numeric" : leftType.typeName(), leftType.isNumeric() ? "numeric" : leftType.typeName(), rightType.typeName()});
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        if (this.right().foldable()) {
            if (pushdownPredicates.isPushableFieldAttribute(this.left())) {
                return true;
            }
            if (LucenePushdownPredicates.isPushableMetadataAttribute(this.left())) {
                return this instanceof Equals || this instanceof NotEquals;
            }
        }
        return false;
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        Check.isTrue((boolean)this.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{this.right().sourceLocation().getLineNumber(), this.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)this.right()), this.symbol()});
        Query translated = this.translateOutOfRangeComparisons();
        return translated != null ? translated : this.translate(handler);
    }

    @Override
    public Expression singleValueField() {
        return this.left();
    }

    private Query translate(TranslatorHandler handler) {
        TypedAttribute attribute = LucenePushdownPredicates.checkIsPushableAttribute(this.left());
        String name = handler.nameOf((Expression)attribute);
        Object value = Foldables.valueOf((FoldContext)FoldContext.small(), (Expression)this.right());
        String format = null;
        boolean isDateLiteralComparison = false;
        logger.trace("Translating binary comparison with right: [{}<{}>], left: [{}<{}>], attribute: [{}<{}>]", new Object[]{this.right(), this.right().dataType(), this.left(), this.left().dataType(), attribute, attribute.dataType()});
        if (value instanceof ZonedDateTime || value instanceof OffsetTime) {
            DateFormatter formatter;
            if (value instanceof ZonedDateTime) {
                formatter = switch (this.right().dataType()) {
                    case DataType.DATETIME -> EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER;
                    case DataType.DATE_NANOS -> EsqlDataTypeConverter.DEFAULT_DATE_NANOS_FORMATTER;
                    default -> throw new EsqlIllegalArgumentException("Found date value in non-date type comparison");
                };
                value = formatter.format((TemporalAccessor)((ZonedDateTime)value));
            } else {
                formatter = EsqlDataTypeConverter.HOUR_MINUTE_SECOND;
                value = formatter.format((TemporalAccessor)((OffsetTime)value));
            }
            format = formatter.pattern();
            isDateLiteralComparison = true;
        } else if (attribute.dataType() == DataType.IP && value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            value = EsqlDataTypeConverter.ipToString(bytesRef);
        } else if (attribute.dataType() == DataType.VERSION) {
            if (value instanceof BytesRef) {
                BytesRef bytesRef = (BytesRef)value;
                value = EsqlDataTypeConverter.versionToString(bytesRef);
            } else if (value instanceof Version) {
                Version version = (Version)value;
                value = EsqlDataTypeConverter.versionToString(version);
            }
        } else if (attribute.dataType() == DataType.UNSIGNED_LONG && value instanceof Long) {
            Long ul = (Long)value;
            value = NumericUtils.unsignedLongAsNumber((long)ul);
        }
        ZoneId zoneId = null;
        if (attribute.dataType() == DataType.DATETIME) {
            zoneId = this.zoneId();
            value = EsqlDataTypeConverter.dateWithTypeToString((Long)value, this.right().dataType());
            format = EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER.pattern();
        } else if (attribute.dataType() == DataType.DATE_NANOS) {
            zoneId = this.zoneId();
            value = EsqlDataTypeConverter.dateWithTypeToString((Long)value, this.right().dataType());
            format = EsqlDataTypeConverter.DEFAULT_DATE_NANOS_FORMATTER.pattern();
        }
        if (this instanceof GreaterThan) {
            return new RangeQuery(this.source(), name, value, false, null, false, format, zoneId);
        }
        if (this instanceof GreaterThanOrEqual) {
            return new RangeQuery(this.source(), name, value, true, null, false, format, zoneId);
        }
        if (this instanceof LessThan) {
            return new RangeQuery(this.source(), name, null, false, value, false, format, zoneId);
        }
        if (this instanceof LessThanOrEqual) {
            return new RangeQuery(this.source(), name, null, false, value, true, format, zoneId);
        }
        if (this instanceof Equals || this instanceof NotEquals) {
            name = LucenePushdownPredicates.pushableAttributeName(attribute);
            Object query = isDateLiteralComparison ? new RangeQuery(this.source(), name, value, true, value, true, format, zoneId) : new TermQuery(this.source(), name, value);
            if (this instanceof NotEquals) {
                query = new NotQuery(this.source(), (Query)query);
            }
            return query;
        }
        throw new QlIllegalArgumentException("Don't know how to translate binary comparison [{}] in [{}]", new Object[]{this.right().nodeString(), this.toString()});
    }

    private Query translateOutOfRangeComparisons() {
        boolean matchAllOrNone;
        Number num;
        if (!(this.left() instanceof FieldAttribute) || !this.left().dataType().isNumeric()) {
            return null;
        }
        Object value = Foldables.valueOf((FoldContext)FoldContext.small(), (Expression)this.right());
        if (value instanceof List) {
            return new MatchAll(this.source()).negate(this.source());
        }
        DataType valueType = this.right().dataType();
        DataType attributeDataType = this.left().dataType();
        if (valueType == DataType.UNSIGNED_LONG && value instanceof Long) {
            Long ul = (Long)value;
            value = NumericUtils.unsignedLongAsNumber((long)ul);
        }
        if (EsqlBinaryComparison.isInRange(attributeDataType, valueType, num = (Number)value)) {
            return null;
        }
        if (Double.isNaN(((Number)value).doubleValue())) {
            return new MatchAll(this.source()).negate(this.source());
        }
        if (this instanceof GreaterThan || this instanceof GreaterThanOrEqual) {
            matchAllOrNone = !(num.doubleValue() > 0.0);
        } else if (this instanceof LessThan || this instanceof LessThanOrEqual) {
            matchAllOrNone = num.doubleValue() > 0.0;
        } else if (this instanceof Equals) {
            matchAllOrNone = false;
        } else if (this instanceof NotEquals) {
            matchAllOrNone = true;
        } else {
            throw new QlIllegalArgumentException("Unknown binary comparison [{}]", new Object[]{this.toString()});
        }
        return matchAllOrNone ? new MatchAll(this.source()) : new MatchAll(this.source()).negate(this.source());
    }

    private static boolean isInRange(DataType numericFieldDataType, DataType valueDataType, Number value) {
        BigDecimal maxValue;
        BigDecimal minValue;
        BigDecimal decimalValue;
        double doubleValue = value.doubleValue();
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return false;
        }
        if (value instanceof BigInteger) {
            BigInteger bigIntValue = (BigInteger)value;
            decimalValue = new BigDecimal(bigIntValue);
        } else {
            BigDecimal bigDecimal = decimalValue = valueDataType.isRationalNumber() ? BigDecimal.valueOf(doubleValue) : BigDecimal.valueOf(value.longValue());
        }
        if (numericFieldDataType == DataType.BYTE) {
            minValue = BigDecimal.valueOf(-128L);
            maxValue = BigDecimal.valueOf(127L);
        } else if (numericFieldDataType == DataType.SHORT) {
            minValue = BigDecimal.valueOf(-32768L);
            maxValue = BigDecimal.valueOf(32767L);
        } else if (numericFieldDataType == DataType.INTEGER) {
            minValue = BigDecimal.valueOf(Integer.MIN_VALUE);
            maxValue = BigDecimal.valueOf(Integer.MAX_VALUE);
        } else if (numericFieldDataType == DataType.LONG) {
            minValue = BigDecimal.valueOf(Long.MIN_VALUE);
            maxValue = BigDecimal.valueOf(Long.MAX_VALUE);
        } else if (numericFieldDataType == DataType.UNSIGNED_LONG) {
            minValue = BigDecimal.ZERO;
            maxValue = UNSIGNED_LONG_MAX;
        } else if (numericFieldDataType == DataType.HALF_FLOAT) {
            minValue = HALF_FLOAT_MAX.negate();
            maxValue = HALF_FLOAT_MAX;
        } else if (numericFieldDataType == DataType.FLOAT) {
            minValue = BigDecimal.valueOf(-3.4028234663852886E38);
            maxValue = BigDecimal.valueOf(3.4028234663852886E38);
        } else if (numericFieldDataType == DataType.DOUBLE || numericFieldDataType == DataType.SCALED_FLOAT) {
            minValue = BigDecimal.valueOf(-1.7976931348623157E308);
            maxValue = BigDecimal.valueOf(Double.MAX_VALUE);
        } else {
            throw new QlIllegalArgumentException("Data type [{}] unsupported for numeric range check", new Object[]{numericFieldDataType});
        }
        return minValue.compareTo(decimalValue) <= 0 && maxValue.compareTo(decimalValue) >= 0;
    }

    public static enum BinaryComparisonOperation implements Writeable
    {
        EQ(0, "==", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.EQ, Equals::new),
        NEQ(2, "!=", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.NEQ, NotEquals::new),
        GT(3, ">", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.GT, GreaterThan::new),
        GTE(4, ">=", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.GTE, GreaterThanOrEqual::new),
        LT(5, "<", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.LT, LessThan::new),
        LTE(6, "<=", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.LTE, LessThanOrEqual::new);

        private final int id;
        private final String symbol;
        private final org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation shim;
        private final BinaryOperatorConstructor constructor;

        private BinaryComparisonOperation(int id, String symbol, org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation shim, BinaryOperatorConstructor constructor) {
            this.id = id;
            this.symbol = symbol;
            this.shim = shim;
            this.constructor = constructor;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
        }

        public static BinaryComparisonOperation readFromStream(StreamInput in) throws IOException {
            int id = in.readVInt();
            for (BinaryComparisonOperation op : BinaryComparisonOperation.values()) {
                if (op.id != id) continue;
                return op;
            }
            throw new IOException("No BinaryComparisonOperation found for id [" + id + "]");
        }

        public String symbol() {
            return this.symbol;
        }

        public EsqlBinaryComparison buildNewInstance(Source source, Expression lhs, Expression rhs) {
            return this.constructor.apply(source, lhs, rhs);
        }
    }

    @FunctionalInterface
    public static interface BinaryOperatorConstructor {
        public EsqlBinaryComparison apply(Source var1, Expression var2, Expression var3);
    }
}

