/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import org.apache.arrow.memory.BoundsChecking;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class LargeMemoryUtil {
    private LargeMemoryUtil() {
    }

    public static @UnknownKeyFor @NonNull @Initialized int checkedCastToInt(@UnknownKeyFor @NonNull @Initialized long length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            return Math.toIntExact(length);
        }
        return (int)length;
    }

    public static @UnknownKeyFor @NonNull @Initialized int capAtMaxInt(@UnknownKeyFor @NonNull @Initialized long length) {
        return (int)Math.min(length, Integer.MAX_VALUE);
    }
}

