/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.BytesRefArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class MaxBytesRefAggregator {
    MaxBytesRefAggregator() {
    }

    private static boolean isBetter(BytesRef value, BytesRef otherValue) {
        return value.compareTo(otherValue) > 0;
    }

    public static SingleState initSingle(DriverContext driverContext) {
        return new SingleState(driverContext.breaker());
    }

    public static void combine(SingleState state, BytesRef value) {
        state.add(value);
    }

    public static void combineIntermediate(SingleState state, BytesRef value, boolean seen) {
        if (seen) {
            MaxBytesRefAggregator.combine(state, value);
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext);
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays(), driverContext.breaker());
    }

    public static void combine(GroupingState state, int groupId, BytesRef value) {
        state.add(groupId, value);
    }

    public static void combineIntermediate(GroupingState state, int groupId, BytesRef value, boolean seen) {
        if (seen) {
            state.add(groupId, value);
        }
    }

    public static void combineStates(GroupingState state, int groupId, GroupingState otherState, int otherGroupId) {
        state.combine(groupId, otherState, otherGroupId);
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(selected, driverContext);
    }

    public static class SingleState
    implements AggregatorState {
        private final BreakingBytesRefBuilder internalState;
        private boolean seen;

        private SingleState(CircuitBreaker breaker) {
            this.internalState = new BreakingBytesRefBuilder(breaker, "max_bytes_ref_aggregator");
            this.seen = false;
        }

        public void add(BytesRef value) {
            if (!this.seen || MaxBytesRefAggregator.isBetter(value, this.internalState.bytesRefView())) {
                this.seen = true;
                this.internalState.grow(value.length);
                this.internalState.setLength(value.length);
                System.arraycopy(value.bytes, value.offset, this.internalState.bytes(), 0, value.length);
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = driverContext.blockFactory().newConstantBytesRefBlockWith(this.internalState.bytesRefView(), 1);
            blocks[offset + 1] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
        }

        Block toBlock(DriverContext driverContext) {
            if (!this.seen) {
                return driverContext.blockFactory().newConstantNullBlock(1);
            }
            return driverContext.blockFactory().newConstantBytesRefBlockWith(this.internalState.bytesRefView(), 1);
        }

        public void close() {
            Releasables.close((Releasable)this.internalState);
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final BytesRefArrayState internalState;

        private GroupingState(BigArrays bigArrays, CircuitBreaker breaker) {
            this.internalState = new BytesRefArrayState(bigArrays, breaker, "max_bytes_ref_grouping_aggregator");
        }

        public void add(int groupId, BytesRef value) {
            if (!this.internalState.hasValue(groupId) || MaxBytesRefAggregator.isBetter(value, this.internalState.get(groupId))) {
                this.internalState.set(groupId, value);
            }
        }

        public void combine(int groupId, GroupingState otherState, int otherGroupId) {
            if (otherState.internalState.hasValue(otherGroupId)) {
                this.add(groupId, otherState.internalState.get(otherGroupId));
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            this.internalState.toIntermediate(blocks, offset, selected, driverContext);
        }

        Block toBlock(IntVector selected, DriverContext driverContext) {
            return this.internalState.toValuesBlock(selected, driverContext);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
            this.internalState.enableGroupIdTracking(seen);
        }

        public void close() {
            Releasables.close((Releasable)this.internalState);
        }
    }
}

