/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.cohere.CohereResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.CohereRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.request.cohere.completion.CohereCompletionRequest;
import org.elasticsearch.xpack.inference.external.response.cohere.CohereCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;

public class CohereCompletionRequestManager
extends CohereRequestManager {
    private static final Logger logger = LogManager.getLogger(CohereCompletionRequestManager.class);
    private static final ResponseHandler HANDLER = CohereCompletionRequestManager.createCompletionHandler();
    private final CohereCompletionModel model;

    private static ResponseHandler createCompletionHandler() {
        return new CohereResponseHandler("cohere completion", CohereCompletionResponseEntity::fromResponse, true);
    }

    public static CohereCompletionRequestManager of(CohereCompletionModel model, ThreadPool threadPool) {
        return new CohereCompletionRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(threadPool));
    }

    private CohereCompletionRequestManager(CohereCompletionModel model, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        ChatCompletionInput chatCompletionInput = inferenceInputs.castTo(ChatCompletionInput.class);
        List<String> inputs = chatCompletionInput.getInputs();
        boolean stream = chatCompletionInput.stream();
        CohereCompletionRequest request = new CohereCompletionRequest(inputs, this.model, stream);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }
}

