/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.grok.PatternBank;

public class GrokBuiltinPatterns {
    public static final String ECS_COMPATIBILITY_DISABLED = "disabled";
    public static final String ECS_COMPATIBILITY_V1 = "v1";
    public static final List<String> ECS_COMPATIBILITY_MODES = List.of("disabled", "v1");
    private static PatternBank LEGACY_PATTERNS;
    private static PatternBank ECS_V1_PATTERNS;

    public static synchronized PatternBank legacyPatterns() {
        return GrokBuiltinPatterns.get(false);
    }

    public static synchronized PatternBank ecsV1Patterns() {
        return GrokBuiltinPatterns.get(true);
    }

    public static synchronized PatternBank get(boolean ecsCompatibility) {
        if (ecsCompatibility) {
            if (ECS_V1_PATTERNS == null) {
                ECS_V1_PATTERNS = GrokBuiltinPatterns.loadEcsPatterns();
            }
            return ECS_V1_PATTERNS;
        }
        if (LEGACY_PATTERNS == null) {
            LEGACY_PATTERNS = GrokBuiltinPatterns.loadLegacyPatterns();
        }
        return LEGACY_PATTERNS;
    }

    public static PatternBank get(String ecsCompatibility) {
        if (GrokBuiltinPatterns.isValidEcsCompatibilityMode(ecsCompatibility)) {
            return GrokBuiltinPatterns.get(ECS_COMPATIBILITY_V1.equals(ecsCompatibility));
        }
        throw new IllegalArgumentException("unsupported ECS compatibility mode [" + ecsCompatibility + "]");
    }

    public static boolean isValidEcsCompatibilityMode(String ecsCompatibility) {
        return ECS_COMPATIBILITY_MODES.contains(ecsCompatibility);
    }

    private static PatternBank loadLegacyPatterns() {
        List<String> patternNames = List.of("aws", "bacula", "bind", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "httpd", "java", "junos", "linux-syslog", "maven", "mcollective-patterns", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby", "squid");
        return GrokBuiltinPatterns.loadPatternsFromDirectory(patternNames, "/patterns/legacy/");
    }

    private static PatternBank loadEcsPatterns() {
        List<String> patternNames = List.of("aws", "bacula", "bind", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "httpd", "java", "junos", "linux-syslog", "maven", "mcollective", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby", "squid", "zeek");
        return GrokBuiltinPatterns.loadPatternsFromDirectory(patternNames, "/patterns/ecs-v1/");
    }

    private static PatternBank loadPatternsFromDirectory(List<String> patternNames, String directory) {
        LinkedHashMap<String, String> builtinPatterns = new LinkedHashMap<String, String>();
        for (String pattern : patternNames) {
            try {
                InputStream is = GrokBuiltinPatterns.class.getResourceAsStream(directory + pattern);
                try {
                    GrokBuiltinPatterns.loadPatternsFromFile(builtinPatterns, is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("failed to load built-in patterns", e);
            }
        }
        return new PatternBank(builtinPatterns);
    }

    private static void loadPatternsFromFile(Map<String, String> patternBank, InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String[] parts;
            String trimmedLine = line.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("#") || trimmedLine.length() == 0 || (parts = trimmedLine.split("\\s+", 2)).length != 2) continue;
            patternBank.put(parts[0], parts[1]);
        }
    }
}

